-- |
-- Module:     Control.Wire.Prefab.Clock
-- Copyright:  (c) 2011 Ertugrul Soeylemez
-- License:    BSD3
-- Maintainer: Ertugrul Soeylemez <es@ertes.de>
--
-- Various clocks.

module Control.Wire.Prefab.Clock
    ( -- * Clock wires
      dtime,
      sysTime,
      time
    )
    where

import Control.Wire.Prefab.Simple
import Control.Wire.Trans.Clock
import Control.Wire.Types


-- | Time deltas starting from the time of the first instant.

dtime :: (WirePure (>~), WWithDT t (>~)) => Wire e (>~) a t
dtime = passDT identity


-- | Global time.  Independent of switching.  *System* refers to the
-- wire system, not the operating system, so this does not
-- necessarily refer to OS time.

sysTime :: (WirePure (>~), WWithSysTime t (>~)) => Wire e (>~) a t
sysTime = passSysTime identity


-- | Local time.  Starts at the 'AdditiveGroup' notion of zero when
-- switching in.

time :: (WirePure (>~), WWithTime t (>~)) => Wire e (>~) a t
time = passTime identity
