{-# OPTIONS_HADDOCK hide #-}
-- -*-haskell-*-
-- -------------------- automatically generated file - do not edit ----------
--  Object hierarchy for the GIMP Toolkit (GTK) Binding for Haskell
--
--  Author : Axel Simon
--
--  Copyright (C) 2001-2005 Axel Simon
--
--  This library is free software; you can redistribute it and/or
--  modify it under the terms of the GNU Lesser General Public
--  License as published by the Free Software Foundation; either
--  version 2.1 of the License, or (at your option) any later version.
--
--  This library is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
--  Lesser General Public License for more details.
--
-- #hide

-- |
-- Maintainer  : gtk2hs-users@lists.sourceforge.net
-- Stability   : provisional
-- Portability : portable (depends on GHC)
--
-- This file reflects the Gtk+ object hierarchy in terms of Haskell classes.
--
-- Note: the mk... functions were originally meant to simply be an alias
-- for the constructor. However, in order to communicate the destructor
-- of an object to objectNew, the mk... functions are now a tuple containing
-- Haskell constructor and the destructor function pointer. This hack avoids
-- changing all modules that simply pass mk... to objectNew.
--
module System.Gnome.VFS.Types (

  module Graphics.UI.GtkInternals,
  Volume(Volume), VolumeClass,
  toVolume, 
  mkVolume, unVolume,
  castToVolume, gTypeVolume,
  Drive(Drive), DriveClass,
  toDrive, 
  mkDrive, unDrive,
  castToDrive, gTypeDrive,
  VolumeMonitor(VolumeMonitor), VolumeMonitorClass,
  toVolumeMonitor, 
  mkVolumeMonitor, unVolumeMonitor,
  castToVolumeMonitor, gTypeVolumeMonitor
  ) where

import Foreign.ForeignPtr (ForeignPtr, castForeignPtr, unsafeForeignPtrToPtr)
import Foreign.C.Types    (CULong, CUInt)
import System.Glib.GType	(GType, typeInstanceIsA)
import Graphics.UI.GtkInternals

{# context lib="gtk" prefix="gtk" #}

-- The usage of foreignPtrToPtr should be safe as the evaluation will only be
-- forced if the object is used afterwards
--
castTo :: (GObjectClass obj, GObjectClass obj') => GType -> String
                                                -> (obj -> obj')
castTo gtype objTypeName obj =
  case toGObject obj of
    gobj@(GObject objFPtr)
      | typeInstanceIsA ((unsafeForeignPtrToPtr.castForeignPtr) objFPtr) gtype
                  -> unsafeCastGObject gobj
      | otherwise -> error $ "Cannot cast object to " ++ objTypeName


-- ********************************************************************* Volume

{#pointer *GnomeVFSVolume as Volume foreign newtype #} deriving (Eq,Ord)

mkVolume = (Volume, objectUnrefFromMainloop)
unVolume (Volume o) = o

class GObjectClass o => VolumeClass o
toVolume :: VolumeClass o => o -> Volume
toVolume = unsafeCastGObject . toGObject

instance VolumeClass Volume
instance GObjectClass Volume where
  toGObject = GObject . castForeignPtr . unVolume
  unsafeCastGObject = Volume . castForeignPtr . unGObject

castToVolume :: GObjectClass obj => obj -> Volume
castToVolume = castTo gTypeVolume "Volume"

gTypeVolume :: GType
gTypeVolume =
  {# call fun unsafe gnome_vfs_volume_get_type #}

-- ********************************************************************** Drive

{#pointer *GnomeVFSDrive as Drive foreign newtype #} deriving (Eq,Ord)

mkDrive = (Drive, objectUnrefFromMainloop)
unDrive (Drive o) = o

class GObjectClass o => DriveClass o
toDrive :: DriveClass o => o -> Drive
toDrive = unsafeCastGObject . toGObject

instance DriveClass Drive
instance GObjectClass Drive where
  toGObject = GObject . castForeignPtr . unDrive
  unsafeCastGObject = Drive . castForeignPtr . unGObject

castToDrive :: GObjectClass obj => obj -> Drive
castToDrive = castTo gTypeDrive "Drive"

gTypeDrive :: GType
gTypeDrive =
  {# call fun unsafe gnome_vfs_drive_get_type #}

-- ************************************************************** VolumeMonitor

{#pointer *GnomeVFSVolumeMonitor as VolumeMonitor foreign newtype #} deriving (Eq,Ord)

mkVolumeMonitor = (VolumeMonitor, objectUnrefFromMainloop)
unVolumeMonitor (VolumeMonitor o) = o

class GObjectClass o => VolumeMonitorClass o
toVolumeMonitor :: VolumeMonitorClass o => o -> VolumeMonitor
toVolumeMonitor = unsafeCastGObject . toGObject

instance VolumeMonitorClass VolumeMonitor
instance GObjectClass VolumeMonitor where
  toGObject = GObject . castForeignPtr . unVolumeMonitor
  unsafeCastGObject = VolumeMonitor . castForeignPtr . unGObject

castToVolumeMonitor :: GObjectClass obj => obj -> VolumeMonitor
castToVolumeMonitor = castTo gTypeVolumeMonitor "VolumeMonitor"

gTypeVolumeMonitor :: GType
gTypeVolumeMonitor =
  {# call fun unsafe gnome_vfs_volume_monitor_get_type #}

