Module: gdk-internal

c-include("stddef.h");
c-include("gdk/gdk.h");
define constant <GdkPixmap*> = <GdkWindow*>;

define functional class <GdkEventKey*> (<indexable-statically-typed-pointer>) end;
define sealed domain make(singleton(<GdkEventKey*>));

define sealed method content-size
    (class == <GdkEventKey*>) => (size :: <integer>);
  c-expr(int:, "sizeof(GdkEvent)");
end method;

define constant <GdkLineStyle> = <integer>;
define constant $GDK-LINE-SOLID = 0;
define constant $GDK-LINE-ON-OFF-DASH = 1;
define constant $GDK-LINE-DOUBLE-DASH = 2;

define constant <GdkWindowHints> = <integer>;
define constant $GDK-HINT-POS = 1;
define constant $GDK-HINT-MIN-SIZE = 2;
define constant $GDK-HINT-MAX-SIZE = 4;

define functional class <GdkEventAny*> (<indexable-statically-typed-pointer>) end;
define sealed domain make(singleton(<GdkEventAny*>));

define sealed method content-size
    (class == <GdkEventAny*>) => (size :: <integer>);
  c-expr(int:, "sizeof(GdkEvent)");
end method;

define open generic type-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic type-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method type-value
    (obj :: <GdkEventAny*>)
 => (value :: <GdkEventType>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventAny", "type");
end;

define method type-value-setter
    (value :: <GdkEventType>, obj :: <GdkEventAny*>)
 => (value :: <GdkEventType>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventAny", "type") := value;
end;

define open generic window-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic window-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method window-value
    (obj :: <GdkEventAny*>)
 => (value :: <GdkWindow*>);
  make(<GdkWindow*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GdkEventAny", "window"));
end;

define method window-value-setter
    (value :: <GdkWindow*>, obj :: <GdkEventAny*>)
 => (value :: <GdkWindow*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GdkEventAny", "window")
 := value.raw-value;
  value;
end;

define constant <GdkWMFunction> = <integer>;
define constant $GDK-FUNC-ALL = 1;
define constant $GDK-FUNC-RESIZE = 2;
define constant $GDK-FUNC-MOVE = 4;
define constant $GDK-FUNC-MINIMIZE = 8;
define constant $GDK-FUNC-MAXIMIZE = 16;
define constant $GDK-FUNC-CLOSE = 32;

define constant <GdkStatus> = <integer>;
define constant $GDK-OK = 0;
define constant $GDK-ERROR = -1;
define constant $GDK-ERROR-PARAM = -2;
define constant $GDK-ERROR-FILE = -3;
define constant $GDK-ERROR-MEM = -4;

define functional class <GdkEventConfigure*> (<indexable-statically-typed-pointer>) end;
define sealed domain make(singleton(<GdkEventConfigure*>));

define sealed method content-size
    (class == <GdkEventConfigure*>) => (size :: <integer>);
  c-expr(int:, "sizeof(GdkEvent)");
end method;

define method type-value
    (obj :: <GdkEventConfigure*>)
 => (value :: <GdkEventType>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventConfigure", "type");
end;

define method type-value-setter
    (value :: <GdkEventType>, obj :: <GdkEventConfigure*>)
 => (value :: <GdkEventType>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventConfigure", "type") := value;
end;

define method window-value
    (obj :: <GdkEventConfigure*>)
 => (value :: <GdkWindow*>);
  make(<GdkWindow*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GdkEventConfigure", "window"));
end;

define method window-value-setter
    (value :: <GdkWindow*>, obj :: <GdkEventConfigure*>)
 => (value :: <GdkWindow*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GdkEventConfigure", "window")
 := value.raw-value;
  value;
end;

define open generic x-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic x-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method x-value
    (obj :: <GdkEventConfigure*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventConfigure", "x");
end;

define method x-value-setter
    (value :: <gint>, obj :: <GdkEventConfigure*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventConfigure", "x") := value;
end;

define open generic y-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic y-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method y-value
    (obj :: <GdkEventConfigure*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventConfigure", "y");
end;

define method y-value-setter
    (value :: <gint>, obj :: <GdkEventConfigure*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventConfigure", "y") := value;
end;

define open generic width-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic width-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method width-value
    (obj :: <GdkEventConfigure*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventConfigure", "width");
end;

define method width-value-setter
    (value :: <gint>, obj :: <GdkEventConfigure*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventConfigure", "width") := value;
end;

define open generic height-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic height-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method height-value
    (obj :: <GdkEventConfigure*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventConfigure", "height");
end;

define method height-value-setter
    (value :: <gint>, obj :: <GdkEventConfigure*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventConfigure", "height") := value;
end;

define functional class <GdkEventExpose*> (<indexable-statically-typed-pointer>) end;
define sealed domain make(singleton(<GdkEventExpose*>));

define sealed method content-size
    (class == <GdkEventExpose*>) => (size :: <integer>);
  c-expr(int:, "sizeof(GdkEvent)");
end method;

define method type-value
    (obj :: <GdkEventExpose*>)
 => (value :: <GdkEventType>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventExpose", "type");
end;

define method type-value-setter
    (value :: <GdkEventType>, obj :: <GdkEventExpose*>)
 => (value :: <GdkEventType>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventExpose", "type") := value;
end;

define method window-value
    (obj :: <GdkEventExpose*>)
 => (value :: <GdkWindow*>);
  make(<GdkWindow*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GdkEventExpose", "window"));
end;

define method window-value-setter
    (value :: <GdkWindow*>, obj :: <GdkEventExpose*>)
 => (value :: <GdkWindow*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GdkEventExpose", "window")
 := value.raw-value;
  value;
end;

define open generic area-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method area-value
    (obj :: <GdkEventExpose*>)
 => (value :: <GdkRectangle*>);
  make(<GdkRectangle*>,
       pointer: obj.raw-value
                  + c-expr(int:, "offsetof(GdkEventExpose, area)"));
end;

define open generic count-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic count-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method count-value
    (obj :: <GdkEventExpose*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventExpose", "count");
end;

define method count-value-setter
    (value :: <gint>, obj :: <GdkEventExpose*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventExpose", "count") := value;
end;

define functional class <GTimer*> (<indexable-statically-typed-pointer>) end;
define sealed domain make(singleton(<GTimer*>));

define sealed method content-size
    (class == <GTimer*>) => (size :: <integer>);
  c-expr(int:, "0");
end method;

define functional class <GdkRectangle*> (<indexable-statically-typed-pointer>) end;
define sealed domain make(singleton(<GdkRectangle*>));

define sealed method content-size
    (class == <GdkRectangle*>) => (size :: <integer>);
  c-expr(int:, "sizeof(GdkRectangle)");
end method;

define method x-value
    (obj :: <GdkRectangle*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkRectangle", "x");
end;

define method x-value-setter
    (value :: <gint>, obj :: <GdkRectangle*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkRectangle", "x") := value;
end;

define method y-value
    (obj :: <GdkRectangle*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkRectangle", "y");
end;

define method y-value-setter
    (value :: <gint>, obj :: <GdkRectangle*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkRectangle", "y") := value;
end;

define method width-value
    (obj :: <GdkRectangle*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkRectangle", "width");
end;

define method width-value-setter
    (value :: <guint>, obj :: <GdkRectangle*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkRectangle", "width") := value;
end;

define method height-value
    (obj :: <GdkRectangle*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkRectangle", "height");
end;

define method height-value-setter
    (value :: <guint>, obj :: <GdkRectangle*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkRectangle", "height") := value;
end;

define functional class <GdkWindow*> (<statically-typed-pointer>) end;
define sealed domain make(singleton(<GdkWindow*>));

define constant <GdkFill> = <integer>;
define constant $GDK-SOLID = 0;
define constant $GDK-TILED = 1;
define constant $GDK-STIPPLED = 2;
define constant $GDK-OPAQUE-STIPPLED = 3;

define constant <GdkPropMode> = <integer>;
define constant $GDK-PROP-MODE-REPLACE = 0;
define constant $GDK-PROP-MODE-PREPEND = 1;
define constant $GDK-PROP-MODE-APPEND = 2;

define constant <GdkWindowClass> = <integer>;
define constant $GDK-INPUT-OUTPUT = 0;
define constant $GDK-INPUT-ONLY = 1;

define constant <GdkModifierType> = <integer>;
define constant $GDK-SHIFT-MASK = 1;
define constant $GDK-LOCK-MASK = 2;
define constant $GDK-CONTROL-MASK = 4;
define constant $GDK-MOD1-MASK = 8;
define constant $GDK-MOD2-MASK = 16;
define constant $GDK-MOD3-MASK = 32;
define constant $GDK-MOD4-MASK = 64;
define constant $GDK-MOD5-MASK = 128;
define constant $GDK-BUTTON1-MASK = 256;
define constant $GDK-BUTTON2-MASK = 512;
define constant $GDK-BUTTON3-MASK = 1024;
define constant $GDK-BUTTON4-MASK = 2048;
define constant $GDK-BUTTON5-MASK = 4096;

define constant <GdkWindowType> = <integer>;
define constant $GDK-WINDOW-ROOT = 0;
define constant $GDK-WINDOW-TOPLEVEL = 1;
define constant $GDK-WINDOW-CHILD = 2;
define constant $GDK-WINDOW-DIALOG = 3;
define constant $GDK-WINDOW-TEMP = 4;
define constant $GDK-WINDOW-PIXMAP = 5;

define functional class <GdkEventMotion*> (<indexable-statically-typed-pointer>) end;
define sealed domain make(singleton(<GdkEventMotion*>));

define sealed method content-size
    (class == <GdkEventMotion*>) => (size :: <integer>);
  c-expr(int:, "sizeof(GdkEvent)");
end method;

define method type-value
    (obj :: <GdkEventMotion*>)
 => (value :: <GdkEventType>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventMotion", "type");
end;

define method type-value-setter
    (value :: <GdkEventType>, obj :: <GdkEventMotion*>)
 => (value :: <GdkEventType>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventMotion", "type") := value;
end;

define method window-value
    (obj :: <GdkEventMotion*>)
 => (value :: <GdkWindow*>);
  make(<GdkWindow*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GdkEventMotion", "window"));
end;

define method window-value-setter
    (value :: <GdkWindow*>, obj :: <GdkEventMotion*>)
 => (value :: <GdkWindow*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GdkEventMotion", "window")
 := value.raw-value;
  value;
end;

define method x-value
    (obj :: <GdkEventMotion*>)
 => (value :: <gdouble>);
  c-struct-field(double:, obj.raw-value,
                 "GdkEventMotion", "x");
end;

define method x-value-setter
    (value :: <gdouble>, obj :: <GdkEventMotion*>)
 => (value :: <gdouble>);
  c-struct-field(double:, obj.raw-value,
                 "GdkEventMotion", "x") := value;
end;

define method y-value
    (obj :: <GdkEventMotion*>)
 => (value :: <gdouble>);
  c-struct-field(double:, obj.raw-value,
                 "GdkEventMotion", "y");
end;

define method y-value-setter
    (value :: <gdouble>, obj :: <GdkEventMotion*>)
 => (value :: <gdouble>);
  c-struct-field(double:, obj.raw-value,
                 "GdkEventMotion", "y") := value;
end;

define open generic state-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic state-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method state-value
    (obj :: <GdkEventMotion*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventMotion", "state");
end;

define method state-value-setter
    (value :: <guint>, obj :: <GdkEventMotion*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventMotion", "state") := value;
end;

define open generic is-hint-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic is-hint-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method is-hint-value
    (obj :: <GdkEventMotion*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventMotion", "is_hint");
end;

define method is-hint-value-setter
    (value :: <gint>, obj :: <GdkEventMotion*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventMotion", "is_hint") := value;
end;

define constant <GdkOverlapType> = <integer>;
define constant $GDK-OVERLAP-RECTANGLE-IN = 0;
define constant $GDK-OVERLAP-RECTANGLE-OUT = 1;
define constant $GDK-OVERLAP-RECTANGLE-PART = 2;

define functional class <GdkPoint*> (<indexable-statically-typed-pointer>) end;
define sealed domain make(singleton(<GdkPoint*>));

define sealed method content-size
    (class == <GdkPoint*>) => (size :: <integer>);
  c-expr(int:, "sizeof(GdkPoint)");
end method;

define method x-value
    (obj :: <GdkPoint*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkPoint", "x");
end;

define method x-value-setter
    (value :: <gint>, obj :: <GdkPoint*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkPoint", "x") := value;
end;

define method y-value
    (obj :: <GdkPoint*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkPoint", "y");
end;

define method y-value-setter
    (value :: <gint>, obj :: <GdkPoint*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkPoint", "y") := value;
end;

define constant <GdkEventType> = <integer>;
define constant $GDK-NOTHING = -1;
define constant $GDK-DELETE = 0;
define constant $GDK-DESTROY = 1;
define constant $GDK-EXPOSE = 2;
define constant $GDK-MOTION-NOTIFY = 3;
define constant $GDK-BUTTON-PRESS = 4;
define constant $GDK-2BUTTON-PRESS = 5;
define constant $GDK-3BUTTON-PRESS = 6;
define constant $GDK-BUTTON-RELEASE = 7;
define constant $GDK-KEY-PRESS = 8;
define constant $GDK-KEY-RELEASE = 9;
define constant $GDK-ENTER-NOTIFY = 10;
define constant $GDK-LEAVE-NOTIFY = 11;
define constant $GDK-FOCUS-CHANGE = 12;
define constant $GDK-CONFIGURE = 13;
define constant $GDK-MAP = 14;
define constant $GDK-UNMAP = 15;
define constant $GDK-PROPERTY-NOTIFY = 16;
define constant $GDK-SELECTION-CLEAR = 17;
define constant $GDK-SELECTION-REQUEST = 18;
define constant $GDK-SELECTION-NOTIFY = 19;
define constant $GDK-PROXIMITY-IN = 20;
define constant $GDK-PROXIMITY-OUT = 21;
define constant $GDK-DRAG-ENTER = 22;
define constant $GDK-DRAG-LEAVE = 23;
define constant $GDK-DRAG-MOTION = 24;
define constant $GDK-DRAG-STATUS = 25;
define constant $GDK-DROP-START = 26;
define constant $GDK-DROP-FINISHED = 27;
define constant $GDK-CLIENT-EVENT = 28;
define constant $GDK-VISIBILITY-NOTIFY = 29;
define constant $GDK-NO-EXPOSE = 30;

define constant <GdkSubwindowMode> = <integer>;
define constant $GDK-CLIP-BY-CHILDREN = 0;
define constant $GDK-INCLUDE-INFERIORS = 1;

define constant <GdkEventMask> = <integer>;
define constant $GDK-EXPOSURE-MASK = 2;
define constant $GDK-POINTER-MOTION-MASK = 4;
define constant $GDK-POINTER-MOTION-HINT-MASK = 8;
define constant $GDK-BUTTON-MOTION-MASK = 16;
define constant $GDK-BUTTON1-MOTION-MASK = 32;
define constant $GDK-BUTTON2-MOTION-MASK = 64;
define constant $GDK-BUTTON3-MOTION-MASK = 128;
define constant $GDK-BUTTON-PRESS-MASK = 256;
define constant $GDK-BUTTON-RELEASE-MASK = 512;
define constant $GDK-KEY-PRESS-MASK = 1024;
define constant $GDK-KEY-RELEASE-MASK = 2048;
define constant $GDK-ENTER-NOTIFY-MASK = 4096;
define constant $GDK-LEAVE-NOTIFY-MASK = 8192;
define constant $GDK-FOCUS-CHANGE-MASK = 16384;
define constant $GDK-STRUCTURE-MASK = 32768;
define constant $GDK-ALL-EVENTS-MASK = 1048575;

define constant <GdkBitmap*> = <GdkWindow*>;

define constant <GdkInputSource> = <integer>;
define constant $GDK-SOURCE-MOUSE = 0;
define constant $GDK-SOURCE-PEN = 1;
define constant $GDK-SOURCE-ERASER = 2;
define constant $GDK-SOURCE-CURSOR = 3;

define functional class <GdkColor*> (<indexable-statically-typed-pointer>) end;
define sealed domain make(singleton(<GdkColor*>));

define sealed method content-size
    (class == <GdkColor*>) => (size :: <integer>);
  c-expr(int:, "sizeof(GdkColor)");
end method;

define constant <GdkPropertyState> = <integer>;
define constant $GDK-PROPERTY-NEW-VALUE = 0;
define constant $GDK-PROPERTY-DELETE = 1;

define constant <GdkInputCondition> = <integer>;
define constant $GDK-INPUT-READ = 1;
define constant $GDK-INPUT-WRITE = 2;
define constant $GDK-INPUT-EXCEPTION = 4;

define functional class <GdkFont*> (<statically-typed-pointer>) end;
define sealed domain make(singleton(<GdkFont*>));

define functional class <GdkColormap*> (<statically-typed-pointer>) end;
define sealed domain make(singleton(<GdkColormap*>));

define functional class <GdkGC*> (<indexable-statically-typed-pointer>) end;
define sealed domain make(singleton(<GdkGC*>));

define sealed method content-size
    (class == <GdkGC*>) => (size :: <integer>);
  c-expr(int:, "sizeof(GdkGC)");
end method;

define constant <GdkGCValuesMask> = <integer>;
define constant $GDK-GC-FOREGROUND = 1;
define constant $GDK-GC-BACKGROUND = 2;
define constant $GDK-GC-FONT = 4;
define constant $GDK-GC-FUNCTION = 8;
define constant $GDK-GC-FILL = 16;
define constant $GDK-GC-TILE = 32;
define constant $GDK-GC-STIPPLE = 64;
define constant $GDK-GC-CLIP-MASK = 128;
define constant $GDK-GC-SUBWINDOW = 256;
define constant $GDK-GC-TS-X-ORIGIN = 512;
define constant $GDK-GC-TS-Y-ORIGIN = 1024;
define constant $GDK-GC-CLIP-X-ORIGIN = 2048;
define constant $GDK-GC-CLIP-Y-ORIGIN = 4096;
define constant $GDK-GC-EXPOSURES = 8192;
define constant $GDK-GC-LINE-WIDTH = 16384;
define constant $GDK-GC-LINE-STYLE = 32768;
define constant $GDK-GC-CAP-STYLE = 65536;
define constant $GDK-GC-JOIN-STYLE = 131072;

define constant <GdkJoinStyle> = <integer>;
define constant $GDK-JOIN-MITER = 0;
define constant $GDK-JOIN-ROUND = 1;
define constant $GDK-JOIN-BEVEL = 2;

define constant <GdkWMDecoration> = <integer>;
define constant $GDK-DECOR-ALL = 1;
define constant $GDK-DECOR-BORDER = 2;
define constant $GDK-DECOR-RESIZEH = 4;
define constant $GDK-DECOR-TITLE = 8;
define constant $GDK-DECOR-MENU = 16;
define constant $GDK-DECOR-MINIMIZE = 32;
define constant $GDK-DECOR-MAXIMIZE = 64;

define functional class <GdkCursor*> (<statically-typed-pointer>) end;
define sealed domain make(singleton(<GdkCursor*>));

define method type-value
    (obj :: <GdkCursor*>)
 => (value :: <GdkCursorType>);
  c-struct-field(int:, obj.raw-value,
                 "GdkCursor", "type");
end;

define method type-value-setter
    (value :: <GdkCursorType>, obj :: <GdkCursor*>)
 => (value :: <GdkCursorType>);
  c-struct-field(int:, obj.raw-value,
                 "GdkCursor", "type") := value;
end;

define functional class <GdkEventCrossing*> (<indexable-statically-typed-pointer>) end;
define sealed domain make(singleton(<GdkEventCrossing*>));

define sealed method content-size
    (class == <GdkEventCrossing*>) => (size :: <integer>);
  c-expr(int:, "sizeof(GdkEvent)");
end method;

define method type-value
    (obj :: <GdkEventCrossing*>)
 => (value :: <GdkEventType>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventCrossing", "type");
end;

define method type-value-setter
    (value :: <GdkEventType>, obj :: <GdkEventCrossing*>)
 => (value :: <GdkEventType>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventCrossing", "type") := value;
end;

define method window-value
    (obj :: <GdkEventCrossing*>)
 => (value :: <GdkWindow*>);
  make(<GdkWindow*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GdkEventCrossing", "window"));
end;

define method window-value-setter
    (value :: <GdkWindow*>, obj :: <GdkEventCrossing*>)
 => (value :: <GdkWindow*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GdkEventCrossing", "window")
 := value.raw-value;
  value;
end;

define method x-value
    (obj :: <GdkEventCrossing*>)
 => (value :: <gdouble>);
  c-struct-field(double:, obj.raw-value,
                 "GdkEventCrossing", "x");
end;

define method x-value-setter
    (value :: <gdouble>, obj :: <GdkEventCrossing*>)
 => (value :: <gdouble>);
  c-struct-field(double:, obj.raw-value,
                 "GdkEventCrossing", "x") := value;
end;

define method y-value
    (obj :: <GdkEventCrossing*>)
 => (value :: <gdouble>);
  c-struct-field(double:, obj.raw-value,
                 "GdkEventCrossing", "y");
end;

define method y-value-setter
    (value :: <gdouble>, obj :: <GdkEventCrossing*>)
 => (value :: <gdouble>);
  c-struct-field(double:, obj.raw-value,
                 "GdkEventCrossing", "y") := value;
end;

define open generic mode-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic mode-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method mode-value
    (obj :: <GdkEventCrossing*>)
 => (value :: <GdkCrossingMode>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventCrossing", "mode");
end;

define method mode-value-setter
    (value :: <GdkCrossingMode>, obj :: <GdkEventCrossing*>)
 => (value :: <GdkCrossingMode>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventCrossing", "mode") := value;
end;

define open generic detail-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic detail-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method detail-value
    (obj :: <GdkEventCrossing*>)
 => (value :: <GdkNotifyType>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventCrossing", "detail");
end;

define method detail-value-setter
    (value :: <GdkNotifyType>, obj :: <GdkEventCrossing*>)
 => (value :: <GdkNotifyType>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventCrossing", "detail") := value;
end;

define method state-value
    (obj :: <GdkEventCrossing*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventCrossing", "state");
end;

define method state-value-setter
    (value :: <guint>, obj :: <GdkEventCrossing*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventCrossing", "state") := value;
end;

define functional class <GdkGCValues*> (<indexable-statically-typed-pointer>) end;
define sealed domain make(singleton(<GdkGCValues*>));

define sealed method content-size
    (class == <GdkGCValues*>) => (size :: <integer>);
  c-expr(int:, "sizeof(GdkGCValues)");
end method;

define open generic font-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic font-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method font-value
    (obj :: <GdkGCValues*>)
 => (value :: <GdkFont*>);
  make(<GdkFont*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GdkGCValues", "font"));
end;

define method font-value-setter
    (value :: <GdkFont*>, obj :: <GdkGCValues*>)
 => (value :: <GdkFont*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GdkGCValues", "font")
 := value.raw-value;
  value;
end;

define open generic function-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic function-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method function-value
    (obj :: <GdkGCValues*>)
 => (value :: <GdkFunction>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "function");
end;

define method function-value-setter
    (value :: <GdkFunction>, obj :: <GdkGCValues*>)
 => (value :: <GdkFunction>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "function") := value;
end;

define open generic fill-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic fill-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method fill-value
    (obj :: <GdkGCValues*>)
 => (value :: <GdkFill>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "fill");
end;

define method fill-value-setter
    (value :: <GdkFill>, obj :: <GdkGCValues*>)
 => (value :: <GdkFill>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "fill") := value;
end;

define open generic tile-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic tile-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method tile-value
    (obj :: <GdkGCValues*>)
 => (value :: <GdkPixmap*>);
  make(<GdkPixmap*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GdkGCValues", "tile"));
end;

define method tile-value-setter
    (value :: <GdkPixmap*>, obj :: <GdkGCValues*>)
 => (value :: <GdkPixmap*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GdkGCValues", "tile")
 := value.raw-value;
  value;
end;

define open generic stipple-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic stipple-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method stipple-value
    (obj :: <GdkGCValues*>)
 => (value :: <GdkPixmap*>);
  make(<GdkPixmap*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GdkGCValues", "stipple"));
end;

define method stipple-value-setter
    (value :: <GdkPixmap*>, obj :: <GdkGCValues*>)
 => (value :: <GdkPixmap*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GdkGCValues", "stipple")
 := value.raw-value;
  value;
end;

define open generic clip-mask-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic clip-mask-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method clip-mask-value
    (obj :: <GdkGCValues*>)
 => (value :: <GdkPixmap*>);
  make(<GdkPixmap*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GdkGCValues", "clip_mask"));
end;

define method clip-mask-value-setter
    (value :: <GdkPixmap*>, obj :: <GdkGCValues*>)
 => (value :: <GdkPixmap*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GdkGCValues", "clip_mask")
 := value.raw-value;
  value;
end;

define open generic subwindow-mode-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic subwindow-mode-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method subwindow-mode-value
    (obj :: <GdkGCValues*>)
 => (value :: <GdkSubwindowMode>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "subwindow_mode");
end;

define method subwindow-mode-value-setter
    (value :: <GdkSubwindowMode>, obj :: <GdkGCValues*>)
 => (value :: <GdkSubwindowMode>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "subwindow_mode") := value;
end;

define open generic ts-x-origin-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic ts-x-origin-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method ts-x-origin-value
    (obj :: <GdkGCValues*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "ts_x_origin");
end;

define method ts-x-origin-value-setter
    (value :: <gint>, obj :: <GdkGCValues*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "ts_x_origin") := value;
end;

define open generic ts-y-origin-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic ts-y-origin-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method ts-y-origin-value
    (obj :: <GdkGCValues*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "ts_y_origin");
end;

define method ts-y-origin-value-setter
    (value :: <gint>, obj :: <GdkGCValues*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "ts_y_origin") := value;
end;

define open generic clip-x-origin-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic clip-x-origin-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method clip-x-origin-value
    (obj :: <GdkGCValues*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "clip_x_origin");
end;

define method clip-x-origin-value-setter
    (value :: <gint>, obj :: <GdkGCValues*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "clip_x_origin") := value;
end;

define open generic clip-y-origin-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic clip-y-origin-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method clip-y-origin-value
    (obj :: <GdkGCValues*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "clip_y_origin");
end;

define method clip-y-origin-value-setter
    (value :: <gint>, obj :: <GdkGCValues*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "clip_y_origin") := value;
end;

define open generic graphics-exposures-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic graphics-exposures-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method graphics-exposures-value
    (obj :: <GdkGCValues*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "graphics_exposures");
end;

define method graphics-exposures-value-setter
    (value :: <gint>, obj :: <GdkGCValues*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "graphics_exposures") := value;
end;

define open generic line-width-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic line-width-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method line-width-value
    (obj :: <GdkGCValues*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "line_width");
end;

define method line-width-value-setter
    (value :: <gint>, obj :: <GdkGCValues*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "line_width") := value;
end;

define open generic line-style-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic line-style-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method line-style-value
    (obj :: <GdkGCValues*>)
 => (value :: <GdkLineStyle>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "line_style");
end;

define method line-style-value-setter
    (value :: <GdkLineStyle>, obj :: <GdkGCValues*>)
 => (value :: <GdkLineStyle>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "line_style") := value;
end;

define open generic cap-style-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic cap-style-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method cap-style-value
    (obj :: <GdkGCValues*>)
 => (value :: <GdkCapStyle>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "cap_style");
end;

define method cap-style-value-setter
    (value :: <GdkCapStyle>, obj :: <GdkGCValues*>)
 => (value :: <GdkCapStyle>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "cap_style") := value;
end;

define open generic join-style-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic join-style-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method join-style-value
    (obj :: <GdkGCValues*>)
 => (value :: <GdkJoinStyle>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "join_style");
end;

define method join-style-value-setter
    (value :: <GdkJoinStyle>, obj :: <GdkGCValues*>)
 => (value :: <GdkJoinStyle>);
  c-struct-field(int:, obj.raw-value,
                 "GdkGCValues", "join_style") := value;
end;

define functional class <GdkEventButton*> (<indexable-statically-typed-pointer>) end;
define sealed domain make(singleton(<GdkEventButton*>));

define sealed method content-size
    (class == <GdkEventButton*>) => (size :: <integer>);
  c-expr(int:, "sizeof(GdkEvent)");
end method;

define method type-value
    (obj :: <GdkEventButton*>)
 => (value :: <GdkEventType>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventButton", "type");
end;

define method type-value-setter
    (value :: <GdkEventType>, obj :: <GdkEventButton*>)
 => (value :: <GdkEventType>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventButton", "type") := value;
end;

define method window-value
    (obj :: <GdkEventButton*>)
 => (value :: <GdkWindow*>);
  make(<GdkWindow*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GdkEventButton", "window"));
end;

define method window-value-setter
    (value :: <GdkWindow*>, obj :: <GdkEventButton*>)
 => (value :: <GdkWindow*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GdkEventButton", "window")
 := value.raw-value;
  value;
end;

define method state-value
    (obj :: <GdkEventButton*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventButton", "state");
end;

define method state-value-setter
    (value :: <guint>, obj :: <GdkEventButton*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventButton", "state") := value;
end;

define open generic button-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic button-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method button-value
    (obj :: <GdkEventButton*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventButton", "button");
end;

define method button-value-setter
    (value :: <guint>, obj :: <GdkEventButton*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEventButton", "button") := value;
end;

define constant <GdkCursorType> = <integer>;
define constant $GDK-LAST-CURSOR = 153;

define constant <GdkCapStyle> = <integer>;
define constant $GDK-CAP-NOT-LAST = 0;
define constant $GDK-CAP-BUTT = 1;
define constant $GDK-CAP-ROUND = 2;
define constant $GDK-CAP-PROJECTING = 3;

define functional class <GdkVisual*> (<statically-typed-pointer>) end;
define sealed domain make(singleton(<GdkVisual*>));

define constant <GdkCrossingMode> = <integer>;
define constant $GDK-CROSSING-NORMAL = 0;
define constant $GDK-CROSSING-GRAB = 1;
define constant $GDK-CROSSING-UNGRAB = 2;

define functional class <GdkEvent*> (<indexable-statically-typed-pointer>) end;
define sealed domain make(singleton(<GdkEvent*>));

define sealed method content-size
    (class == <GdkEvent*>) => (size :: <integer>);
  c-expr(int:, "sizeof(GdkEvent)");
end method;

define method type-value
    (obj :: <GdkEvent*>)
 => (value :: <GdkEventType>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEvent", "type");
end;

define method type-value-setter
    (value :: <GdkEventType>, obj :: <GdkEvent*>)
 => (value :: <GdkEventType>);
  c-struct-field(int:, obj.raw-value,
                 "GdkEvent", "type") := value;
end;

define constant <GdkSelection> = <integer>;
define constant $GDK-SELECTION-PRIMARY = 1;
define constant $GDK-SELECTION-SECONDARY = 2;

define constant <GdkDrawable*> = <GdkWindow*>;

define constant <GdkVisibilityState> = <integer>;
define constant $GDK-VISIBILITY-UNOBSCURED = 0;
define constant $GDK-VISIBILITY-PARTIAL = 1;
define constant $GDK-VISIBILITY-FULLY-OBSCURED = 2;

define constant <GdkByteOrder> = <integer>;
define constant $GDK-LSB-FIRST = 0;
define constant $GDK-MSB-FIRST = 1;

define constant <GdkNotifyType> = <integer>;
define constant $GDK-NOTIFY-ANCESTOR = 0;
define constant $GDK-NOTIFY-VIRTUAL = 1;
define constant $GDK-NOTIFY-INFERIOR = 2;
define constant $GDK-NOTIFY-NONLINEAR = 3;
define constant $GDK-NOTIFY-NONLINEAR-VIRTUAL = 4;
define constant $GDK-NOTIFY-UNKNOWN = 5;

define constant <GdkWindowAttributesType> = <integer>;
define constant $GDK-WA-TITLE = 2;
define constant $GDK-WA-X = 4;
define constant $GDK-WA-Y = 8;
define constant $GDK-WA-CURSOR = 16;
define constant $GDK-WA-COLORMAP = 32;
define constant $GDK-WA-VISUAL = 64;

define constant <GdkVisualType> = <integer>;
define constant $GDK-VISUAL-STATIC-GRAY = 0;
define constant $GDK-VISUAL-GRAYSCALE = 1;
define constant $GDK-VISUAL-STATIC-COLOR = 2;
define constant $GDK-VISUAL-PSEUDO-COLOR = 3;
define constant $GDK-VISUAL-TRUE-COLOR = 4;
define constant $GDK-VISUAL-DIRECT-COLOR = 5;

define constant <GdkFunction> = <integer>;
define constant $GDK-COPY = 0;
define constant $GDK-INVERT = 1;
define constant $GDK-XOR = 2;
define constant $GDK-CLEAR = 3;
define constant $GDK-AND = 4;
define constant $GDK-AND-REVERSE = 5;
define constant $GDK-AND-INVERT = 6;
define constant $GDK-NOOP = 7;
define constant $GDK-OR = 8;
define constant $GDK-EQUIV = 9;
define constant $GDK-OR-REVERSE = 10;
define constant $GDK-COPY-INVERT = 11;
define constant $GDK-OR-INVERT = 12;
define constant $GDK-NAND = 13;
define constant $GDK-SET = 14;

define constant <GdkImageType> = <integer>;
define constant $GDK-IMAGE-NORMAL = 0;
define constant $GDK-IMAGE-SHARED = 1;
define constant $GDK-IMAGE-FASTEST = 2;

define inline-only function gdk-pixmap-ref
    (pixmap :: <GdkPixmap*>)
 => (return :: <GdkPixmap*>);
  let return-value = call-out("gdk_pixmap_ref", ptr:,
           ptr: pixmap.raw-value);
  make(<GdkPixmap*>, pointer: return-value);
end function;

define inline-only function gdk-pixmap-unref
    (pixmap :: <GdkPixmap*>)
 => ();
  call-out("gdk_pixmap_unref", void:,
           ptr: pixmap.raw-value);
  values();
end function;

define inline-only function g-free
    (mem :: <gpointer>)
 => ();
  call-out("g_free", void:,
           ptr: mem.raw-value);
  values();
end function;

define inline-only function gdk-gc-new
    (window :: <GdkWindow*>)
 => (return :: <GdkGC*>);
  let return-value = call-out("gdk_gc_new", ptr:,
           ptr: window.raw-value);
  make(<GdkGC*>, pointer: return-value);
end function;

define inline-only function gdk-gc-get-values
    (gc :: <GdkGC*>,
     gc_values :: <GdkGCValues*>)
 => ();
  call-out("gdk_gc_get_values", void:,
           ptr: gc.raw-value,
           ptr: gc_values.raw-value);
  values();
end function;

define inline-only function gdk-gc-set-foreground
    (gc :: <GdkGC*>,
     color :: <GdkColor*>)
 => ();
  call-out("gdk_gc_set_foreground", void:,
           ptr: gc.raw-value,
           ptr: color.raw-value);
  values();
end function;

define inline-only function gdk-gc-set-background
    (gc :: <GdkGC*>,
     color :: <GdkColor*>)
 => ();
  call-out("gdk_gc_set_background", void:,
           ptr: gc.raw-value,
           ptr: color.raw-value);
  values();
end function;

define inline-only function gdk-gc-set-font
    (gc :: <GdkGC*>,
     font :: <GdkFont*>)
 => ();
  call-out("gdk_gc_set_font", void:,
           ptr: gc.raw-value,
           ptr: font.raw-value);
  values();
end function;

define inline-only function gdk-gc-set-function
    (gc :: <GdkGC*>,
     function :: <GdkFunction>)
 => ();
  call-out("gdk_gc_set_function", void:,
           ptr: gc.raw-value,
           int: function);
  values();
end function;

define inline-only function gdk-gc-set-fill
    (gc :: <GdkGC*>,
     fill :: <GdkFill>)
 => ();
  call-out("gdk_gc_set_fill", void:,
           ptr: gc.raw-value,
           int: fill);
  values();
end function;

define inline-only function gdk-gc-set-ts-origin
    (gc :: <GdkGC*>,
     x :: <gint>,
     y :: <gint>)
 => ();
  call-out("gdk_gc_set_ts_origin", void:,
           ptr: gc.raw-value,
           int: x,
           int: y);
  values();
end function;

define inline-only function gdk-gc-set-clip-origin
    (gc :: <GdkGC*>,
     x :: <gint>,
     y :: <gint>)
 => ();
  call-out("gdk_gc_set_clip_origin", void:,
           ptr: gc.raw-value,
           int: x,
           int: y);
  values();
end function;

define inline-only function gdk-gc-set-subwindow
    (gc :: <GdkGC*>,
     mode :: <GdkSubwindowMode>)
 => ();
  call-out("gdk_gc_set_subwindow", void:,
           ptr: gc.raw-value,
           int: mode);
  values();
end function;

define inline-only function gdk-gc-set-exposures
    (gc :: <GdkGC*>,
     exposures :: <gboolean>)
 => ();
  call-out("gdk_gc_set_exposures", void:,
           ptr: gc.raw-value,
           int: exposures);
  values();
end function;

define inline-only function gdk-gc-set-line-attributes
    (gc :: <GdkGC*>,
     line_width :: <gint>,
     line_style :: <GdkLineStyle>,
     cap_style :: <GdkCapStyle>,
     join_style :: <GdkJoinStyle>)
 => ();
  call-out("gdk_gc_set_line_attributes", void:,
           ptr: gc.raw-value,
           int: line_width,
           int: line_style,
           int: cap_style,
           int: join_style);
  values();
end function;

define inline-only function gdk-draw-point
    (window :: <GdkWindow*>,
     gc :: <GdkGC*>,
     x :: <gint>,
     y :: <gint>)
 => ();
  call-out("gdk_draw_point", void:,
           ptr: window.raw-value,
           ptr: gc.raw-value,
           int: x,
           int: y);
  values();
end function;

define inline-only function gdk-draw-line
    (window :: <GdkWindow*>,
     gc :: <GdkGC*>,
     x1 :: <gint>,
     y1 :: <gint>,
     x2 :: <gint>,
     y2 :: <gint>)
 => ();
  call-out("gdk_draw_line", void:,
           ptr: window.raw-value,
           ptr: gc.raw-value,
           int: x1,
           int: y1,
           int: x2,
           int: y2);
  values();
end function;

define inline-only function gdk-draw-lines
    (window :: <GdkWindow*>,
     gc :: <GdkGC*>,
     points :: <GdkPoint*>,
     npoints :: <integer>)
 => ();
  call-out("gdk_draw_lines", void:,
           ptr: window.raw-value,
           ptr: gc.raw-value,
           ptr: points.raw-value,
           int: npoints);
  values();
end function;

define inline-only function gdk-draw-rectangle
    (window :: <GdkWindow*>,
     gc :: <GdkGC*>,
     filled :: <gboolean>,
     x :: <gint>,
     y :: <gint>,
     width :: <gint>,
     height :: <gint>)
 => ();
  call-out("gdk_draw_rectangle", void:,
           ptr: window.raw-value,
           ptr: gc.raw-value,
           int: filled,
           int: x,
           int: y,
           int: width,
           int: height);
  values();
end function;

define inline-only function gdk-draw-polygon
    (window :: <GdkWindow*>,
     gc :: <GdkGC*>,
     filled :: <gboolean>,
     points :: <GdkPoint*>,
     npoints :: <integer>)
 => ();
  call-out("gdk_draw_polygon", void:,
           ptr: window.raw-value,
           ptr: gc.raw-value,
           int: filled,
           ptr: points.raw-value,
           int: npoints);
  values();
end function;

define inline-only function gdk-draw-arc
    (window :: <GdkWindow*>,
     gc :: <GdkGC*>,
     filled :: <gboolean>,
     x :: <gint>,
     y :: <gint>,
     width :: <gint>,
     height :: <gint>,
     angle1 :: <gint>,
     angle2 :: <gint>)
 => ();
  call-out("gdk_draw_arc", void:,
           ptr: window.raw-value,
           ptr: gc.raw-value,
           int: filled,
           int: x,
           int: y,
           int: width,
           int: height,
           int: angle1,
           int: angle2);
  values();
end function;

define inline-only function gdk-draw-string
    (window :: <GdkWindow*>,
     font :: <GdkFont*>,
     gc :: <GdkGC*>,
     x :: <gint>,
     y :: <gint>,
     string :: <gchar*>)
 => ();
  call-out("gdk_draw_string", void:,
           ptr: window.raw-value,
           ptr: font.raw-value,
           ptr: gc.raw-value,
           int: x,
           int: y,
           ptr: string.raw-value);
  values();
end function;

define inline-only function gdk-draw-points
    (window :: <GdkWindow*>,
     gc :: <GdkGC*>,
     points :: <GdkPoint*>,
     npoints :: <integer>)
 => ();
  call-out("gdk_draw_points", void:,
           ptr: window.raw-value,
           ptr: gc.raw-value,
           ptr: points.raw-value,
           int: npoints);
  values();
end function;

define inline-only function gdk-string-width
    (font :: <GdkFont*>,
     str :: <gchar*>)
 => (return :: <gint>);
  let return-value = call-out("gdk_string_width", int:,
           ptr: font.raw-value,
           ptr: str.raw-value);
  return-value;
end function;

define inline-only function gdk-window-clear
    (window :: <GdkWindow*>)
 => ();
  call-out("gdk_window_clear", void:,
           ptr: window.raw-value);
  values();
end function;

define inline-only function gdk-window-clear-area
    (window :: <GdkWindow*>,
     x :: <gint>,
     y :: <gint>,
     width :: <gint>,
     height :: <gint>)
 => ();
  call-out("gdk_window_clear_area", void:,
           ptr: window.raw-value,
           int: x,
           int: y,
           int: width,
           int: height);
  values();
end function;

define inline-only function gdk-window-clear-area-e
    (window :: <GdkWindow*>,
     x :: <gint>,
     y :: <gint>,
     width :: <gint>,
     height :: <gint>)
 => ();
  call-out("gdk_window_clear_area_e", void:,
           ptr: window.raw-value,
           int: x,
           int: y,
           int: width,
           int: height);
  values();
end function;

define inline-only function gdk-window-raise
    (window :: <GdkWindow*>)
 => ();
  call-out("gdk_window_raise", void:,
           ptr: window.raw-value);
  values();
end function;

define inline-only function gdk-window-lower
    (window :: <GdkWindow*>)
 => ();
  call-out("gdk_window_lower", void:,
           ptr: window.raw-value);
  values();
end function;

define inline-only function gdk-window-is-visible
    (window :: <GdkWindow*>)
 => (return :: <gboolean>);
  let return-value = call-out("gdk_window_is_visible", int:,
           ptr: window.raw-value);
  return-value;
end function;

define inline-only function gdk-window-is-viewable
    (window :: <GdkWindow*>)
 => (return :: <gboolean>);
  let return-value = call-out("gdk_window_is_viewable", int:,
           ptr: window.raw-value);
  return-value;
end function;

define inline-only function gdk-pixmap-new
    (window :: <GdkWindow*>,
     width :: <gint>,
     height :: <gint>,
     depth :: <gint>)
 => (return :: <GdkWindow*>);
  let return-value = call-out("gdk_pixmap_new", ptr:,
           ptr: window.raw-value,
           int: width,
           int: height,
           int: depth);
  make(<GdkWindow*>, pointer: return-value);
end function;

define inline-only function gdk-pixmap-create-from-xpm
    (window :: <GdkWindow*>,
     mask :: <GdkWindow**>,
     transparent_color :: <GdkColor*>,
     filename :: <gchar*>)
 => (return :: <GdkWindow*>);
  let return-value = call-out("gdk_pixmap_create_from_xpm", ptr:,
           ptr: window.raw-value,
           ptr: mask.raw-value,
           ptr: transparent_color.raw-value,
           ptr: filename.raw-value);
  make(<GdkWindow*>, pointer: return-value);
end function;

define inline-only function gdk-draw-pixmap
    (drawable :: <GdkWindow*>,
     gc :: <GdkGC*>,
     src :: <GdkWindow*>,
     xsrc :: <gint>,
     ysrc :: <gint>,
     xdest :: <gint>,
     ydest :: <gint>,
     width :: <gint>,
     height :: <gint>)
 => ();
  call-out("gdk_draw_pixmap", void:,
           ptr: drawable.raw-value,
           ptr: gc.raw-value,
           ptr: src.raw-value,
           int: xsrc,
           int: ysrc,
           int: xdest,
           int: ydest,
           int: width,
           int: height);
  values();
end function;

define inline-only function gdk-set-locale
    ()
 => (return :: <gchar*>);
  let return-value = call-out("gdk_set_locale", ptr:);
  make(<gchar*>, pointer: return-value);
end function;

define inline-only function gdk-font-load
    (name :: <gchar*>)
 => (return :: <GdkFont*>);
  let return-value = call-out("gdk_font_load", ptr:,
           ptr: name.raw-value);
  make(<GdkFont*>, pointer: return-value);
end function;

define inline-only function gdk-pointer-grab
    (window :: <GdkWindow*>,
     owner_events :: <gint>,
     event_mask :: <GdkEventMask>,
     confine_to :: <GdkWindow*>,
     cursor :: <GdkCursor*>,
     time :: <guint>)
 => (return :: <gint>);
  let return-value = call-out("gdk_pointer_grab", int:,
           ptr: window.raw-value,
           int: owner_events,
           int: event_mask,
           ptr: confine_to.raw-value,
           ptr: cursor.raw-value,
           int: time);
  return-value;
end function;

define inline-only function gdk-pointer-ungrab
    (time :: <guint>)
 => ();
  call-out("gdk_pointer_ungrab", void:,
           int: time);
  values();
end function;

define inline-only function gdk-keyboard-grab
    (window :: <GdkWindow*>,
     owner_events :: <gboolean>,
     time :: <guint>)
 => (return :: <gint>);
  let return-value = call-out("gdk_keyboard_grab", int:,
           ptr: window.raw-value,
           int: owner_events,
           int: time);
  return-value;
end function;

define inline-only function gdk-keyboard-ungrab
    (time :: <guint>)
 => ();
  call-out("gdk_keyboard_ungrab", void:,
           int: time);
  values();
end function;

define inline-only function gdk-pointer-is-grabbed
    ()
 => (return :: <gboolean>);
  let return-value = call-out("gdk_pointer_is_grabbed", int:);
  return-value;
end function;

define inline-only function gdk-screen-width
    ()
 => (return :: <gint>);
  let return-value = call-out("gdk_screen_width", int:);
  return-value;
end function;

define inline-only function gdk-screen-height
    ()
 => (return :: <gint>);
  let return-value = call-out("gdk_screen_height", int:);
  return-value;
end function;

define inline-only function gdk-screen-width-mm
    ()
 => (return :: <gint>);
  let return-value = call-out("gdk_screen_width_mm", int:);
  return-value;
end function;

define inline-only function gdk-screen-height-mm
    ()
 => (return :: <gint>);
  let return-value = call-out("gdk_screen_height_mm", int:);
  return-value;
end function;

define inline-only function gdk-flush
    ()
 => ();
  call-out("gdk_flush", void:);
  values();
end function;

define inline-only function gdk-beep
    ()
 => ();
  call-out("gdk_beep", void:);
  values();
end function;

define inline-only function gdk-colormap-alloc-color
    (colormap :: <GdkColormap*>,
     color :: <GdkColor*>,
     writeable :: <gboolean>,
     best_match :: <gboolean>)
 => (return :: <gboolean>);
  let return-value = call-out("gdk_colormap_alloc_color", int:,
           ptr: colormap.raw-value,
           ptr: color.raw-value,
           int: writeable,
           int: best_match);
  return-value;
end function;

define inline-only function gdk-window-get-pointer
    (window :: <GdkWindow*>,
     x :: <gint*>,
     y :: <gint*>,
     mask :: <GdkModifierType*>)
 => (return :: <GdkWindow*>);
  let return-value = call-out("gdk_window_get_pointer", ptr:,
           ptr: window.raw-value,
           ptr: x.raw-value,
           ptr: y.raw-value,
           ptr: mask.raw-value);
  make(<GdkWindow*>, pointer: return-value);
end function;

define inline-only function g-timer-new
    ()
 => (return :: <GTimer*>);
  let return-value = call-out("g_timer_new", ptr:);
  make(<GTimer*>, pointer: return-value);
end function;

define inline-only function g-timer-start
    (timer :: <GTimer*>)
 => ();
  call-out("g_timer_start", void:,
           ptr: timer.raw-value);
  values();
end function;

define inline-only function g-timer-stop
    (timer :: <GTimer*>)
 => ();
  call-out("g_timer_stop", void:,
           ptr: timer.raw-value);
  values();
end function;

define inline-only function g-timer-reset
    (timer :: <GTimer*>)
 => ();
  call-out("g_timer_reset", void:,
           ptr: timer.raw-value);
  values();
end function;

define inline-only function g-timer-elapsed
    (timer :: <GTimer*>,
     microseconds :: <gulong*>)
 => (return :: <gfloat>);
  let return-value = call-out("g_timer_elapsed", float:,
           ptr: timer.raw-value,
           ptr: microseconds.raw-value);
  return-value;
end function;

define inline-only function gdk-threads-enter
    ()
 => ();
  call-out("gdk_threads_enter", void:);
  values();
end function;

define inline-only function gdk-threads-leave
    ()
 => ();
  call-out("gdk_threads_leave", void:);
  values();
end function;

define inline-only function gdk-rgb-init
    ()
 => ();
  call-out("gdk_rgb_init", void:);
  values();
end function;

define inline-only function gdk-rgb-get-cmap
    ()
 => (return :: <GdkColormap*>);
  let return-value = call-out("gdk_rgb_get_cmap", ptr:);
  make(<GdkColormap*>, pointer: return-value);
end function;

define inline-only function gdk-rgb-get-visual
    ()
 => (return :: <GdkVisual*>);
  let return-value = call-out("gdk_rgb_get_visual", ptr:);
  make(<GdkVisual*>, pointer: return-value);
end function;

