/*  -*-objc-*-
 *  Functions.m: Implementation of the Functions
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <Foundation/Foundation.h>
#include <AppKit/AppKit.h>
#include "Functions.h"
#include "GNUstep.h"

#define ONE_KB 1024
#define ONE_MB (ONE_KB * ONE_KB)
#define ONE_GB (ONE_KB * ONE_MB)

extern NSFileManager *fmanager;

typedef enum { 
	byname,
	bykind,
	bydate, 
	bysize,
	byowner
} SortType;

#define ATTRIBUTES_AT_PATH(a, p, l) \
a = [fmanager fileAttributesAtPath: (NSString *)p traverseLink: l]

#define SORT_INDEX(i, p) { \
BOOL isdir; \
[fmanager fileExistsAtPath: (NSString *)p isDirectory: &isdir]; \
if (isdir) { \
i = 2; \
} else { \
if ([fmanager isExecutableFileAtPath: (NSString *)p] == YES) { \
i = 1; \
} else { \
i = 0; \
} \
} }
		
static inline NSString *cut_Text(NSString *filename, id label, int lenght)
{
	NSString *cutname, *reststr;
	NSFont *labfont;
	float w, cw, dotslenght;
	int i;

	cw = 0;
	labfont = [label font];
	dotslenght = [labfont widthOfString: @"..."];
	w = [labfont widthOfString: filename];
	if (w > lenght) {
		i = 0;
		while (cw <= lenght - dotslenght) {
			if (i == [filename cStringLength]) {
				break;
      }
			cutname = [filename substringToIndex: i];
			reststr = [filename substringFromIndex: i];
			cw = [labfont widthOfString: cutname];
			i++;
		}	
		if ([cutname isEqualToString: filename] == NO) {
			if ([reststr cStringLength] <= 3) { 
				return filename;
			} else {
				cutname = [cutname stringByAppendingString:@"..."];
      }
		} else {
			return filename;
		}	
	} else {
		return filename;
	}
	return cutname;
}

static inline int comp_Paths(id *p1, id *p2, void *context)
{
  int stype;
  int i1, i2;      
  NSDictionary *attributes; 
  NSDate *d1, *d2;
  float fs1, fs2;
  NSString *own1, *own2;
     
  stype = (int)context;

  switch(stype) {
    case byname:
			{
				NSString *n1 = [(NSString *)p1 lastPathComponent];
				NSString *n2 = [(NSString *)p2 lastPathComponent];

      	if ([n2 hasPrefix: @"."] || [n1 hasPrefix: @"."]) {
        	if ([n2 hasPrefix: @"."] && [n1 hasPrefix: @"."]) {
          	return [n1 caseInsensitiveCompare: n2];
        	} else {
          	return [n2 caseInsensitiveCompare: n1];
        	}
      	}
      	return [n1 caseInsensitiveCompare: n2];
      	break;
  		}
			
    case bykind:      
 			SORT_INDEX (i1, p1);
			SORT_INDEX (i2, p2);
			    
      if (i1 == i2) {			
        return [(NSString *)p1 compare: (NSString *)p2]; 
      }   
			   
      return (i1 < i2 ? 1 : -1);
      break;
  
    case bydate:
			ATTRIBUTES_AT_PATH(attributes, p1, NO);
      d1 = [attributes fileModificationDate];
			ATTRIBUTES_AT_PATH(attributes, p2, NO);
      d2 = [attributes fileModificationDate];
    
      return [d1 compare: d2]; 
      break;

    case bysize:
			ATTRIBUTES_AT_PATH(attributes, p1, NO);
      fs1 = [attributes fileSize];
			ATTRIBUTES_AT_PATH(attributes, p2, NO);
      fs2 = [attributes fileSize];
    
      return (fs1 < fs2 ? 1 : -1);    
      break;

    case byowner:
			ATTRIBUTES_AT_PATH(attributes, p1, NO);
      own1 = [attributes fileOwnerAccountName];
			ATTRIBUTES_AT_PATH(attributes, p2, NO);
      own2 = [attributes fileOwnerAccountName];
    
      return [own1 compare: own2];     
      break;
 
    default:
      break;
  }

  return 1;
}

static inline int comp_Cells(id *c1, id *c2, void *context)
{
	NSDictionary *sdict = (NSDictionary *)context;
	NSString *basepath = [sdict objectForKey: @"path"];
	int stype = [[sdict objectForKey: @"type"] intValue];

  NSString *s1 = [basepath stringByAppendingPathComponent: [(NSCell *)c1 stringValue]];
  NSString *s2 = [basepath stringByAppendingPathComponent: [(NSCell *)c2 stringValue]];
  
  return comp_Paths((id *)s1, (id *)s2, (void *)stype);
}

NSString *cutLabelText(NSString *filename, id label, int lenght)
{
	if (lenght > 0) {
		return cut_Text(filename, label, lenght);
	}
	return @"";
}

BOOL subPathOfPath(NSString *p1, NSString *p2)
{
  int l1 = [p1 length];
  int l2 = [p2 length];  

  if ((l1 > l2) || ([p1 isEqualToString: p2])) {
    return NO;
  }

  return [[p2 substringToIndex: l1] isEqualToString: p1];
}

int compPaths(id *p1, id *p2, void *context)
{
  return comp_Paths(p1, p2, context);
}

int compCells(id *c1, id *c2, void *context)
{
  return comp_Cells(c1, c2, context);
}
