 /*  -*-objc-*-
 *  ProcsView.m: Implementation of the ProcsView Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "ProcsView.h"
#include "Functions.h"
#include "GNUstep.h"

@implementation ProcsView

- (void)dealloc
{
  RELEASE(popUp);
  RELEASE(scrollView);
  RELEASE(controlsView);
  [super dealloc];
}

- (id)initWithFrame:(NSRect)frameRect 
{
  self = [super initWithFrame: frameRect];
  if (self) {    
    NSRect rect = NSMakeRect(136, frameRect.size.height - 24, 112, 20);

    popUp = [[NSPopUpButton alloc] initWithFrame: rect pullsDown: NO];
    [popUp addItemWithTitle: NSLocalizedString(@"Applications", @"")];
    [popUp addItemWithTitle: NSLocalizedString(@"Background", @"")];
    [self addSubview: popUp];

    rect = NSMakeRect(8, 155, frameRect.size.width - 16, 73);    
    scrollView = [[NSScrollView alloc] initWithFrame: rect];
    [scrollView setHasHorizontalScroller: NO];
    [scrollView setHasVerticalScroller: YES]; 
    [scrollView setAutoresizingMask: NSViewHeightSizable];
    [self addSubview: scrollView];

    rect = NSMakeRect(8, 0, frameRect.size.width - 16, 150);    
    controlsView = [[NSView alloc] initWithFrame: rect];                             
    [self addSubview: controlsView];                          	
  }
  
  return self;
}

- (void)resizeWithOldSuperviewSize:(NSSize)oldFrameSize
{
  float w, h;
	
  [super resizeWithOldSuperviewSize: oldFrameSize];  	
	w = [self frame].size.width;
	h = [self frame].size.height;	
  [popUp setFrame: NSMakeRect(136, h - 24, 112, 20)];  
  [scrollView setFrame: NSMakeRect(8, 155, w - 16, h - 192)];    
  [controlsView setFrame: NSMakeRect(8,0, w - 16, 150)];
}

- (void)drawRect:(NSRect)rect
{
  float h = [self frame].size.height;
	
	STROKE_LINE (darkGrayColor, 0, h - 29, 384, h - 29);
	STROKE_LINE (whiteColor, 0, h - 30, 384, h - 30);
}

- (NSPopUpButton *)popUp
{
  return popUp;
}

- (id)scrollView
{
  return scrollView;
}

- (id)controlsView
{
  return controlsView;
}

@end
