/*  -*-objc-*-
 *  ImageViewer.m: Implementation of the ImageViewer Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "ImageViewer.h"
#include "../../InspectorsProtocol.h"
#include "GNUstep.h"

@implementation ImageViewer

- (void)dealloc
{
	RELEASE (extsarr);
	TEST_RELEASE (imview);
	RELEASE (label);
  [super dealloc];
}

- (id)initInPanel:(id)apanel withFrame:(NSRect)frame index:(int)idx
{
	self = [super init];

	if(self) {
		id buttCancel, buttOk;
		NSString *suffs = @"tiff, tif, TIFF, TIF, jpeg, jpg, JPEG, JPG, gif, GIF, xpm";
	  [self setFrame: frame];
		panel = (id<InspectorsProtocol>)apanel;
		index = idx;

		extsarr = [[NSArray alloc] initWithArray: [suffs componentsSeparatedByString:@", "]];
		
		imrect = NSMakeRect(0, 10, 257, 235);
		imview = [[NSImageView alloc] initWithFrame: imrect];
		[imview setImageFrameStyle: NSImageFrameGrayBezel];
		[imview setImageAlignment: NSImageAlignCenter];
		[self addSubview: imview]; 
		
		label = [[NSTextField alloc] initWithFrame: NSMakeRect(2, 133, 255, 25)];	
		[label setFont: [NSFont systemFontOfSize: 18]];
		[label setAlignment: NSCenterTextAlignment];
		[label setBackgroundColor: [NSColor windowBackgroundColor]];
		[label setTextColor: [NSColor grayColor]];	
		[label setBezeled: NO];
		[label setEditable: NO];
		[label setSelectable: NO];
		[label setStringValue: @"Invalid Contents"];
		
		valid = YES;
		
		buttCancel = [panel revertButton];	
		[buttCancel setEnabled: NO];	
		buttOk = [panel okButton];
		[buttOk setEnabled: YES];
	}
	
	return self;
}

- (void)activateForPath:(NSString *)path
{
	NSImage *image = [[NSImage alloc] initWithContentsOfFile: path];
	
	if (image != nil) {
		NSSize is = [image size];
		NSSize rs = imrect.size;
	
		if (valid == NO) {
			valid = YES;
			[label removeFromSuperview];
			[self addSubview: imview]; 
		}

		if ((is.width <= rs.width) && (is.height <= rs.height)) {
			[imview setImageScaling: NSScaleNone];
		} else {
			[imview setImageScaling: NSScaleProportionally];
		}
		
		[imview setImage: image];
		RELEASE (image);
		
	} else {
		if (valid == YES) {
			valid = NO;
			[imview removeFromSuperview];
			[self addSubview: label];
		}
	}
}

- (void)deactivate
{
	[self removeFromSuperview];
}

- (BOOL)canDisplayFileOfType:(NSString *)fileType 
							 nameExtension:(NSString *)extension
{
	int i;
	
	if([fileType isEqualToString: NSPlainFileType] == NO) {
		return NO;
	}

	for(i = 0; i < [extsarr count]; i++) {
		if([[extsarr objectAtIndex: i] isEqualToString: extension]) {
			return YES;
    }
	}

	return NO;
}

- (int)index
{
	return index;
}

- (NSString *)winname
{
	return NSLocalizedString(@"Image Inspector", @"");	
}

@end
