/*  -*-objc-*-
 *  PermsBox.m: Implementation of the PermsBox Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "PermsBox.h"
#include "AttributesPanel.h"
#include "PermissionsPanel.h"
#include "Functions.h"
#include "GNUstep.h"
#include <sys/stat.h>

#define MAKE_BUTTON(b, r) { \
b = [[NSButton alloc] initWithFrame: r]; \
[b setButtonType: NSSwitchButton]; \
[b setBordered: NO]; \
[b setImagePosition: NSImageOnly]; \
[b setImage: offImage]; \
[b setAlternateImage: onImage]; \
[b setTarget: self]; \
[b setAction: @selector(buttonClicked:)];	\
[self addSubview: b]; \
}

#define SET_BUTTON_STATE(b, v) { \
if ((perms & v) == v) [b setState: NSOnState]; \
else [b setState: NSOffState]; \
}

#define GET_BUTTON_STATE(b, v) { \
if ([b state] == NSOnState) { \
perms |= v; \
} else { \
if ((oldperms & v) == v) { \
if ([b image] == multipleImage) perms |= v; \
} } \
}

@implementation PermsBox

- (void)dealloc
{
	RELEASE (ureadbutt);
	RELEASE (uwritebutt);
	RELEASE (greadbutt);
	RELEASE (gwritebutt);
	RELEASE (oreadbutt);
	RELEASE (owritebutt);
	RELEASE (onImage);
	RELEASE (offImage);
	RELEASE (multipleImage);
  [super dealloc];
}

- (id)initInPanel:(id)aPanel
{
	id label;
		
	self = [super initWithFrame: NSMakeRect(0, 0, 177, 93)];
	if(self) {
		panel = (AttributesPanel *)aPanel;
	
    [self setBorderType: NSGrooveBorder];
		[self setTitle: NSLocalizedString(@"Permissions", @"")];
    [self setTitlePosition: NSAtTop];
		[self setContentViewMargins: NSMakeSize(0, 0)]; 

    onImage = [NSImage imageNamed: @"switchOn.tiff"];
    RETAIN (onImage);
    offImage = [NSImage imageNamed: @"switchOff.tiff"];
    RETAIN (offImage);
    multipleImage = [NSImage imageNamed: @"switchMultiple.tiff"];
    RETAIN (multipleImage);

		MAKE_LOCALIZED_LABEL(label, NSMakeRect(0, 45, 33, 20), @"Read", @"", 'r', YES, self);
		MAKE_LOCALIZED_LABEL(label, NSMakeRect(0, 27, 33, 20), @"Write", @"", 'r', YES, self);

		MAKE_BUTTON (ureadbutt, NSMakeRect(53, 47, 14, 14));		
		MAKE_BUTTON (uwritebutt, NSMakeRect(53, 31, 14, 14));
		MAKE_BUTTON (greadbutt, NSMakeRect(95, 47, 14, 14));
		MAKE_BUTTON (gwritebutt, NSMakeRect(95, 31, 14, 14));
		MAKE_BUTTON (oreadbutt, NSMakeRect(137, 47, 14, 14));
		MAKE_BUTTON (owritebutt, NSMakeRect(137, 31, 14, 14));

		MAKE_LOCALIZED_LABEL(label, NSMakeRect(40, 9, 42, 20), @"Owner", @"", 'c', YES, self);
		MAKE_LOCALIZED_LABEL(label, NSMakeRect(82, 9, 42, 20), @"Group", @"", 'c', YES, self);
		MAKE_LOCALIZED_LABEL(label, NSMakeRect(124, 9, 42, 20), @"Other", @"", 'c', YES, self);
	}
	
	return self;
}

- (void)setPermissions:(int)perms isActive:(BOOL)active
{
	if (active == NO) {
		[ureadbutt setEnabled: NO];						
		[uwritebutt setEnabled: NO];						
		[greadbutt setEnabled: NO];						
		[gwritebutt setEnabled: NO];						
		[oreadbutt setEnabled: NO];						
		[owritebutt setEnabled: NO];						
	} else {
		[ureadbutt setEnabled: YES];						
		[uwritebutt setEnabled: YES];						
		[greadbutt setEnabled: YES];						
		[gwritebutt setEnabled: YES];						
		[oreadbutt setEnabled: YES];						
		[owritebutt setEnabled: YES];						
	}
		
	if (perms == 0) {
		multiplePaths = YES;
		[ureadbutt setImage: multipleImage];
		[ureadbutt setState: NSOffState];
		[uwritebutt setImage: multipleImage];
		[uwritebutt setState: NSOffState];
		[greadbutt setImage: multipleImage];
		[greadbutt setState: NSOffState];
		[gwritebutt setImage: multipleImage];
		[gwritebutt setState: NSOffState];
		[oreadbutt setImage: multipleImage];
		[oreadbutt setState: NSOffState];
		[owritebutt setImage: multipleImage];
		[owritebutt setState: NSOffState];
		return;
	} else {
		multiplePaths = NO;
		[ureadbutt setImage: offImage];
		[uwritebutt setImage: offImage];
		[greadbutt setImage: offImage];
		[gwritebutt setImage: offImage];
		[oreadbutt setImage: offImage];
		[owritebutt setImage: offImage];
	}

	SET_BUTTON_STATE (ureadbutt, S_IRUSR);				
	SET_BUTTON_STATE (uwritebutt, S_IWUSR);
	SET_BUTTON_STATE (greadbutt, S_IRGRP);
	SET_BUTTON_STATE (gwritebutt, S_IWGRP);
	SET_BUTTON_STATE (oreadbutt, S_IROTH);
	SET_BUTTON_STATE (owritebutt, S_IWOTH);
		
	[self setNeedsDisplay: YES];
}

- (int)getPermissions:(int)oldperms
{
	int perms = 0;

	GET_BUTTON_STATE (ureadbutt, S_IRUSR);
	GET_BUTTON_STATE (uwritebutt, S_IWUSR);

	if ((oldperms & S_IXUSR) == S_IXUSR) perms |= S_IXUSR;		
	if ((oldperms & S_ISUID) == S_ISUID) perms |= S_ISUID;

	GET_BUTTON_STATE (greadbutt, S_IRGRP);
	GET_BUTTON_STATE (gwritebutt, S_IWGRP);

	if ((oldperms & S_IXGRP) == S_IXGRP) perms |= S_IXGRP;		
	if ((oldperms & S_ISGID) == S_ISGID) perms |= S_ISGID;

	GET_BUTTON_STATE (oreadbutt, S_IROTH);
	GET_BUTTON_STATE (owritebutt, S_IWOTH);
	
	if ((oldperms & S_IXOTH) == S_IXOTH) perms |= S_IXOTH;
	if ((oldperms & S_ISVTX) == S_ISVTX) perms |= S_ISVTX;
	
	return perms;
}

- (void)buttonClicked:(id)sender
{
	if (multiplePaths == YES) {
		if ([sender state] == NSOffState) {
			if ([sender image] == multipleImage) 
				[sender setImage: offImage];	
		} else {
			if ([sender image] == offImage) {
				[sender setImage: multipleImage];
				[sender setState: NSOffState];		
			}
		}
	}	

	[panel permsButtonClicked];
}

- (void)drawRect:(NSRect)rect
{
	[super drawRect: rect];

	[[NSColor darkGrayColor] set];
	
	// -- orizz --
	[NSBezierPath strokeLineFromPoint: NSMakePoint(40, 65) 
														toPoint: NSMakePoint(166, 65)];
	[NSBezierPath strokeLineFromPoint: NSMakePoint(40, 49) 
														toPoint: NSMakePoint(166, 49)];
	[NSBezierPath strokeLineFromPoint: NSMakePoint(40, 33) 
														toPoint: NSMakePoint(166, 33)];

	// -- vert --
	[NSBezierPath strokeLineFromPoint: NSMakePoint(40, 65) 
														toPoint: NSMakePoint(40, 33)];
	[NSBezierPath strokeLineFromPoint: NSMakePoint(82, 65) 
														toPoint: NSMakePoint(82, 33)];
	[NSBezierPath strokeLineFromPoint: NSMakePoint(124, 65) 
														toPoint: NSMakePoint(124, 33)];
	[NSBezierPath strokeLineFromPoint: NSMakePoint(166, 65) 
														toPoint: NSMakePoint(166, 33)];
}

@end

@implementation PermsBox2

- (void)dealloc
{
	RELEASE (ureadbutt);
	RELEASE (uwritebutt);
	RELEASE (uexebutt);
	RELEASE (greadbutt);
	RELEASE (gwritebutt);
	RELEASE (gexebutt);
	RELEASE (oreadbutt);
	RELEASE (owritebutt);
	RELEASE (oexebutt);
	RELEASE (onImage);
	RELEASE (offImage);
	RELEASE (multipleImage);
  [super dealloc];
}

- (id)initInPanel:(id)aPanel
{
	self = [super initWithFrame: NSMakeRect(0, 0, 200, 74)];
	
	if(self) {
		id label;

		panel = (PermissionsPanel *)aPanel;
	
    onImage = [NSImage imageNamed: @"switchOn.tiff"];
    RETAIN (onImage);
    offImage = [NSImage imageNamed: @"switchOff.tiff"];
    RETAIN (offImage);
    multipleImage = [NSImage imageNamed: @"switchMultiple.tiff"];
    RETAIN (multipleImage);

		MAKE_LOCALIZED_LABEL (label, NSMakeRect(0, 52, 58, 20), @"Read", @"", 'r', YES, self);		
		MAKE_LOCALIZED_LABEL (label, NSMakeRect(0, 35, 58, 20), @"Write", @"", 'r', YES, self);		
		MAKE_LOCALIZED_LABEL (label, NSMakeRect(0, 18, 58, 20), @"Execute", @"", 'r', YES, self);
		
		MAKE_BUTTON (ureadbutt, NSMakeRect(77, 55, 14, 14));
		MAKE_BUTTON (uwritebutt, NSMakeRect(77, 38, 14, 14));
		MAKE_BUTTON (uexebutt, NSMakeRect(77, 21, 14, 14));
		MAKE_BUTTON (greadbutt, NSMakeRect(122, 55, 14, 14));
		MAKE_BUTTON (gwritebutt, NSMakeRect(122, 38, 14, 14));
		MAKE_BUTTON (gexebutt, NSMakeRect(122, 21, 14, 14));
		MAKE_BUTTON (oreadbutt, NSMakeRect(167, 55, 14, 14));
		MAKE_BUTTON (owritebutt, NSMakeRect(167, 38, 14, 14));
		MAKE_BUTTON (oexebutt, NSMakeRect(167, 21, 14, 14));

		MAKE_LOCALIZED_LABEL (label, NSMakeRect(62, 0, 45, 20), @"Owner", @"", 'c', YES, self);
		MAKE_LOCALIZED_LABEL (label, NSMakeRect(107, 0, 45, 20), @"Group", @"", 'c', YES, self);
		MAKE_LOCALIZED_LABEL (label, NSMakeRect(152, 0, 45, 20), @"Other", @"", 'c', YES, self);
	}
	
	return self;
}

- (void)setPermissions:(int)perms isActive:(BOOL)active
{
	if (active == NO) {
		[ureadbutt setEnabled: NO];						
		[uwritebutt setEnabled: NO];	
		[uexebutt setEnabled: NO];	
		[greadbutt setEnabled: NO];						
		[gwritebutt setEnabled: NO];
		[gexebutt setEnabled: NO];			
		[oreadbutt setEnabled: NO];						
		[owritebutt setEnabled: NO];
		[oexebutt setEnabled: NO];	
								
	} else {
		[ureadbutt setEnabled: YES];						
		[uwritebutt setEnabled: YES];		
		[uexebutt setEnabled: YES];	
		[greadbutt setEnabled: YES];						
		[gwritebutt setEnabled: YES];		
		[gexebutt setEnabled: YES];	
		[oreadbutt setEnabled: YES];						
		[owritebutt setEnabled: YES];			
		[oexebutt setEnabled: YES];	
	}

	if (perms == 0) {
		multiplePaths = YES;
		[ureadbutt setImage: multipleImage];
		[ureadbutt setState: NSOffState];
		[uwritebutt setImage: multipleImage];
		[uwritebutt setState: NSOffState];
		[uexebutt setImage: multipleImage];
		[uexebutt setState: NSOffState];	
		[greadbutt setImage: multipleImage];
		[greadbutt setState: NSOffState];
		[gwritebutt setImage: multipleImage];
		[gwritebutt setState: NSOffState];
		[gexebutt setImage: multipleImage];
		[gexebutt setState: NSOffState];
		[oreadbutt setImage: multipleImage];
		[oreadbutt setState: NSOffState];
		[owritebutt setImage: multipleImage];
		[owritebutt setState: NSOffState];
		[oexebutt setImage: multipleImage];
		[oexebutt setState: NSOffState];
		return;
	} else {
		multiplePaths = NO;
		[ureadbutt setImage: offImage];
		[uwritebutt setImage: offImage];
		[uexebutt setImage: offImage];	
		[greadbutt setImage: offImage];
		[gwritebutt setImage: offImage];
		[gexebutt setImage: offImage];
		[oreadbutt setImage: offImage];
		[owritebutt setImage: offImage];
		[oexebutt setImage: offImage];
	}

	SET_BUTTON_STATE (ureadbutt, S_IRUSR);				
	SET_BUTTON_STATE (uwritebutt, S_IWUSR);
	SET_BUTTON_STATE (uexebutt, S_IXUSR);
	SET_BUTTON_STATE (greadbutt, S_IRGRP);
	SET_BUTTON_STATE (gwritebutt, S_IWGRP);
	SET_BUTTON_STATE (gexebutt, S_IXGRP);
	SET_BUTTON_STATE (oreadbutt, S_IROTH);
	SET_BUTTON_STATE (owritebutt, S_IWOTH);
	SET_BUTTON_STATE (oexebutt, S_IXOTH);
		
	[self setNeedsDisplay: YES];
}

- (int)getPermissions:(int)oldperms
{
	int perms = 0;

	GET_BUTTON_STATE (ureadbutt, S_IRUSR);
	GET_BUTTON_STATE (uwritebutt, S_IWUSR);
	GET_BUTTON_STATE (uexebutt, S_IXUSR);
	
	if ((oldperms & S_ISUID) == S_ISUID) perms |= S_ISUID;

	GET_BUTTON_STATE (greadbutt, S_IRGRP);
	GET_BUTTON_STATE (gwritebutt, S_IWGRP);
	GET_BUTTON_STATE (gexebutt, S_IXGRP);
		
	if ((oldperms & S_ISGID) == S_ISGID) perms |= S_ISGID;

	GET_BUTTON_STATE (oreadbutt, S_IROTH);
	GET_BUTTON_STATE (owritebutt, S_IWOTH);
	GET_BUTTON_STATE (oexebutt, S_IXOTH);
		
	if ((oldperms & S_ISVTX) == S_ISVTX) perms |= S_ISVTX;
	
	return perms;
}

- (void)buttonClicked:(id)sender
{
	if (multiplePaths == YES) {
		if ([sender state] == NSOffState) {
			if ([sender image] == multipleImage) 
				[sender setImage: offImage];	
		} else {
			if ([sender image] == offImage) {
				[sender setImage: multipleImage];
				[sender setState: NSOffState];		
			}
		}
	}	

	[panel permsButtonClicked];
}

- (void)drawRect:(NSRect)rect
{
	[super drawRect: rect];

	[[NSColor darkGrayColor] set];
	
	// -- orizz --
	[NSBezierPath strokeLineFromPoint: NSMakePoint(62, 72) 
														toPoint: NSMakePoint(197, 72)];
	[NSBezierPath strokeLineFromPoint: NSMakePoint(62, 55) 
														toPoint: NSMakePoint(197, 55)];
	[NSBezierPath strokeLineFromPoint: NSMakePoint(62, 38) 
														toPoint: NSMakePoint(197, 38)];
	[NSBezierPath strokeLineFromPoint: NSMakePoint(62, 21) 
														toPoint: NSMakePoint(197, 21)];

	// -- vert --
	[NSBezierPath strokeLineFromPoint: NSMakePoint(62, 72) 
														toPoint: NSMakePoint(62, 21)];
	[NSBezierPath strokeLineFromPoint: NSMakePoint(107, 72) 
														toPoint: NSMakePoint(107, 21)];
	[NSBezierPath strokeLineFromPoint: NSMakePoint(152, 72) 
														toPoint: NSMakePoint(152, 21)];
	[NSBezierPath strokeLineFromPoint: NSMakePoint(197, 72) 
														toPoint: NSMakePoint(197, 21)];
}

@end
