/*  -*-objc-*-
 *  AttributesPanel.m: Implementation of the AttributesPanel Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "AttributesPanel.h"
#include "PermsBox.h"
#include "TimeDateView.h"
#include "Functions.h"
#include "GNUstep.h"
#include <unistd.h>
#include <sys/types.h>

@implementation AttributesPanel

- (void)dealloc
{
	RELEASE (insppaths);
	RELEASE (currentPath);
	RELEASE (fileIcon);	
	RELEASE (multipleIcon);
	RELEASE (attributes);
	RELEASE (namefield);
	RELEASE (pathfield);
	RELEASE (linktolabel);
	RELEASE (linktofield);		
	RELEASE (sizefield);					
	RELEASE (ownerfield);					
	RELEASE (groupfield);					
	RELEASE (calculateButt);		
	RELEASE (permissionsBox);		
	RELEASE (timeDateView);
	RELEASE (yearlabel);
	RELEASE (changedDateBox);		
	RELEASE (revertbutt);
	RELEASE (okbutt);		
  [super dealloc];
}

- (id)init
{
	self = [super init];
	
	if(self) {
		id label;

		[self setFrame: NSMakeRect(0, 0, 274, 385)];	
			
    multipleIcon = [NSImage imageNamed: @"MultipleSelection.tiff"];
		RETAIN (multipleIcon);
		
		fm = [NSFileManager defaultManager];
		insppaths = nil;
		attributes = nil;
		fileIcon = nil;
				
		MAKE_LABEL (namefield, NSMakeRect(66, 343, 200, 25), nil, 'l', NO, self);		
		[namefield setFont: [NSFont systemFontOfSize: 18]];		
		MAKE_LOCALIZED_LABEL (label, NSMakeRect(9, 301, 40, 20), @"Path:", @"", 'l', YES, self);				
		MAKE_LABEL (pathfield, NSMakeRect(44, 301, 215, 20), nil, 'l', NO, self);
		MAKE_LOCALIZED_LABEL (linktolabel, NSMakeRect(9, 249, 52, 20), @"Link To:", @"", 'l', NO, self);
		MAKE_LABEL (linktofield, NSMakeRect(64, 249, 205, 20), nil, 'l', NO, self);

		MAKE_LOCALIZED_LABEL (label, NSMakeRect(6, 208, 70, 20), @"Size:", @"", 'l', YES, self);
		MAKE_LABEL (sizefield, NSMakeRect(85, 208, 205, 20), nil, 'l', NO, self);
		MAKE_LOCALIZED_LABEL (label, NSMakeRect(6, 179, 70, 20), @"Owner:", @"", 'l', YES, self);
		MAKE_LABEL (ownerfield, NSMakeRect(85, 179, 122, 20), nil, 'l', NO, self);
		MAKE_LOCALIZED_LABEL (label, NSMakeRect(6, 150, 70, 20), @"Group:", @"", 'l', YES, self);
		MAKE_LABEL (groupfield, NSMakeRect(85, 150, 122, 20), nil, 'l', NO, self);

		calculateButt = [[NSButton alloc] initWithFrame: NSMakeRect(199, 150, 64, 77)];
		[calculateButt setButtonType: NSMomentaryLight];
		[calculateButt setImagePosition: NSImageOnly];			
		[self addSubview: calculateButt]; 

    permissionsBox = [[PermsBox alloc] initInPanel: self];																	
		[permissionsBox setFrameOrigin: NSMakePoint(9, 44)];
		[self addSubview: permissionsBox]; 		

    changedDateBox = [[NSBox alloc] initWithFrame: NSMakeRect(194, 44, 71, 93)];
    [changedDateBox setBorderType: NSGrooveBorder];
		[changedDateBox setTitle: NSLocalizedString(@"Changed", @"")];
    [changedDateBox setTitlePosition: NSAtTop];
		[changedDateBox setContentViewMargins: NSZeroSize];

		timeDateView = [[TimeDateView alloc] init];
		[timeDateView setFrame: NSMakeRect(6, 13, 55, 57)];
		[[changedDateBox contentView] addSubview: timeDateView]; 

		MAKE_LABEL (yearlabel, NSMakeRect(6, 1, 55, 12), nil, 'l', NO, changedDateBox);
		[yearlabel setFont: [NSFont systemFontOfSize: 8]];
		[yearlabel setAlignment: NSCenterTextAlignment];
		
		[self addSubview: changedDateBox]; 
		
		revertbutt = [[NSButton alloc] initWithFrame: NSMakeRect(17, 10, 115, 24)];
		[revertbutt setButtonType: NSMomentaryLight];
		[revertbutt setTitle: NSLocalizedString(@"Revert", @"")];		
		[revertbutt setTarget: self];
		[revertbutt setAction: @selector(revertToOldPermissions:)];
		[self addSubview: revertbutt]; 
				
		okbutt = [[NSButton alloc] initWithFrame: NSMakeRect(140, 10, 115, 24)];
		[okbutt setButtonType: NSMomentaryLight];
		[okbutt setTitle: NSLocalizedString(@"OK", @"")];	
		[okbutt setKeyEquivalent: @"\r"];
		[okbutt setImagePosition: NSImageRight];
		[okbutt setImage: [NSImage imageNamed: @"common_ret"]];	
		[okbutt setTarget: self];
		[okbutt setAction: @selector(changePermissions:)];
		[self addSubview: okbutt]; 
	}		
	return self;
}

- (void)activateForPaths:(NSArray *)paths
{
	id image;
	NSString *fpath;
	NSString *ftype, *fsize, *s;
	NSString *usr, *grp, *tmpusr, *tmpgrp;
	NSDate *date, *tmpdate;
	NSCalendarDate *cdate;
	NSDictionary *attrs;
	int perms;
	BOOL sameOwner, sameGroup;
	int i;
	
	attrs = [fm fileAttributesAtPath: [paths objectAtIndex: 0] traverseLink: NO];
	if([attrs isEqualToDictionary: attributes] && [paths isEqualToArray: insppaths]) {
		return;
	}

	ASSIGN (insppaths, paths);	
	pathscount = [insppaths count];	
	ASSIGN (currentPath, [insppaths objectAtIndex: 0]);		
	ASSIGN (attributes, attrs);	

	[revertbutt setEnabled: NO];
	[okbutt setEnabled: NO];
	
	if (pathscount == 1) {   // Single Selection
		usr = [attributes objectForKey: NSFileOwnerAccountName];
		grp = [attributes objectForKey: NSFileGroupOwnerAccountName];
		date = [attributes objectForKey: NSFileModificationDate];
		perms = [[attributes objectForKey: NSFilePosixPermissions] intValue];			

		iamRoot = (geteuid() == 0);
		isMyFile = ([NSUserName() isEqualToString: usr]);

		ftype = [attributes objectForKey: NSFileType];
		if([ftype isEqualToString: NSFileTypeDirectory] == NO) {			
			fsize = fileSizeDescription([[attributes objectForKey: NSFileSize] intValue]);
		} else {
			fsize = @"";
		}

		ASSIGN (fileIcon, [[NSWorkspace sharedWorkspace] iconForFile: currentPath]);

		[namefield setStringValue: [currentPath lastPathComponent]];

		s = [currentPath stringByDeletingLastPathComponent];
		s = relativePathFittingInContainer(pathfield, s);
		[pathfield setStringValue: s];

		if ([ftype isEqualToString: NSFileTypeSymbolicLink] == YES) {
			s = [fm pathContentOfSymbolicLinkAtPath: currentPath];
			s = relativePathFittingInContainer(linktofield, s);
			[linktofield setStringValue: s];
		} else {
			[linktofield setStringValue: @""];
			[linktolabel setTextColor: [NSColor grayColor]];		
		}
			
		[sizefield setStringValue: fsize]; 
		[ownerfield setStringValue: usr]; 
		[groupfield setStringValue: grp]; 

		if ([ftype isEqualToString: NSFileTypeDirectory] == YES) {
      image = [NSImage imageNamed: @"ComputeSize.tiff"];
			[calculateButt setTarget: self];
			[calculateButt setAction: @selector(computeSize:)];
			[calculateButt setEnabled: YES];
		} else {
      image = [NSImage imageNamed: @"ComputeSize_dimm.tiff"];
			[calculateButt setEnabled: NO];		
		}
		[calculateButt setImage: image];

		[permissionsBox setPermissions: perms isActive: (iamRoot || isMyFile)];

		cdate = [date dateWithCalendarFormat: nil timeZone: nil];	
		[timeDateView setDate: cdate];
		[yearlabel setStringValue: [NSString stringWithFormat: @"%d", [cdate yearOfCommonEra]]];

	} else {	   // Multiple Selection
	
		ftype = [attributes objectForKey: NSFileType];
		fsize = @"";
		usr = [attributes objectForKey: NSFileOwnerAccountName];
		grp = [attributes objectForKey: NSFileGroupOwnerAccountName];
		date = [attributes objectForKey: NSFileModificationDate];
		perms = [[attributes objectForKey: NSFilePosixPermissions] intValue];			

		sameOwner = YES;
		sameGroup = YES;
		
		for (i = 0; i < [insppaths count]; i++) {
			fpath = [insppaths objectAtIndex: i];
			attrs = [fm fileAttributesAtPath: fpath traverseLink: NO];
			tmpusr = [attrs objectForKey: NSFileOwnerAccountName];
			if ([tmpusr isEqualToString: usr] == NO) {
				sameOwner = NO;
			}
			tmpgrp = [attrs objectForKey: NSFileGroupOwnerAccountName];
			if ([tmpgrp isEqualToString: grp] == NO) {
				sameGroup = NO;
			}
			tmpdate = [date earlierDate: [attrs objectForKey: NSFileModificationDate]];
		}
		
		if(!sameOwner) {
			usr = @"-";
		}
		if(!sameGroup) {
			grp = @"-";
		}

		iamRoot = (geteuid() == 0);
		isMyFile = ([NSUserName() isEqualToString: usr]);
		
		cdate = [tmpdate dateWithCalendarFormat: nil timeZone: nil];	
		
		ASSIGN (fileIcon, multipleIcon);
		
		[namefield setStringValue: [NSString stringWithFormat: @"%i items", pathscount]];

		s = [currentPath stringByDeletingLastPathComponent];
		s = relativePathFittingInContainer(pathfield, s);
		[pathfield setStringValue: s];

		[linktolabel setTextColor: [NSColor grayColor]];		
		[linktofield setStringValue: @""];

		[sizefield setStringValue: fsize]; 
		[ownerfield setStringValue: usr]; 
		[groupfield setStringValue: grp]; 

    image = [NSImage imageNamed: @"ComputeSize.tiff"];
		[calculateButt setTarget: self];
		[calculateButt setAction: @selector(computeSize:)];
		[calculateButt setEnabled: YES];
		[calculateButt setImage: image];

		[permissionsBox setPermissions: 0 isActive: (iamRoot || isMyFile)];
		
		cdate = [date dateWithCalendarFormat: nil timeZone: nil];	
		[timeDateView setDate: cdate];
		[yearlabel setStringValue: [NSString stringWithFormat: @"%d", [cdate yearOfCommonEra]]];	
	}
	
	[self setNeedsDisplay: YES];
}

- (void)deactivate
{
	[self removeFromSuperview];
}

- (NSString *)inspname
{
	return NSLocalizedString(@"Attributes", @"");
}

- (NSString *)winname
{
	return NSLocalizedString(@"Attributes Inspector", @"");
}

- (NSButton *)revertButton
{
	return revertbutt;
}

- (NSButton *)okButton
{
	return okbutt;
}

- (void)computeSize:(id)sender
{							
	NSImage *image;
	float dirsize;
	int fsize, i;
	
	[calculateButt setEnabled: NO];	
	dirsize = 0;

 	for(i = 0; i < [insppaths count]; i++) {
		NSString *path, *filePath;
		NSDictionary *fileAttrs;
		BOOL isdir;
		
		path = [insppaths objectAtIndex: i];
		[fm fileExistsAtPath: path isDirectory: &isdir];
		 
		if (isdir) {
			NSDirectoryEnumerator *enumerator = [fm enumeratorAtPath: path];
			
			while((filePath = [enumerator nextObject])) {
				filePath = [path stringByAppendingPathComponent: filePath];
				fileAttrs = [fm fileAttributesAtPath: filePath traverseLink: NO];
				if(fileAttrs != nil) {
					fsize = [[fileAttrs objectForKey: NSFileSize] intValue];
					dirsize += fsize;
				}
			}
			
		} else {
			fileAttrs = [fm fileAttributesAtPath: path traverseLink: NO];
			if (fileAttrs != nil) {
				fsize = [[fileAttrs objectForKey: NSFileSize] intValue];
				dirsize += fsize;
			}
		}
	}	
		
	[sizefield setStringValue: fileSizeDescription(dirsize)]; 
  image = [NSImage imageNamed: @"ComputeSize_dimm.tiff"];  
	[calculateButt setImage: image];
	[self setNeedsDisplay: YES];
}

- (void)permsButtonClicked
{
	if(!(iamRoot || isMyFile)) {
		return;
	}
	[revertbutt setEnabled: YES];	
	[okbutt setEnabled: YES];
}

- (void)changePermissions:(id)sender
{
	NSMutableDictionary *attrs;
	NSString *fpath;
	int oldperms, newperms, i;
	
	if (pathscount == 1) {	
		oldperms = [[attributes objectForKey: NSFilePosixPermissions] intValue];
		newperms = [permissionsBox getPermissions: oldperms];		
		attrs = [attributes mutableCopy];
		[attrs setObject: [NSNumber numberWithInt: newperms] forKey: NSFilePosixPermissions];
		[fm changeFileAttributes: attrs atPath: currentPath];	
		RELEASE (attrs);	
		ASSIGN (attributes, [fm fileAttributesAtPath: currentPath traverseLink: NO]);
		newperms = [[attributes objectForKey: NSFilePosixPermissions] intValue];				
		[permissionsBox setPermissions: newperms isActive: YES];
				
	} else {	
		for(i = 0; i < [insppaths count]; i++) {
			fpath = [insppaths objectAtIndex: i];
			attrs = [[fm fileAttributesAtPath: fpath traverseLink: NO] mutableCopy];
			oldperms = [[attrs objectForKey: NSFilePosixPermissions] intValue];	
			newperms = [permissionsBox getPermissions: oldperms];			
			[attrs setObject: [NSNumber numberWithInt: newperms] forKey: NSFilePosixPermissions];
			[fm changeFileAttributes: attrs atPath: fpath];
			RELEASE (attrs);
		}		
		ASSIGN (attributes, [fm fileAttributesAtPath: currentPath traverseLink: NO]);
		[permissionsBox setPermissions: 0 isActive: YES];
	}

	[okbutt setEnabled: NO];
	[revertbutt setEnabled: NO];
	[self setNeedsDisplay: YES];
	
	[[NSNotificationCenter defaultCenter]
 				postNotificationName: @"GWDidSetFileAttributesNotification"
	 					  object: (id)[currentPath stringByDeletingLastPathComponent]];
}

- (void)revertToOldPermissions:(id)sender
{
	if(pathscount == 1) {
		int perms = [[attributes objectForKey: NSFilePosixPermissions] intValue];
		[permissionsBox setPermissions: perms isActive: YES];	
	} else {
		[permissionsBox setPermissions: 0 isActive: YES];
	}
	
	[revertbutt setEnabled: NO];
	[okbutt setEnabled: NO];
}

- (void)drawRect:(NSRect)rect
{
	STROKE_LINE (darkGrayColor, 0, 385, 274, 385);
	STROKE_LINE (whiteColor, 0, 384, 274, 384);

	if (fileIcon != nil) {
    [fileIcon compositeToPoint: NSMakePoint(8, 325) 
						  	     operation: NSCompositeSourceOver];
  }
	
	STROKE_LINE (darkGrayColor, 0, 294, 274, 294);
	STROKE_LINE (whiteColor, 0, 293, 274, 293);
}

@end
