/*  -*-objc-*-
 *  GWSplitView.m: Implementation of the IconViewsIcon Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "GWSplitView.h"
#include "Viewers/ViewersWindow.h"
#include "Finder/Finder.h"
#include "Functions.h"
#include "GNUstep.h"

@implementation GWSplitView : NSSplitView 

- (void)dealloc
{
  RELEASE (infoField);
  TEST_RELEASE (infoString);
#ifndef GNUSTEP
	RELEASE (_backgroundColor);
#endif	
  [super dealloc];
}

- (id)initWithFrame:(NSRect)frameRect viewer:(id)viewer
{
  self = [super initWithFrame: frameRect]; 
 		
  if ([viewer isKindOfClass: [ViewersWindow class]]) {
    vwr = (ViewersWindow *)viewer;
  } else if ([viewer isKindOfClass: [Finder class]]) {
    vwr = (Finder *)viewer;
  } 
  
  infoField = [NSTextFieldCell new];
  [infoField setFont: [NSFont systemFontOfSize: 10]];
  [infoField setBordered: NO];
  [infoField setAlignment: NSLeftTextAlignment];
  [infoField setBackgroundColor: [NSColor windowBackgroundColor]];
  [infoField setTextColor: [NSColor grayColor]];		
  
	infoString = nil;
	
#ifndef GNUSTEP
	ASSIGN (_backgroundColor, [NSColor controlBackgroundColor]);
#endif		
	
  return self;
}

- (void)updateInfo:(NSString *)info
{
  ASSIGN (infoString, info);
  [self setNeedsDisplay: YES];
}

- (float)dividerThickness
{
  return 11;
}

- (void)drawDividerInRect:(NSRect)aRect
{
  NSRect r = NSMakeRect(8, aRect.origin.y, 200, 10);    
  [super drawDividerInRect: aRect];   
  [infoField setBackgroundColor: [self backgroundColor]];
	
	if (infoString != nil) {
  	[infoField setStringValue: infoString]; 
		[infoField drawWithFrame: r inView: self];
	}
}

#ifndef GNUSTEP
	- (NSColor*)backgroundColor
	{
  	return _backgroundColor;
	}

	- (void)setBackgroundColor:(NSColor *)aColor
	{
  	ASSIGN(_backgroundColor, aColor);
	}
#endif		

@end
