/*
Gwenview - A simple image viewer for KDE
Copyright (C) 2000-2002 Aurlien Gteau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

// Qt includes
#include <qpixmap.h>
#include <qpainter.h>

// KDE includes
#include <kdebug.h>

// Our includes
#include "fullscreenview.h"
#include "gvpixmap.h"
#include "scrollpixmapview.h"

#include "pixmapview.moc"



PixmapView::PixmapView(QWidget* parent,GVPixmap* pixmap)
: QWidgetStack(parent), mFullScreen(false)
{
// Create child widgets
	mScrollPixmapView=new ScrollPixmapView(this,pixmap,true);
	mFullScreenView=new FullScreenView(this,pixmap,false);

// Propagate child widget signals
	connect(mScrollPixmapView,SIGNAL(selectPrevious()),
		this,SIGNAL(selectPrevious()) );
	connect(mScrollPixmapView,SIGNAL(selectNext()),
		this,SIGNAL(selectNext()) );

	connect(mFullScreenView,SIGNAL(selectPrevious()),
		this,SIGNAL(selectPrevious()) );
	connect(mFullScreenView,SIGNAL(selectNext()),
		this,SIGNAL(selectNext()) );
	connect(mFullScreenView,SIGNAL(escapePressed()),
		this,SIGNAL(escapePressed()) );

// Add children to stack
	addWidget(mScrollPixmapView,0);
	addWidget(mFullScreenView,1);

// Show scroll pixmap widget by default
	raiseWidget(mScrollPixmapView);
}


PixmapView::~PixmapView() {
}


void PixmapView::readConfig(KConfig* config, const QString& group) {
	mScrollPixmapView->readConfig(config,group);
	mFullScreenView->readConfig(config,group);
}


void PixmapView::writeConfig(KConfig* config, const QString& group) const {
	mScrollPixmapView->writeConfig(config,group);
	mFullScreenView->writeConfig(config,group);
}


void PixmapView::setFullScreen(bool fullScreen) {
	mFullScreen=fullScreen;
	if (mFullScreen) {
		mScrollPixmapView->enableView(false);
		raiseWidget(mFullScreenView);
		mFullScreenView->enableView(true);
		mFullScreenView->updateView();
	} else {
		mFullScreenView->enableView(false);
		raiseWidget(mScrollPixmapView);
		mScrollPixmapView->enableView(true);
		mScrollPixmapView->updateView();
	}
}
