/*
Gwenview - A simple image viewer for KDE
Copyright (C) 2000-2002 Aurlien Gteau
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.
  
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
   
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    
*/
#ifndef GVPIXMAP_H
#define GVPIXMAP_H

// Qt includes
#include <qobject.h>
#include <qimage.h>

/**
 * A pixmap class with zooming capacities
 * Emits a signal when it changes
 */
class GVPixmap : public QObject {
Q_OBJECT
	QImage mImage;
	QPixmap mPixmap;
	QString mPath;
	void flatConvertToPixmap();
	void alphaConvertToPixmap();

public:
	GVPixmap(QObject*);
	~GVPixmap();
	void load(const QString&);
	void reset();

// Accessors
	const QPixmap& pixmap() const { return mPixmap; }
	const QImage& image() const { return mImage; }
	const QString& path() const { return mPath; }
	int width() const { return mImage.width(); }
	int height() const { return mImage.height(); }
	bool isNull() const { return mImage.isNull(); }

signals:
/**
 * Emitted when the class starts to load the image.
 */
	void loading();

/**
 * Emitted when the class has finished loading the image.
 * Also emitted if the image could not be loaded.
 */
	void loaded();
};


#endif
