/*
Gwenview - A simple image viewer for KDE
Copyright (C) 2000-2002 Aurlien Gteau
 
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.
  
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
   
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    
*/

// Qt includes
#include <qimage.h>
#include <qpainter.h>

// KDE includes
#include <kalphapainter.h>
#include <kpixmapio.h>

// Our includes
#include <gvpixmap.moc>


GVPixmap::GVPixmap(QObject* parent) 
: QObject(parent) 
{}


GVPixmap::~GVPixmap()
{}


void GVPixmap::load(const QString& path) {
	emit loading();

	if(mImage.load(path)) {
		mPath=path;
		if (mImage.hasAlphaBuffer()) {
			alphaConvertToPixmap();
		} else {
			flatConvertToPixmap();
		}
	} else {
		mImage.reset();
		mPath="";
	}
	emit loaded();
}


void GVPixmap::reset() {
	mPath="";
	mImage.reset();
	emit loaded();
}



//-Private-------------------------------------------------------------
void GVPixmap::flatConvertToPixmap() {
	mPixmap=KPixmapIO().convertToPixmap(mImage);
}


void GVPixmap::alphaConvertToPixmap() {
	int posX,posY;
	int imageWidth=width();
	int imageHeight=height();
	QPixmap back(imageWidth,imageHeight);
	QPainter painter;
	QColor dark(128,128,128);
	QColor light(192,192,192);

// Create background
	back.fill(dark);
	painter.begin(&back);
	for(posY=0;posY<imageHeight;posY+=16) {
		for(posX=0;posX<imageWidth;posX+=16) {
			painter.fillRect(posX,posY,8,8,light);
			painter.fillRect(posX+8,posY+8,8,8,light);
		}
	}
	painter.end();

// Alpha paint pixmap
	mPixmap.resize(imageWidth,imageHeight);
	painter.begin(&mPixmap);
	if (mImage.depth()<32) {
		KAlphaPainter::draw(&painter,mImage.convertDepth(32),back,0,0);
	} else {
		KAlphaPainter::draw(&painter,mImage,back,0,0);
	}
	painter.end();
}
