/*
Gwenview - A simple image viewer for KDE
Copyright (C) 2000-2002 Aurlien Gteau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

// KDE includes
#include <kdebug.h>
#include <kurldrag.h>

// Our includes
#include "filednddetailview.h"


FileDnDDetailView::FileDnDDetailView(QWidget *parent, const char *name)
: KFileDetailView(parent,name) {
	setDragEnabled(true);
}



void FileDnDDetailView::startDrag(){
	KFileViewItem* item=KFileView::selectedItems()->getFirst();
	if (!item) {
		kdWarning() << "No item to drag\n";
		return;
	}

	KURL::List urls;
	urls.append(item->url());

	QDragObject* drag = KURLDrag::newDrag( urls, this );
	drag->setPixmap( item->pixmap() );

	drag->dragCopy();
}


QListViewItem* FileDnDDetailView::lastChild() const {
	QListViewItem* item=firstChild();
	if (!item) return NULL;
	for (;item->nextSibling()!=NULL;item=item->nextSibling()) {}
	return item;
}


//-Browsable methods--------------------------------------------------------
void FileDnDDetailView::selectFirst() {
	QListViewItem* item=firstChild();
	if (!item) return;

	QListView::setCurrentItem(item);
	QListView::setSelected(item,true);
	QListView::ensureItemVisible(item);
}


void FileDnDDetailView::selectLast() {
	QListViewItem* item=lastChild();
	if (!item) return;

	QListView::setCurrentItem(item);
	QListView::setSelected(item,true);
	QListView::ensureItemVisible(item);
}


void FileDnDDetailView::selectPrevious() {
	QListViewItem* item=currentItem();
	if (!item) return;

	item=item->itemAbove();
	if (!item) return;

	QListView::setCurrentItem(item);
	QListView::setSelected(item,true);
	QListView::ensureItemVisible(item);
}


void FileDnDDetailView::selectNext() {
	QListViewItem* item=currentItem();
	if (!item) return;

	item=item->itemBelow();
	if (!item) return;

	QListView::setCurrentItem(item);
	QListView::setSelected(item,true);
	QListView::ensureItemVisible(item);
}


QString FileDnDDetailView::previousItemText() const {
	QListViewItem* item=currentItem();
	if (!item) return "";

	item=item->itemAbove();
	if (!item) return "";
	return item->text(0);
}


QString FileDnDDetailView::currentItemText() const {
	QListViewItem* item=currentItem();
	if (!item) return "";
	return item->text(0);
}


QString FileDnDDetailView::nextItemText() const {
	QListViewItem* item=currentItem();
	if (!item) return "";

	item=item->itemBelow();
	if (!item) return "";
	return item->text(0);
}


bool FileDnDDetailView::currentIsFirst() const {
	return currentItem()==firstChild();
}


bool FileDnDDetailView::currentIsLast() const {
	QListViewItem* item=currentItem();
	if (!item) return true; // Does not make much sense, but returning true is coherent with currentIsFirst
	return item->itemBelow()==NULL;
}
