/*
Gwenview - A simple image viewer for KDE
Copyright (C) 2000-2002 Aurlien Gteau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/


// Qt includes
#include <qdir.h>

// KDE includes
#include <kdebug.h>
#include <kdirlister.h>

// Our includes
#include "dirview.h"
#include "dirviewitem.h"


DirViewItem::DirViewItem(DirView* folderWidget, const QString& label)
: QListViewItem(folderWidget,label), mIsDropTarget(false), mDirView(folderWidget)
{
	setPixmap(0,SmallIcon("folder"));
}


DirViewItem::DirViewItem(DirView* folderWidget,QListViewItem* parent,const QString& label)
: QListViewItem(parent,label), mIsDropTarget(false), mDirView(folderWidget)
{
	setPixmap(0,SmallIcon("folder"));
}


/**
 * Find a sub item according to its label
 * ! Assumes that the item tree as already been explored !
 */
DirViewItem* DirViewItem::find(const QString& label) const {
	QListViewItem* child=firstChild();

	while(child) {
		if (child->text(0)==label) {
			return static_cast<DirViewItem*>(child);
		}
		child=child->nextSibling();
	}

	return 0L;
}


/**
 * Overrides setOpen to open URL with dir lister
 */
void DirViewItem::setOpen(bool open) {
	QListViewItem::setOpen(open);
	if (open) {
		mDirView->mDirLister->openURL(url(),true,true);
	}
}


/**
 * Dtermines if the item should be expandable or not
 * (ie if it contains at least one dir)
 */
void DirViewItem::initExpandable() {
	QString folder=url().path();
	QFileInfo info(folder);
	if (!info.isReadable()) {
		setPixmap(0,SmallIcon("folder_locked"));
		return;
	}

	QDir dir(folder);
	QStringList dirs=dir.entryList(QDir::Dirs,QDir::Unsorted);
	dirs.remove(".");
	dirs.remove("..");
	if (dirs.count()>0) {
		setExpandable(true);
	}
}


void DirViewItem::paintCell(QPainter * painter, const QColorGroup& group, int column, int width, int align) {
	QListViewItem::paintCell(painter,group,column,width,align);
	if (mIsDropTarget) {
		painter->drawWinFocusRect(0,0,width,height());
	}
}


void DirViewItem::setIsDropTarget(bool value) {
	mIsDropTarget=value;
}



//-RootDirViewItem--------------------------------------------------
const KURL& RootDirViewItem::url() const {
	static KURL root("/");
	return root;
}



//-SubDirViewItem---------------------------------------------------
void SubDirViewItem::refreshLabel() {
	setText(0,url().filename());
}
