/*
Gwenview - A simple image viewer for KDE
Copyright (C) 2000-2002 Aurlien Gteau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// Qt includes
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qspinbox.h>

// KDE includes
#include <kdirsize.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kio/global.h>
#include <kmessagebox.h>
#include <kurlrequester.h>

// Our includes
#include "fileoperation.h"
#include "filethumbnailview.h"
#include "fileview.h"
#include "fullscreenview.h"
#include "mainwindow.h"
#include "pixmapview.h"
#include "scrollpixmapview.h"
#include "thumbnailloadjob.h"

#include "configdialog.moc"


ConfigDialog::ConfigDialog(QWidget* parent,MainWindow* mainWindow)
: ConfigDialogBase(parent,0L,true),
mMainWindow(mainWindow)
{
	FileView* fileView=mMainWindow->fileView();

	mThumbnailMargin->setValue(fileView->fileThumbnailView()->marginSize());
	mWordWrapFilename->setChecked(fileView->fileThumbnailView()->wordWrapIconText());

	mConfirmBeforeDelete->setChecked(FileOperation::confirmDelete());
	mShowCopyDialog->setChecked(FileOperation::confirmCopy());
	mShowMoveDialog->setChecked(FileOperation::confirmMove());

	mDefaultDestDir->setURL(FileOperation::destDir());
	mDefaultDestDir->fileDialog()->setMode(
		static_cast<KFile::Mode>(KFile::Directory | KFile::ExistingOnly | KFile::LocalOnly));

	mZoomStep->setValue(int(mMainWindow->pixmapView()->scrollPixmapView()->zoomStep()*100));
	
	mExternalEditor->setText(FileOperation::editor());

	connect(mCalculateCacheSize,SIGNAL(clicked()),
		this,SLOT(calculateCacheSize()));
	connect(mEmptyCache,SIGNAL(clicked()),
		this,SLOT(emptyCache()));

	mShowPathInFullScreen->setChecked(mMainWindow->pixmapView()->fullScreenView()->showPath());
}


void ConfigDialog::slotOk() {
	slotApply();
	accept();
}


void ConfigDialog::slotApply() {
	FileView* fileView=mMainWindow->fileView();

	fileView->fileThumbnailView()->setMarginSize(mThumbnailMargin->value());
	fileView->fileThumbnailView()->setWordWrapIconText(mWordWrapFilename->isChecked());
	fileView->fileThumbnailView()->arrangeItemsInGrid();

	FileOperation::setConfirmDelete(mConfirmBeforeDelete->isChecked());
	FileOperation::setConfirmCopy(mShowCopyDialog->isChecked());
	FileOperation::setConfirmMove(mShowMoveDialog->isChecked());
	FileOperation::setDestDir(mDefaultDestDir->url());

	FileOperation::setEditor(mExternalEditor->text());

	mMainWindow->pixmapView()->scrollPixmapView()->setZoomStep(mZoomStep->value()/100.0);

	mMainWindow->pixmapView()->fullScreenView()->setShowPath(mShowPathInFullScreen->isChecked());
}


void ConfigDialog::calculateCacheSize() {
	KURL url;
	url.setPath(ThumbnailLoadJob::thumbnailDir());
	unsigned long size=KDirSize::dirSize(url);
	KMessageBox::information( this,i18n("Cache size is %1").arg(KIO::convertSize(size)) );
}


void ConfigDialog::emptyCache() {
	QString dir=ThumbnailLoadJob::thumbnailDir();
	int response=KMessageBox::questionYesNo(this,i18n("Are you sure you want to empty the thumbnail cache ?"
		" This will remove the folder <b>%1</b>.").arg(dir));

	if (response==KMessageBox::No) return;

	KURL url;
	url.setPath(dir);
	KIO::DeleteJob* job=KIO::del(url);
	connect(job,SIGNAL(result(KIO::Job*)),
		this,SLOT(onCacheEmptied(KIO::Job*)));
}


void ConfigDialog::onCacheEmptied(KIO::Job* job) {
	if ( job->error() ) {
		job->showErrorDialog(this);
		return;
	}
	KMessageBox::information( this,i18n("Cache emptied") );
}
