/*
Gwenview - A simple image viewer for KDE
Copyright (C) 2000-2002 Aurlien Gteau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef BROWSABLEFILEVIEW_H
#define BROWSABLEFILEVIEW_H

// Qt includes
#include <qstring.h>

/**
 * This class provides some virtual methods to
 * handle file view browsing
 */
class BrowsableFileView {
public:
	virtual void selectFirst()=0;
	virtual void selectLast()=0;
	virtual void selectPrevious()=0;
	virtual void selectNext()=0;

	virtual QString previousItemText() const =0;
	virtual QString currentItemText() const =0;
	virtual QString nextItemText() const =0;
	virtual bool currentIsFirst() const =0;
	virtual bool currentIsLast() const =0;
};


#endif
