#include "gvid.h"

int switch_X11_Res(Display *display, int screen, XF86VidModeModeInfo **vm_modelines, int mode)
{
	XF86VidModeSwitchToMode(display, screen, vm_modelines[mode]);
	XFlush(display);
	return 1;
}

void MenuEvent (GtkWidget *widget, gpointer mode_ptr)
{
	XF86VidModeModeInfo **vm_modelines;
	int mode_int, vm_count, screen_count,i,j;

#ifdef HAVE_LIBXINERAMA
	int screen_exists[1024];
	XineramaScreenInfo *screen;
#endif

	memcpy(&mode_int, mode_ptr, sizeof(mode_int));

#ifdef HAVE_LIBXINERAMA
	if (XineramaIsActive(display))
	{
		screen = XineramaQueryScreens(display, screen_exists);
		for (i=0; i==screen[i].screen_number; i++){}
		screen_count=i;
		XFree(screen);
	}
	else
	{
#endif
		screen_count=XScreenCount(display);
#ifdef HAVE_LIBXINERAMA
	}
#endif

	for (i=0; i<screen_count; i++)
	{
		XF86VidModeGetAllModeLines(display, i, &vm_count, &vm_modelines);
		for (j=0; j<vm_count; j++)
		{
			if (mode_int--==0) switch_X11_Res(display, i,vm_modelines,j);
		}
	}
}

static void about(AppletWidget *widget,gpointer data)
{
	GtkWidget *about;
	static const gchar *author[2]={"Keith Vanderline <kvand@mit.edu>", NULL};

	if(about_open==TRUE) return;
	about=gnome_about_new("GVidChanger",VERSION,"(C) 1999-2001 under the terms of the GPL",author,"Quick and easy GTK resolution switcher", NULL);

	gtk_signal_connect(GTK_OBJECT(about),"unmap",GTK_SIGNAL_FUNC (destroy_about),NULL);
	gtk_widget_show(about);
	about_open=TRUE;

	return;
}

static void destroy_about(GtkWidget *widget, gpointer data)
{
	about_open=FALSE;
	return;
}

static void create_popup(void)
{
	int i, j, vm_count, screen_count, *mode_ptr, mode_number, dotclock;
	char label_str[10];
	GtkWidget *menuitem_ptr, *submenu_ptr, *menu_ptr;
	XF86VidModeModeInfo **vm_modelines;
	XF86VidModeModeLine modeline;
#ifdef HAVE_LIBXINERAMA
	int screen_exists[1024];
	XineramaScreenInfo *screen;
#endif

	mode_number=0;

#ifdef HAVE_LIBXINERAMA
	if (XineramaIsActive(display))
	{
		screen = XineramaQueryScreens(display, screen_exists);
		for (i=0; i==screen[i].screen_number; i++){}
		screen_count=i;
		XFree(screen);
	}
	else
	{
#endif
		screen_count=XScreenCount(display);
#ifdef HAVE_LIBXINERAMA
	}
#endif

	menu_ptr = gtk_menu_new();
	if (screen_count==1)
	{
		XF86VidModeGetAllModeLines(display, 0, &vm_count, &vm_modelines);
		XF86VidModeGetModeLine(display, 0, &dotclock, &modeline);
		for (j=0; j<vm_count; j++)
		{
			if ((modeline.hdisplay==vm_modelines[j]->hdisplay)&&(modeline.vdisplay==vm_modelines[j]->vdisplay))
				sprintf(label_str, "* %ix%i", vm_modelines[j]->hdisplay, vm_modelines[j]->vdisplay);
			else
				sprintf(label_str, "  %ix%i", vm_modelines[j]->hdisplay, vm_modelines[j]->vdisplay);

			mode_ptr = malloc(sizeof(mode_ptr));
			*mode_ptr = mode_number++;

			menuitem_ptr = gtk_menu_item_new_with_label(label_str);
			gtk_signal_connect(GTK_OBJECT (menuitem_ptr), "activate", GTK_SIGNAL_FUNC (MenuEvent), (gpointer)mode_ptr);
			gtk_menu_append(GTK_MENU (menu_ptr), menuitem_ptr);
			gtk_widget_show(menuitem_ptr);
		}
	}
	else
	{
		for (i=0; i<screen_count; i++)
		{
			submenu_ptr = gtk_menu_new();
			sprintf(label_str, "Screen %i",i);
			menuitem_ptr = gtk_menu_item_new_with_label(label_str);
			gtk_menu_item_set_submenu(GTK_MENU_ITEM (menuitem_ptr), submenu_ptr);
			gtk_menu_append(GTK_MENU (menu_ptr), menuitem_ptr);
			gtk_widget_show(menuitem_ptr);
			gtk_widget_show(submenu_ptr);

			XF86VidModeGetAllModeLines(display, i, &vm_count, &vm_modelines);
			XF86VidModeGetModeLine(display, i, &dotclock, &modeline);
			for (j=0; j<vm_count; j++)
			{
				if ((modeline.hdisplay==vm_modelines[j]->hdisplay)&&(modeline.vdisplay==vm_modelines[j]->vdisplay))
					sprintf(label_str, "* %ix%i", vm_modelines[j]->hdisplay, vm_modelines[j]->vdisplay);
				else
					sprintf(label_str, "  %ix%i", vm_modelines[j]->hdisplay, vm_modelines[j]->vdisplay);

				mode_ptr = malloc(sizeof(mode_ptr));
				*mode_ptr = mode_number++;

				menuitem_ptr = gtk_menu_item_new_with_label(label_str);
				gtk_signal_connect(GTK_OBJECT (menuitem_ptr), "activate", GTK_SIGNAL_FUNC (MenuEvent), (gpointer)mode_ptr);
				gtk_menu_append(GTK_MENU (submenu_ptr), menuitem_ptr);
				gtk_widget_show(menuitem_ptr);
			}
		}
	}

	gtk_menu_popup(GTK_MENU(menu_ptr), NULL, NULL, NULL, NULL, 0, 0);
}

static void create_applet(void)
{
	GtkWidget *button, *button_pixmap, *frame, *box;

	frame=gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(frame),GTK_SHADOW_IN);

	box=gtk_hbox_new(FALSE,2);

	button=gtk_button_new();
	gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(create_popup),NULL);
	
	GTK_WIDGET_UNSET_FLAGS(button, GTK_CAN_DEFAULT);
	GTK_WIDGET_UNSET_FLAGS(button, GTK_CAN_FOCUS);

	gtk_widget_set_usize(GTK_WIDGET(button),20 , 20);
     
	button_pixmap=gnome_pixmap_new_from_xpm_d(monitor_xpm);
	gtk_container_add(GTK_CONTAINER(button),button_pixmap);

	gtk_box_pack_start(GTK_BOX(box),button,FALSE,TRUE,0);

	gtk_container_add(GTK_CONTAINER(frame),box);
	applet_widget_add(APPLET_WIDGET(applet),frame);

	gtk_widget_show(frame);  
	gtk_widget_show(button_pixmap);
	gtk_widget_show(button);
	gtk_widget_show(box);

	applet_widget_register_stock_callback(APPLET_WIDGET(applet), "about", GNOME_STOCK_MENU_ABOUT, _("About..."), (AppletCallbackFunc)about, NULL);
	applet_widget_set_tooltip(APPLET_WIDGET(applet),"Change Video Mode");
}

gint main(int argc,char **argv)
{
	if ((display=XOpenDisplay(""))==NULL) exit(1);

	applet_widget_init("gvid",VERSION, argc, argv, NULL, 0, NULL);
	applet=applet_widget_new("gvid");

	if(!applet) g_error("Error while creating applet");
	gtk_widget_realize(applet);

	create_applet();

	gtk_widget_show(applet);
	applet_widget_gtk_main();

	return 0;
}
