//
// C++ Interface: gutendb
//
// Description:
//
//
// Author: Lorn Potter <lorn.potter@gmail.com>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//

#ifndef GUTENDB_H
#define GUTENDB_H

#include <QtGui>
#include <QtSql>
#include <QSqlDatabase>
#include <QAction>
#include <QToolBar>


class gutenIndex;

/**
    @author Lorn Potter <lorn.potter@gmail.com>
*/
class gutenDb : public QObject {
        Q_OBJECT
public:
    gutenDb();

    ~gutenDb();
    bool installEtext(const QString & idString);
    QList<QStringList> returnServers();
    bool databaseTablesExist();
    bool setEtextPath(const QString &id, const QString &path);
    QString getEtextPath(const QString &id);
    bool databaseNeedsUpdate;
    
public slots:
    void updateLibraryDatabase();
    bool connectDatabase();
    void openDatabase();
    bool insertServers(QList<QStringList> );
    bool removeBook(const QString &);
        
    QList<QStringList> lookup(const QString&, const QString&);
    QList<QStringList> find(const QString&, const QString&);
    
    QList<QStringList> returnAllEtext();
    QList<QStringList> returnInstalled();

protected:
   QSqlDatabase db;
   gutenIndex *index;
   bool useSql;
   QString dbpath;

protected slots:
    bool insertIndex();

private:

    void createTables();
    void closeDatabase();
    void insert(QStringList &);
    void downloadNewIndex();
};

#endif
