/* callbacks.c - Callbacks from the GLADE interface

   Copyright (C) 2000  Henning Kulander <hennikul@ifi.uio.no>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "ups_canvas.h"
#include "dial.h"
#include "ups_dials.h"
#include "preferences.h"

/* Global events: */

gboolean
on_delete_event (GtkWidget       *widget,
		 GdkEvent        *event,
		 gpointer         user_data)
{
	gtk_main_quit ();
	return FALSE;
}


/* Menu selections: */

void
on_exit1_activate (GtkMenuItem     *menuitem,
		   gpointer         user_data)
{
	gtk_main_quit ();
}


void
on_preferences1_activate (GtkMenuItem     *menuitem,
			  gpointer         user_data)
{
	preferences_box_make (GTK_WIDGET (menuitem));
}


/* Show the about box */
void
on_about1_activate (GtkMenuItem     *menuitem,
		    gpointer         user_data)
{
	GtkWidget *about;
	
	about = create_about ();
	gtk_widget_show (about);
}


/* Button presses: */

void
on_button_quit_clicked (GtkButton       *button,
			gpointer         user_data)
{
	gtk_main_quit ();
}

/* Show preferences box */
void
on_button_preferences_clicked (GtkButton       *button,
			       gpointer         user_data)
{
	preferences_box_make (GTK_WIDGET (button));
}


/* Show about box */
void
on_button_about_clicked (GtkButton       *button,
			 gpointer         user_data)
{
	GtkWidget *about;
	
	about = create_about ();
	gtk_widget_show (about);
}

/* Property box: */

/* Get the infotype selected in the given menu */
gchar *propertybox_get_selection( GnomePropertyBox *gnomepropertybox, 
				  gchar *itemmenu, gint itemmenu_i )
{
	GtkWidget *menuitem;
	InfoDial *info_dial;
	gint i;
	
	/* Get active menuitem */
	menuitem = gtk_menu_get_active
		(GTK_MENU (gtk_option_menu_get_menu
			   (GTK_OPTION_MENU 
			    (lookup_widget (GTK_WIDGET (gnomepropertybox), 
					     itemmenu)))));
	info_dial = info_dial_get (itemmenu_i);
	
	/* find infotype for the menuitem found earlier */
	for (i = 0; i < info_dial->n_items; i++)
		if (menuitem == info_dial->menu_items[i])
			return info_types_get_name (i);

	return "NONE";
}


void
on_propertybox_apply (GnomePropertyBox *gnomepropertybox,
		      gint             arg1,
		      gpointer         user_data)
{
	gchar *hostname;
	gchar *fontname_dials;
	gboolean udp;
	gint delay;
	guint timeout;
	gchar *type1, *type2, *type3, *type4;
	
	if (arg1 != -1)
		return; /* Does not support global apply */

	/* Get new info from window */
	hostname = gtk_entry_get_text
		(GTK_ENTRY (lookup_widget (GTK_WIDGET (gnomepropertybox),
					   "combo_entry_hostname")));
	udp = gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON (lookup_widget 
				    (GTK_WIDGET (gnomepropertybox),
				     "radio_udp")));
	delay = gtk_spin_button_get_value_as_int
		(GTK_SPIN_BUTTON (lookup_widget (GTK_WIDGET (gnomepropertybox),
						 "spinbutton_delay")));
	fontname_dials = gnome_font_picker_get_font_name
		(GNOME_FONT_PICKER (lookup_widget 
				    (GTK_WIDGET (gnomepropertybox),
				     "fontpicker_dials")));
  
	/* Get infotypes selected in the optionmenus */
	type1 = propertybox_get_selection (gnomepropertybox, "itemmenu1", 0);
	type2 = propertybox_get_selection (gnomepropertybox, "itemmenu2", 1);
	type3 = propertybox_get_selection (gnomepropertybox, "itemmenu3", 2);
	type4 = propertybox_get_selection (gnomepropertybox, "itemmenu4", 3);

	/* Update configuration database with new info */
	
	preferences_set_string_variable ("/gupsc/%s/hostname", hostname);
	preferences_set_bool_variable ("/gupsc/%s/udp", udp);
	preferences_set_int_variable ("/gupsc/%s/delay", delay );
	preferences_set_string_variable ("/gupsc/%s/dial1", type1);
	preferences_set_string_variable ("/gupsc/%s/dial2", type2);
	preferences_set_string_variable ("/gupsc/%s/dial3", type3);
	preferences_set_string_variable ("/gupsc/%s/dial4", type4);
	preferences_set_string_variable ("/gupsc/%s/dialfont", 
					 fontname_dials);
	gnome_config_sync ();

	/* Load new preferences into application */
	preferences_load (global_window_get ());
	
	/* Update menus for new host */
	preferences_box_showmenus (GTK_WIDGET (gnomepropertybox));
	
	/* Restart the timeout signal */
	g_source_remove (global_timeout_get ());
	timeout = g_timeout_add_full (G_PRIORITY_HIGH_IDLE, 
				      preferences_delay_get (), 
				      global_updatetimeout_func,
				      NULL,
				      NULL);
	global_timeout_set (timeout);
}

void
on_combo_entry_hostname_changed (GtkEditable     *editable,
				 gpointer         user_data)
{
	gnome_property_box_changed
		(GNOME_PROPERTY_BOX (lookup_widget (GTK_WIDGET (editable),
						    "propertybox")));
}

void
on_radio_udp_toggled (GtkToggleButton *togglebutton,
		      gpointer         user_data)
{
	gnome_property_box_changed
		(GNOME_PROPERTY_BOX (lookup_widget (GTK_WIDGET (togglebutton),
						    "propertybox")));
}


void
on_spinbutton_delay_changed (GtkEditable     *editable,
			     gpointer         user_data)
{
	gnome_property_box_changed
		(GNOME_PROPERTY_BOX (lookup_widget (GTK_WIDGET (editable),
						    "propertybox")));
}


void
on_itemmenu1_add (GtkContainer    *container,
		  GtkWidget       *widget,
		  gpointer         user_data)
{
	gnome_property_box_changed
		(GNOME_PROPERTY_BOX (lookup_widget (GTK_WIDGET (widget),
						    "propertybox")));
}


void
on_itemmenu2_add (GtkContainer    *container,
		  GtkWidget       *widget,
		  gpointer         user_data)
{
	gnome_property_box_changed
		(GNOME_PROPERTY_BOX (lookup_widget (GTK_WIDGET (widget),
						    "propertybox")));
}


void
on_itemmenu3_add (GtkContainer    *container,
		  GtkWidget       *widget,
		  gpointer         user_data)
{
	gnome_property_box_changed
		(GNOME_PROPERTY_BOX (lookup_widget (GTK_WIDGET (widget),
						    "propertybox")));
}


void
on_itemmenu4_add (GtkContainer    *container,
		  GtkWidget       *widget,
		  gpointer         user_data)
{
	gnome_property_box_changed
		(GNOME_PROPERTY_BOX (lookup_widget (GTK_WIDGET (widget),
						    "propertybox")));
}


void
on_fontpicker_dials_font_set (GnomeFontPicker *gnomefontpicker,
			      gpointer        arg1,
			      gpointer         user_data)
{
	gnome_property_box_changed
		(GNOME_PROPERTY_BOX (lookup_widget 
				     (GTK_WIDGET (gnomefontpicker),
				      "propertybox")));
}

