//$Id: widget-combo.h,v 1.3 2001/10/30 17:34:48 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_WIDGETS_WIDGET_COMBO_H
#define GUIKACHU_WIDGETS_WIDGET_COMBO_H

namespace Guikachu
{
    namespace GUI
    {
	class WidgetCombo;
    }
}

#include <gtk--/box.h>
#include <gtk--/combo.h>
#include <gtk--/button.h>
#include "form-editor/widget.h"
#include "form-editor/widget-ref.h"

namespace Guikachu
{
    namespace GUI
    {
	class WidgetCombo: public Gtk::HBox
	{
	    Resources::Form *form;
	    Gtk::Combo combo;
	    Gtk::Button button_edit;
	    
	    Widgets::Type type;

	    Properties::WidgetRef &property;
	public:
	    WidgetCombo (Resources::Form       *form,
			 Widgets::Type          type,
			 Properties::WidgetRef &property);
	private:
	    bool update_block;
	    void update ();
	    
	    void add_widget (Widgets::Widget *widget);
	    void remove_widget (Widgets::Widget *widget);
	    void widget_changed_cb (Widgets::Widget *widget);
	    void edit_cb ();
	    void entry_cb ();
	};
    }
}

#endif /* !GUIKACHU_WIDGET_COMBO_H */
