//$Id: storage-node.h,v 1.5 2001/11/06 12:54:53 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_STORAGE_NODE_H
#define GUIKACHU_STORAGE_NODE_H

#include <string>
#include <gnome-xml/tree.h>
#include "property.h"

namespace Guikachu
{
    class StorageNode
    {
	xmlNodePtr node_ptr;
    public:
	StorageNode ();
	StorageNode (xmlNodePtr root);

	inline std::string name   () const { return (char*)(node_ptr->name); };
	inline xmlNodePtr  c_node () const { return node_ptr; };
	
	/* Tree management */
	StorageNode add_node (const std::string &name,
			      const std::string &content = "");

	inline StorageNode children () const { return node_ptr->xmlChildrenNode; };
	inline StorageNode next ()     const { return node_ptr->next; };
	inline StorageNode &operator++ (int) { node_ptr = node_ptr->next; return *this; };
	
	inline operator bool () { return node_ptr != 0; }
	
	/* Content management */
	void        set_content (const std::string& content);
	std::string get_content () const;

	/* Property manipulation */
	template<class T> void set_prop (const std::string &prop_name,
					 const Property<T> &value);
	void set_prop (const std::string &prop_name, const std::string &value);
	void set_prop (const std::string &prop_name, int value);
	void set_prop (const std::string &prop_name, unsigned int value);
	void set_prop (const std::string &prop_name, char value);

	template<class T> T get_prop (const std::string &prop_name) const;
    };

    template<class T>
    void StorageNode::set_prop (const std::string &prop_name,
				const Property<T> &value)
    {
	set_prop (prop_name, value ());
    }
};


#endif /* !GUIKACHU_STORAGE_NODE_H */
