/*
 * Guifications - The end all, be all, toaster popup plugin
 * Copyright (C) 2003-2005 Gary Kramlich
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef GF_THEME_INFO_H
#define GF_THEME_INFO_H

#define GF_THEME_INFO(obj)	((GfThemeInfo *)(obj))

typedef struct _GfThemeInfo GfThemeInfo;

#include <glib.h>

#include "xmlnode.h"

G_BEGIN_DECLS

GfThemeInfo *gf_theme_info_new();
GfThemeInfo *gf_theme_info_new_from_xmlnode(xmlnode *node);
xmlnode *gf_theme_info_to_xmlnode(GfThemeInfo *info);
void gf_theme_info_destroy(GfThemeInfo *info);

gchar *gf_theme_info_strip_name(GfThemeInfo *info);

void gf_theme_info_set_name(GfThemeInfo *info, const gchar *name);
const gchar *gf_theme_info_get_name(GfThemeInfo *info);
void gf_theme_info_set_version(GfThemeInfo *info, const gchar *version);
const gchar *gf_theme_info_get_version(GfThemeInfo *info);
void gf_theme_info_set_summary(GfThemeInfo *info, const gchar *summary);
const gchar *gf_theme_info_get_summary(GfThemeInfo *info);
void gf_theme_info_set_description(GfThemeInfo *info, const gchar *description);
const gchar *gf_theme_info_get_description(GfThemeInfo *info);
void gf_theme_info_set_author(GfThemeInfo *info, const gchar *author);
const gchar *gf_theme_info_get_author(GfThemeInfo *info);
void gf_theme_info_set_website(GfThemeInfo *info, const gchar *author);
const gchar *gf_theme_info_get_website(GfThemeInfo *info);

G_END_DECLS

#endif
