/*
 * Guifications - The end all, be all, toaster popup plugin
 * Copyright (C) 2003-2005 Gary Kramlich
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <gtk/gtk.h>

#include <debug.h>


#ifdef HAVE_CONFIG_H
# include "../gf_config.h"
#endif

#include "gf_internal.h"
#include "gf_stock.h"

static GtkIconFactory *icon_factory;

static inline gchar *
gf_stock_file_name(const gchar *file_name) {
	return g_build_filename(DATADIR, "pixmaps", "pidgin", "guifications",
							"conf", file_name, NULL);
}

static void
gf_add_to_stock(const gchar *file_name, const gchar *stock_name) {
	GtkIconSet *icon_set;
	GdkPixbuf *pixbuf;
	gchar *file;

	file = gf_stock_file_name(file_name);
	pixbuf = gdk_pixbuf_new_from_file(file, NULL);
	g_free(file);

	if(!pixbuf) {
		purple_debug_info("Guifications", "failed to load stock item '%s'\n",
						stock_name);
		return;
	}

	icon_set = gtk_icon_set_new_from_pixbuf(pixbuf);
	g_object_unref(G_OBJECT(pixbuf));

	gtk_icon_factory_add(icon_factory, stock_name, icon_set);
	gtk_icon_set_unref(icon_set);
}

void
gf_stock_init() {
	icon_factory = gtk_icon_factory_new();
	gtk_icon_factory_add_default(icon_factory);

	gf_add_to_stock("window_position_north_east.png", GF_STOCK_WINDOW_POSITION_NORTH_EAST);
	gf_add_to_stock("window_position_north_west.png", GF_STOCK_WINDOW_POSITION_NORTH_WEST);
	gf_add_to_stock("window_position_south_east.png", GF_STOCK_WINDOW_POSITION_SOUTH_EAST);
	gf_add_to_stock("window_position_south_west.png", GF_STOCK_WINDOW_POSITION_SOUTH_WEST);
	gf_add_to_stock("item_icon_size_big.png", GF_STOCK_ITEM_ICON_SIZE_BIG);
	gf_add_to_stock("item_icon_size_huge.png", GF_STOCK_ITEM_ICON_SIZE_HUGE);
	gf_add_to_stock("item_icon_size_large.png", GF_STOCK_ITEM_ICON_SIZE_LARGE);
	gf_add_to_stock("item_icon_size_little.png", GF_STOCK_ITEM_ICON_SIZE_LITTLE);
	gf_add_to_stock("item_icon_size_normal.png", GF_STOCK_ITEM_ICON_SIZE_NORMAL);
	gf_add_to_stock("item_icon_size_small.png", GF_STOCK_ITEM_ICON_SIZE_SMALL);
	gf_add_to_stock("item_icon_size_tiny.png", GF_STOCK_ITEM_ICON_SIZE_TINY);
	gf_add_to_stock("item_position_center.png", GF_STOCK_ITEM_POSITION_CENTER);
	gf_add_to_stock("item_position_east.png", GF_STOCK_ITEM_POSITION_EAST);
	gf_add_to_stock("item_position_north_east.png", GF_STOCK_ITEM_POSITION_NORTH_EAST);
	gf_add_to_stock("item_position_north.png", GF_STOCK_ITEM_POSITION_NORTH);
	gf_add_to_stock("item_position_north_west.png", GF_STOCK_ITEM_POSITION_NORTH_WEST);
	gf_add_to_stock("item_position_south_east.png", GF_STOCK_ITEM_POSITION_SOUTH_EAST);
	gf_add_to_stock("item_position_south.png", GF_STOCK_ITEM_POSITION_SOUTH);
	gf_add_to_stock("item_position_south_west.png", GF_STOCK_ITEM_POSITION_SOUTH_WEST);
	gf_add_to_stock("item_position_west.png", GF_STOCK_ITEM_POSITION_WEST);
	gf_add_to_stock("item_text_clipping_ellipsis_end.png", GF_STOCK_ITEM_TEXT_CLIPPING_ELLIPSIS_END);
	gf_add_to_stock("item_text_clipping_ellipsis_middle.png", GF_STOCK_ITEM_TEXT_CLIPPING_ELLIPSIS_MIDDLE);
	gf_add_to_stock("item_text_clipping_ellipsis_start.png", GF_STOCK_ITEM_TEXT_CLIPPING_ELLIPSIS_START);
	gf_add_to_stock("item_text_clipping_truncate.png", GF_STOCK_ITEM_TEXT_CLIPPING_TRUNCATE);
}

void
gf_stock_uninit() {
	gtk_icon_factory_remove_default(icon_factory);
}
