#ifndef SCANNER_H
#define SCANNER_H

/*
 * Generic interface for testers
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <string>
#include "Scans.h"

class ScannerListener
{
public:
	virtual ~ScannerListener() {}
	virtual void notifyScan(const Scan* scan) throw () = 0;
};

/*
 * A particular class of scanner handles all scans of the like-named type.
 * It notifies listeners when a scan succeeds.
 */
class Scanner
{
protected:
	ScannerListener* listener;

	void succeeded(const Scan* scan) throw ()
	{
		listener->notifyScan(scan);
	}
	
public:
	Scanner(ScannerListener* listener) : listener(listener) {}
	
};

// vim:set ts=4 sw=4:
#endif
