/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class ConstrainedMultimapAsMapImplementsMapTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testClear() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testClear();
}

public void testContainsKey() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testContainsKey();
}

public void testContainsValue() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testContainsValue();
}

public void testEntrySet() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testEqualsForSmallerMap();
}

public void testGet() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testGet();
}

public void testGetForEmptyMap() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testGetForEmptyMap();
}

public void testGetNull() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testGetNull();
}

public void testHashCode() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testKeySetClear();
}

public void testKeySetRemove() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testPutExistingKey();
}

public void testPutNewKey() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testPutNewKey();
}

public void testPutNullKey() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testPutNullKey();
}

public void testPutNullValue() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testRemove();
}

public void testRemoveMissingKey() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testRemoveMissingKey();
}

public void testSize() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testSize();
}

public void testValues() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testValues();
}

public void testValuesClear() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty() throws Exception {
  com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ConstrainedMultimapAsMapImplementsMapTest();
  testCase.testValuesRetainAllNullFromEmpty();
}
}
