/* this file collects some functions managing those parts of a progress
 * dialog appearing whenever files are being copied,that are the same on
 * each such occasion like a throuput display,a display for the time
 * remaining,one for the time already passed */

#ifndef DATACOPYDLG_H
#define DATACOPYDLG_H

#include <gtk/gtk.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#define DATACOPYDLG_MAXTHREADS 10

/* flags controlling a progress section's appearance */
#define DATACOPYDLG_SHOWFRAME 1
#define DATACOPYDLG_SHOWLABEL 2
#define DATACOPYDLG_SHOWTHROUGHPUT 4
#define DATACOPYDLG_SHOWTIME_REMAINING 8
#define DATACOPYDLG_SHOWTIME_ELAPSED 16
#define DATACOPYDLG_SHOWPROGRESS 32
#define DATACOPYDLG_SHOWPROGRESSINTITLE 64 /* this can be set for one
					    * section only */

/* the definitions for a single  progress section of the progress window */
typedef struct
{
   GtkWidget *frame;
   GtkWidget *infofield;
   GtkWidget *progress;
   
   unsigned int options;   /* the control flags */
   char framename[255];    /* an optional frame name */   
   char label[255];        /* an optional label describing the nature of this thread */
   unsigned int totalsize; /* the total transfer size */
   
   unsigned int bytesdone;   
   int starttime;          /* start time of this specific "thread" */
} datacopydlg_threadinfo;
   
/* this is the structure passed to and obtained from all the functions
 * of datacopydlg.c */
typedef struct 
{
	GtkWidget *messagebox;
   	char title[255];
   
        int numthreads;
        datacopydlg_threadinfo *threads[DATACOPYDLG_MAXTHREADS];
   
	int bytessincelastmeasure;
	int lastmeasure;
	float currentthroughput;
} datacopydlg_dlginfo;
	
void datacopydlg_destroy(datacopydlg_dlginfo *dlg);
/* force display update */
void datacopydlg_updatedisplay(datacopydlg_dlginfo *dlg);
/* update the informations in datacopydlg_dlginfo and display changes 
 * this function should be called whenever a new block of data has been
 * processed */
void datacopydlg_newdatablock(datacopydlg_dlginfo *dlg,int size);
/* restart a specific thread */
void datacopydlg_restartthread(datacopydlg_dlginfo *dlg,
			       int threadnum,
			       int totalsize);
/* set thread parameters,
 * DO NOT CHANGE SHOWFRAME FLAG THIS WAY !
 * keep old setting for 
 *  options = 0
 *  framename = NULL
 *  label = NULL
 *  totalsize = -1 */
void datacopydlg_configurethread(datacopydlg_dlginfo *dlg,int threadnum,
				 unsigned int options,
				 char *framename,
				 char *label,
				 int  totalsize);

/* create a progress box with title for processing totalsize bytes of data,
 * stophandler gets called whenever the user terminates the process by
 * clicking the stop button. if NULL,stop button will not even be visible
 * data can be a pointer to some additional data passed to the signal handler
 * but can also be set to NULL if not needed 
 * the following parameters are processed by the va_arg macros
 * and represent the "threads" of this progress dialog */
datacopydlg_dlginfo *datacopydlg_create(char *title,
					GtkSignalFunc stophandler,
					gpointer data,
					int numthreads,
					... /* unsigned int options,
					     * char *framename,
					     * char *label,
					     * int totalsize
					     * for each "thread" */
					);

	
#endif // DATACOPYDLG_H
