/* The recording terminal */

#ifndef RTERM_H
#define RTERM_H

#include <gtk/gtk.h>

#include "main.h"

typedef struct 
{
	int tag;
	int filedes;
	GdkColor *color;
} rterm_pipeinfo;

extern GtkWidget *rterm_terminal; // the output Terminal

#define rterm_printc(Color,txt) gtk_text_insert(GTK_TEXT(rterm_terminal),NULL,&Color,NULL,txt,-1)
#define rterm_print(txt) gtk_text_insert(GTK_TEXT(rterm_terminal),NULL,NULL,NULL,txt,-1)
#define rterm_outc(Color,character) gtk_text_insert(GTK_TEXT(rterm_terminal),NULL,&Color,NULL,character,1)
#define rterm_out(character) gtk_text_insert(GTK_TEXT(rterm_terminal),NULL,NULL,NULL,character,1)
#define rterm_printcln(Color,txt) gtk_text_insert(GTK_TEXT(rterm_terminal),NULL,&Color,NULL,txt,-1); \
                                  gtk_text_insert(GTK_TEXT(rterm_terminal),NULL,NULL,NULL,CRLF,-1)
#define rterm_println(txt) gtk_text_insert(GTK_TEXT(rterm_terminal),NULL,NULL,NULL,txt,-1); \
                           gtk_text_insert(GTK_TEXT(rterm_terminal),NULL,NULL,NULL,CRLF,-1)

void             rterm_disconnectpipe(rterm_pipeinfo*);
rterm_pipeinfo  *rterm_connectpipe(GdkColor *c,int f); // connect a pipe to the Terminal
GtkWidget       *rterm_create();

#endif // RTERM_H
