
#include <stdlib.h>
#include <gtk/gtk.h>

#include "pseudorecurse.h"

typedef struct
{
   /* operation to perform */
   pseudorecurse_processitem_t operation;   
   void *data;
   
   /* a GList of the current pseudo stack.
    * The first entry of the list is always the current one */
   GList *currentstack;

} pseudorecurse_info_real;

/* returns the current stack frame */ 
void *pseudorecurse_getcurrentstackframe(pseudorecurse_info *i)
{
   pseudorecurse_info_real *info=(pseudorecurse_info_real*)i;
   if ((info)&&(info->currentstack))
     return info->currentstack->data;
   else
     return NULL;
};

/* adds stackframe as the topmost stackframe.  
 * That's like going one level up in the recursion */   
void pseudorecurse_pushstackframe(pseudorecurse_info *i,void *stackframe)
{
   pseudorecurse_info_real *info=(pseudorecurse_info_real*)i;
   if (info)
     info->currentstack=g_list_prepend(info->currentstack,stackframe);
};

/* remove the topmost stackframe.  
 * That's like going one level back, e.g. returning into the previous  
 * stackframe */    
void pseudorecurse_popstackframe(pseudorecurse_info *i)
{
   pseudorecurse_info_real *info=(pseudorecurse_info_real*)i;
   if ((info)&&(info->currentstack))
     info->currentstack=g_list_remove(info->currentstack,
				      info->currentstack->data);
};

void pseudorecurse_recurse_callback(pseudorecurse_info *info);

gint pseudorecurse_proxy_callback(gpointer data)
{
   pseudorecurse_recurse_callback((pseudorecurse_info*)data);
   return 0;
};

void pseudorecurse_recurse_callback(pseudorecurse_info *i)
{
   pseudorecurse_info_real *info=(pseudorecurse_info_real*)i;
   int result=info->operation(i,	
			      ((info->currentstack)
			       ?info->currentstack->data
			       :NULL),
			      info->data);
   switch (result)
     {
      case PR_CONTINUE:
	gtk_timeout_add(0,
			pseudorecurse_proxy_callback,
			i);
	break;
      case PR_END:
	free(info);
	break;
     };
};

void pseudorecurse_execute(pseudorecurse_processitem_t operation, 
			   void *data)
{
   pseudorecurse_info_real *info=(pseudorecurse_info_real*)malloc(sizeof(pseudorecurse_info_real));
   info->data=data;
   info->operation=operation;
   info->currentstack=NULL;
   pseudorecurse_recurse_callback((pseudorecurse_info*)info);
};

   
   
  
  
