
#ifndef PREFERENCES_H
#define PREFERENCES_H

#include <gtk/gtk.h>

#include "varman.h"

void preferences_init();
void preferences_save();
/* any handler passed to this function is called if either OK or Apply is
 * clicked by the user. This will generally be used by varmanwidgets to
 * update their variables */
void preferences_setapplyhandler(GtkSignalFunc,gpointer);
/* any handler passed to this function is called after values entered
 * in the preferences setup have become invalid because the user has  
 * clicked the cancel button */
void preferences_setundohandler(GtkSignalFunc,gpointer);
/* remove a apply or undo handler */
void preferences_removeapplyhandler_by_data(gpointer);
void preferences_removeundohandler_by_data(gpointer);
void preferences_removeapplyhandler_by_func(GtkSignalFunc);
void preferences_removeundohandler_by_func(GtkSignalFunc);

/* append a new page to the preferences Notebook.
 * Automatically creates viewport for the new page with scrollbars set
 * to auto */
void preferences_append_page(GtkWidget *newpage,GtkWidget *label);

extern GtkWidget *preferences_editmain; /* use this to show preferences */
extern GtkWidget *preferences_common; 

extern varman_database *global_defs;
extern varman_database *dynamic_defs;

/* becomes true whenever no configuration file could be found */
extern int preferences_freshinstall;
/* set this to false if you don't want your settings to be saved */
extern int preferences_saveonexit;

/* processor features, autodetected in preferences_init */
extern int preferences_bigendian;
extern int preferences_32bitalign;

/* a constant for now until one day I think better of it.
 * The reason this time: keep the world simple */
#define FSDSTDIR "gtoaster_cdfs"
#define FSEDIT_DESTPATH varman_getvar(dynamic_defs,"$symlinktree")
#define TEMPDIR varman_getvar(global_defs,"tempdir")

/* currently cannot be changed at runtime */
#define BUFSIZE 2048

/* the maximum length a directory path can be */
#define MAXPATHLENGTH 4096

/* maximum standard string size */
#define MAXSTRINGSIZE 4096

#define CDDASECTORSIZE 2352

#endif // PREFERENCES_H
