#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

#include "config.h"

#ifdef HAVE_GNOME
# include <gnome.h>
#else
# include <gtk/gtk.h>
#endif

#include "int.h"
#include "varman.h"
#include "varmanwidgets.h"
#include "preferences.h"
#include "configfile.h"
#include "layoutconfig.h"
#include "dirlow.h"
#include "dialog.h"

#include "defaultentries.h"

/* uncomment for debugging */
/* #define DEBUG */

GtkWidget *preferences_editmain;
GtkWidget *preferences_editpad;
GtkWidget *preferences_edit_ok,*preferences_edit_apply,
  *preferences_edit_cancel,*preferences_edit_undo;

GtkWidget *preferences_common;

varman_database *global_defs;
/* all those things that shouldnt be saved to the config file */
varman_database *dynamic_defs;

int preferences_freshinstall;
int preferences_saveonexit=1;

/* stores the system's Endianness.
 * The GNU autoconf manual suggests to use runtime Endianness detection
 * so that's what we're doing with Gnometoaster.
 * Endianness is being detected in preferences_init(), which is
 * called before almost anything else */
int preferences_bigendian;
/* stores the system's 32bit alignment. Non-Intel platforms often can't
 * access 32bit values not starting at a multiple of 32bit
 * so we have to test for this sort of thing before trying to
 * do so */
int preferences_32bitalign;

void preferences_edit_hide(GtkWidget *w,gpointer data)
{
   layoutconfig_widget_hide(preferences_editmain,"preferences");
}
;

void preferences_setapplyhandler(GtkSignalFunc handler,
				 gpointer data)
{
   gtk_signal_connect(GTK_OBJECT(preferences_edit_ok),"clicked",
		      handler,data);
   gtk_signal_connect(GTK_OBJECT(preferences_edit_apply),"clicked",
		      handler,data);
}
;

void preferences_setundohandler(GtkSignalFunc handler,
				gpointer data)
{
   gtk_signal_connect(GTK_OBJECT(preferences_edit_cancel),"clicked",
		      handler,data);
   gtk_signal_connect(GTK_OBJECT(preferences_edit_undo),"clicked",
		      handler,data);
}
;

void preferences_removeapplyhandler_by_data(gpointer data)
{
   gtk_signal_disconnect_by_data(GTK_OBJECT(preferences_edit_ok),data);
   gtk_signal_disconnect_by_data(GTK_OBJECT(preferences_edit_apply),data);
}
;

void preferences_removeundohandler_by_data(gpointer data)
{
   gtk_signal_disconnect_by_data(GTK_OBJECT(preferences_edit_cancel),data);
   gtk_signal_disconnect_by_data(GTK_OBJECT(preferences_edit_undo),data);
}
;

void preferences_removeapplyhandler_by_func(GtkSignalFunc func)
{
   gtk_signal_disconnect_by_func(GTK_OBJECT(preferences_edit_ok),func,NULL);
   gtk_signal_disconnect_by_func(GTK_OBJECT(preferences_edit_apply),func,NULL);
}
;

void preferences_removeundohandler_by_func(GtkSignalFunc func)
{
   gtk_signal_disconnect_by_func(GTK_OBJECT(preferences_edit_cancel),func,NULL);
   gtk_signal_disconnect_by_func(GTK_OBJECT(preferences_edit_undo),func,NULL);
}
;

gint preferences_delete_event(GtkWidget *widget,
			      GdkEvent *event,
			      gpointer data)
{
	/* One maybe should expand setundohandler/removeundohandler, call all undo funcs in here
	 * and hide the window -> delete_event == Cancel Button*/
   return TRUE; /* Yeah, i wanna keep the window */
};

/* checks system for Endianness */
int preferences_isbigendian()
{
   unsigned short int test=0xff40;
   return ((*((unsigned char*)&test))==0xff);
};

/* FIXME: Don't know if this test works properly on all platforms.
 * Some compilers might actually refuse to compile this for specific
 * platforms */
int preferences_need32bitalign()
{
   unsigned long long int test=0x0011223344556677;
   unsigned int temp;
   temp=*((unsigned int*)(((int)(&test))+1));
   temp&=0xff;
   /* test if result is either 0x11 (for big endian systems)
    * or 0x66 (for little Endian systems) and return TRUE if
    * it is not */
   return (!((temp==0x11)||(temp==0x66)));
};

void preferences_setupsymlinkarea()
{
   char *tempdir=varman_getvar_copy(global_defs,"isotrack_tempdir");
   char *linkarea=NULL;
   int result=-1;
   varman_replacestring(tempdir,
			"$tempdir",
			varman_getvar(global_defs,"tempdir"));
   varman_replacevars(dynamic_defs,tempdir);
   linkarea=helpings_fileinpath(tempdir,	
				FSDSTDIR);
   free(tempdir);
   // delete old symlinktree directory if possible (empty)
   if (varman_getvar(dynamic_defs,"$symlinktree"))
     remove(varman_getvar(dynamic_defs,"$symlinktree"));
   result=mkdir(linkarea,0777);
   if ((result==-1)&&(errno!=EEXIST))
     {
	const char *message=
	  _("Gnometoaster failed to create it's symbolic link area\n"
	    "which is essential for filesystem creation. Please make\n"
	    "sure that the user running Gnometoaster has permission\n"
	    "to create the following directory:\n%s\n");
	char *out=(char*)malloc(strlen(message)+strlen(linkarea)+1);
	sprintf(out,message,linkarea);
	dialog_error(out);
	free(out);
     };
   varman_setvar(dynamic_defs,"$symlinktree",
		 linkarea);
					
   free(linkarea);
};

void preferences_sachanged(VARMAN_VAR_ENTRY*var,gpointer data)
{
   preferences_setupsymlinkarea();
};

void preferences_init()
{
   GtkWidget *label;

   varmanwidgets_widget *td;

   preferences_bigendian=preferences_isbigendian();
   preferences_32bitalign=preferences_need32bitalign();

   global_defs=varman_vardatabase_create_new();
   dynamic_defs=varman_vardatabase_create_new();

	/* the most important environment variables */
   varman_setvar(dynamic_defs,"$HOME",getenv("HOME"));

   	/* everything before the introduction of configfile versioning
	 * is 0.
	 * Whenever an essential thing changes in Gnometoaster's configuration,
	 * we inform the user upgrading from an earlier version and
	 * reset the changed configuration entries to their new default
	 * values (if the user chooses to do so,otherwise he'll get some infor-
	 * mations about what has been changed in particular and then be
	 * left alone to do the necessary changes himself. */
   varman_setvar(global_defs,"configfile_version","0");

   varman_setvar(global_defs,"fsedit_volid",
		 DEFAULTENTRIES_FSEDIT_VOLID);
   varman_setvar(global_defs,"tempdir",
		 DEFAULTENTRIES_TEMPDIR);
   varman_setvar(global_defs,"cddbserver",
		 DEFAULTENTRIES_CDDBSERVER);
   varman_setvar(global_defs,"dnd_gnome",
		 DEFAULTENTRIES_DND_GNOME);
   varman_setvar(global_defs,"rec_client",
		 DEFAULTENTRIES_REC_CLIENT);
   varman_setvar(global_defs,"rec_singlecallcdrecord",
		 DEFAULTENTRIES_REC_SINGLECALLCDRECORD);
   varman_setvar(global_defs,"rec_cdrecordnpipe",
		 DEFAULTENTRIES_REC_CDRECORDNPIPE);
   varman_setvar(global_defs,"rec_daoclient",
		 DEFAULTENTRIES_REC_DAOCLIENT);
   varman_setvar(global_defs,"rec_usecdrdao",
		 DEFAULTENTRIES_REC_USECDRDAO);
   varman_setvar(global_defs,"rec_writecd",
		 DEFAULTENTRIES_REC_WRITECD);
   varman_setvar(global_defs,"rec_trackitem",
		 DEFAULTENTRIES_REC_TRACKITEM);
   varman_setvar(global_defs,"rec_daowrite",
		 DEFAULTENTRIES_REC_DAOWRITE);
   varman_setvar(global_defs,"rec_fixate",
		 DEFAULTENTRIES_REC_FIXATE);
   varman_setvar(global_defs,"rec_writetrack",
		 DEFAULTENTRIES_REC_WRITETRACK);
   varman_setvar(global_defs,"rec_cleardisc",
		 DEFAULTENTRIES_REC_CLEARDISC);
   varman_setvar(global_defs,"rec_blankingmode",
		 DEFAULTENTRIES_REC_BLANKINGMODE);
   varman_setvar(global_defs,"rec_ejectdisc",
		 DEFAULTENTRIES_REC_EJECTDISC);
   varman_setvar(global_defs,"rec_getmsinfo",
		 DEFAULTENTRIES_REC_GETMSINFO);
   varman_setvar(global_defs,"rec_doeject",
		 DEFAULTENTRIES_REC_DOEJECT);
   varman_setvar(global_defs,"rec_reloaddisc",
		 DEFAULTENTRIES_REC_RELOADDISC);
   varman_setvar(global_defs,"rec_reloaddisc_cmd",
		 DEFAULTENTRIES_REC_RELOADDISC_CMD);
   varman_setvar(global_defs,"rec_dummymode",
		 DEFAULTENTRIES_REC_DUMMYMODE);
   varman_setvar(global_defs,"rec_daodummymode",
		 DEFAULTENTRIES_REC_DAODUMMYMODE);
   varman_setvar(global_defs,"rec_dao",
		 DEFAULTENTRIES_REC_DAO);
   varman_setvar(global_defs,"rec_buprotect",
		 DEFAULTENTRIES_REC_BUPROTECT);
   varman_setvar(global_defs,"rec_writecdtext",
		 DEFAULTENTRIES_REC_WRITECDTEXT);
   varman_setvar(global_defs,"rec_dofixate",
		 DEFAULTENTRIES_REC_DOFIXATE);
   varman_setvar(global_defs,"rec_multisession",
		 DEFAULTENTRIES_REC_MULTISESSION);
   varman_setvar(global_defs,"rec_speed",
		 DEFAULTENTRIES_REC_SPEED);
   varman_setvar(global_defs,"rec_inqdrive",
		 DEFAULTENTRIES_REC_INQDRIVE);
   varman_setvar(global_defs,"rec_scanbus",
		 DEFAULTENTRIES_REC_SCANBUS);
   varman_setvar(global_defs,"rec_sbgetid",
		 DEFAULTENTRIES_REC_SBGETID);
   varman_setvar(global_defs,"rec_inqdrive_getvendor",
		 DEFAULTENTRIES_REC_INQDRIVE_GETVENDOR);
   varman_setvar(global_defs,"rec_inqdrive_getmodel",
		 DEFAULTENTRIES_REC_INQDRIVE_GETMODEL);
   varman_setvar(global_defs,"rec_inqdrive_gettype",
		 DEFAULTENTRIES_REC_INQDRIVE_GETTYPE);
   varman_setvar(global_defs,"rec_inqdrive_getdrivetype",
		 DEFAULTENTRIES_REC_INQDRIVE_GETDRIVETYPE);
   varman_setvar(global_defs,"rec_inqdrive_getmountpoint_file",
		 DEFAULTENTRIES_REC_INQDRIVE_GETMOUNTPOINT_FILE);
   varman_setvar(global_defs,"rec_inqdrive_getmountpoint_exp",
		 DEFAULTENTRIES_REC_INQDRIVE_GETMOUNTPOINT_EXP);
   varman_setvar(global_defs,"rec_autoscan",
		 DEFAULTENTRIES_REC_AUTOSCAN);
   varman_setvar(global_defs,"isotrack_client",
		 DEFAULTENTRIES_ISOTRACK_CLIENT);
   varman_setvar(global_defs,"isotrack_msoption",
		 DEFAULTENTRIES_ISOTRACK_MSOPTION);
   varman_setvar(global_defs,"isotrack_detwithcreate",
		 DEFAULTENTRIES_ISOTRACK_DETWITHCREATE);
   varman_setvar(global_defs,"isotrack_detwithoption",
		 DEFAULTENTRIES_ISOTRACK_DETWITHOPTION);
   varman_setvar(global_defs,"isotrack_tsclient",
		 DEFAULTENTRIES_ISOTRACK_TSCLIENT);
   varman_setvar(global_defs,"isotrack_tscalc",
		 DEFAULTENTRIES_ISOTRACK_TSCALC);
   varman_setvar(global_defs,"isotrack_mount",
		 DEFAULTENTRIES_ISOTRACK_MOUNT);
   varman_setvar(global_defs,"isotrack_umount",
		 DEFAULTENTRIES_ISOTRACK_UMOUNT);
   varman_setvar(global_defs,"isotrack_precache",
		 DEFAULTENTRIES_ISOTRACK_PRECACHE);
   varman_setvar(global_defs,"isotrack_bootimage",
		 DEFAULTENTRIES_ISOTRACK_BOOTIMAGE);
   varman_setvar(global_defs,"isotrack_tempdir",
		 DEFAULTENTRIES_ISOTRACK_TEMPDIR);
   varman_setvar(global_defs,"isotrack_makebootable",
		 DEFAULTENTRIES_ISOTRACK_MAKEBOOTABLE);
   varman_setvar(global_defs,"isotrack_eltorito",
		 DEFAULTENTRIES_ISOTRACK_ELTORITO);
   varman_setvar(global_defs,"audiotrack_client",
		 DEFAULTENTRIES_AUDIOTRACK_CLIENT);
   varman_setvar(global_defs,"audiotrack_read",
		 DEFAULTENTRIES_AUDIOTRACK_READ);
   varman_setvar(global_defs,"audiotrack_precache",
		 DEFAULTENTRIES_AUDIOTRACK_PRECACHE);
   varman_setvar(global_defs,"audiotrack_readcdtext",
		 DEFAULTENTRIES_AUDIOTRACK_READCDTEXT);
   varman_setvar(global_defs,"audiotrack_parsecdtext_title",
		 DEFAULTENTRIES_AUDIOTRACK_PARSECDTEXT_TITLE);
   varman_setvar(global_defs,"audiotrack_parsecdtext_performer",
		 DEFAULTENTRIES_AUDIOTRACK_PARSECDTEXT_PERFORMER);   
   varman_setvar(global_defs,"audiotrack_parsecdtext_cdtitle",
		 DEFAULTENTRIES_AUDIOTRACK_PARSECDTEXT_CDTITLE);
   varman_setvar(global_defs,"audiotrack_parsecdtext_cdperformer",
		 DEFAULTENTRIES_AUDIOTRACK_PARSECDTEXT_CDPERFORMER);   
   
   varman_setvar(global_defs,"datatrack_precache",
		 DEFAULTENTRIES_DATATRACK_PRECACHE);
   varman_setvar(global_defs,"statistics_leadoutsize",
		 DEFAULTENTRIES_STATISTICS_LEADOUTSIZE);
   varman_setvar(global_defs,"statistics_fastblank",
		 DEFAULTENTRIES_STATISTICS_FASTBLANK);
   varman_setvar(global_defs,"statistics_allblank",
		 DEFAULTENTRIES_STATISTICS_ALLBLANK);
   varman_setvar(global_defs,"fillstate_themed",
		 DEFAULTENTRIES_FILLSTATE_THEMED);
   varman_setvar(global_defs,"fillstate_colors",
		 DEFAULTENTRIES_FILLSTATE_COLORS);
   /* esd is the most amazing sound engine I ever saw. It works flawlessly and
    * its comfortable for both user and author - so we make this the default
    * if its available */

   varman_setvar(global_defs,"audio_default",DEFAULTENTRIES_AUDIO_DEFAULT_NOSOUND);
#ifdef HAVE_OSS
   varman_setvar(global_defs,"audio_default",DEFAULTENTRIES_AUDIO_DEFAULT_OSS);
#endif
#ifdef HAVE_ESD
   varman_setvar(global_defs,"audio_default",DEFAULTENTRIES_AUDIO_DEFAULT_ENLIGHTENMENT);
#endif

   /* load the GnomeToaster Configuration file,overwriting the defaults
    * defined above if present
    * set "fresh install" flag if no config file could be found */
   preferences_freshinstall=!varman_loaddatabase(global_defs,
						 varman_replacevars_copy(dynamic_defs,"$HOME/.gtoasterrc"),
						 "[global_defs]");

   /* got our temp path now, try to create fsedit destination area.
    * Install callback for all variables used creating the symlinkarea path */
   preferences_setupsymlinkarea();
   varman_install_handler(global_defs,
			  "tempdir",
			  preferences_sachanged,NULL);
   varman_install_handler(global_defs,
			  "isotrack_tempdir",
			  preferences_sachanged,NULL);
   

   /* register store call for settings */
   configfile_registersection("[global_defs]",
			      (configfile_store)varman_savedatabase_fd,
			      (gpointer)global_defs);

   preferences_editmain=gtk_dialog_new();
   gtk_widget_set_usize(preferences_editmain,640,480);
   gtk_window_set_title(GTK_WINDOW(preferences_editmain),_("GnomeToaster Preferences"));
   gtk_signal_connect(GTK_OBJECT(preferences_editmain),"delete_event",
		      GTK_SIGNAL_FUNC(preferences_delete_event),NULL);

   preferences_editpad=gtk_notebook_new();
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(preferences_editmain)->vbox),
		      preferences_editpad,TRUE,TRUE,1);
   gtk_widget_show(preferences_editpad);

#ifdef HAVE_GNOME
   preferences_edit_undo=gnome_stock_button(GNOME_STOCK_BUTTON_PREV);
#else
   preferences_edit_undo=gtk_button_new_with_label(_("Undo"));
#endif
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(preferences_editmain)->action_area),
		      preferences_edit_undo,FALSE,FALSE,0);
   gtk_widget_show(preferences_edit_undo);

#ifdef HAVE_GNOME
   preferences_edit_apply=gnome_stock_button(GNOME_STOCK_BUTTON_APPLY);
#else
   preferences_edit_apply=gtk_button_new_with_label(_("Apply"));
#endif
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(preferences_editmain)->action_area),
		      preferences_edit_apply,FALSE,FALSE,0);
   gtk_widget_show(preferences_edit_apply);

#ifdef HAVE_GNOME
   preferences_edit_ok=gnome_stock_button(GNOME_STOCK_BUTTON_OK);
#else
   preferences_edit_ok=gtk_button_new_with_label("OK");
#endif
   gtk_signal_connect(GTK_OBJECT(preferences_edit_ok),"clicked",
		      preferences_edit_hide,NULL);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(preferences_editmain)->action_area),
		      preferences_edit_ok,FALSE,FALSE,0);
   gtk_widget_show(preferences_edit_ok);

#ifdef HAVE_GNOME
   preferences_edit_cancel=gnome_stock_button(GNOME_STOCK_BUTTON_CANCEL);
#else
   preferences_edit_cancel=gtk_button_new_with_label(_("Cancel"));
#endif
   gtk_signal_connect(GTK_OBJECT(preferences_edit_cancel),"clicked",
		      preferences_edit_hide,NULL);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(preferences_editmain)->action_area),
		      preferences_edit_cancel,FALSE,FALSE,0);
   gtk_widget_show(preferences_edit_cancel);

   preferences_common=gtk_vbox_new(0,0);
   gtk_widget_show(preferences_common);
   label=gtk_label_new(_("Common"));
   gtk_widget_show(label);

   preferences_append_page(preferences_common,label);

   td=varmanwidgets_entry_new(_("Temp Files"),
			      "tempdir",
			      global_defs,APPLYMODE_BUTTON,160,320);
   gtk_box_pack_start(GTK_BOX(preferences_common),td->visual,0,0,0);

   td=varmanwidgets_checkbox_new(_("Precache Data Tracks:"),
				 "datatrack_precache",
				 global_defs,APPLYMODE_BUTTON,160,
				 "true","false");
   gtk_box_pack_start(GTK_BOX(preferences_common),td->visual,0,0,0);
   
   td=varmanwidgets_checkbox_new(_("Use GNOME compatible drag and drop scheme"),
				 "dnd_gnome",
				 global_defs,APPLYMODE_BUTTON,160,
				 "true","false");
   gtk_box_pack_start(GTK_BOX(preferences_common),td->visual,0,0,0);

};

void preferences_save()
{
   if (preferences_saveonexit)
     configfile_save(varman_replacevars_copy(dynamic_defs,"$HOME/.gtoasterrc"));
};

void preferences_append_page(GtkWidget *newpage,GtkWidget *label)
{
   GtkWidget *scrolledwindow=gtk_scrolled_window_new(NULL,NULL);

   gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolledwindow),
					 newpage);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),
				  GTK_POLICY_AUTOMATIC,
				  GTK_POLICY_AUTOMATIC);
   gtk_widget_show(newpage);
   gtk_widget_show(scrolledwindow);
   gtk_widget_show(label);

   gtk_notebook_append_page(GTK_NOTEBOOK(preferences_editpad),
			    scrolledwindow,
			    label);
};
