/* Some functions to handle lists of files as given back on drag and drop
 * events or popup events (delete,rename,etc) */

#include "int.h"

#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <fcntl.h>
#include <stdio.h>
#include <dirent.h>
#include <stdlib.h>

#include <gtk/gtk.h>

#include "preferences.h"
#include "dirlow.h"
#include "fileman.h"
#include "linkcount.h"
#include "dialog.h"
#include "dependencies.h"
#include "streamcopy.h"
#include "streams.h"
#include "tracks.h"
#include "filetypes.h"
/* FIXME: that's where our byteswap routine is, this thing should
 * be moved to piping.c or something */
#include "stdfiletrack.h"
#include "piping.h"
#include "datacopydlg.h"
#include "layoutconfig.h"
#include "fsedit.h"
#include "helpings.h"
#include "dndsetup.h"
#include "menusys.h"
#include "vfs.h"

/* uncomment for debugging */
// #define DEBUG
//
/* the following function can be used to parse a selection as given back
 * by drag and drop and call filehandle(char*) for each separate file
 *
 * THIS FUNCTION IS DEPRECATED !!! */
int fileman_selectionhandler(char *sorig,
			     char *p,
			     int (*filehandle)(char *s,char *p,
					       fileman_mkdircall,
					       fileman_addfilecall,
					       gpointer data
					       ),
			     fileman_mkdircall mkdir,
			     fileman_addfilecall addfile,
			     gpointer data
			     )
{
   char *item,*newitem,*chr10,*chr13;
   char filename[MAXPATHLENGTH];
   int  success;      // does the file system need reloading ??
   char *s;

   /* make a local copy of the selectionstring */
   s=(char*)malloc(strlen(sorig)+1);
   strcpy(s,sorig);

   success=0;
   item=s;
   do
     {
	chr13=strchr(item,13);
	chr10=strchr(item,10);
	newitem=chr13;
	if (((chr10!=NULL) && (chr10<chr13)) || (chr13==NULL))
	  newitem=chr10;
	if (newitem==NULL)
	  newitem=item+strlen(item);
	else
	  {
	     *newitem=0;
	     do
	       {
		  newitem++;
	       }
	     while ((*newitem==10)||(*newitem==13));
	  }
	;
	strcpy(filename,item);
	if (strlen(filename)!=0)
	  success|=filehandle(filename,p,mkdir,addfile,data);
	item=newitem;
     }
   while (strlen(filename)>0);
   free(s);
   return success;
}
;

/* This is currently needed for multisession support which is broken
 * (only it's view, ms will work) */
int fileman_defaultmkdir(char *dirname,char *path,gpointer data)
{
   printf("fileman_defaultmkdir: Deprecated! Won't work...\n");
   return 1;
};

int fileman_addnormalfile_generic(char *f,char *p,
				  fileman_mkdircall mkdir,
				  fileman_addfilecall addfile,
				  gpointer data)
{
   /* FIXME: print some nice message box here ;-) */
   return addfile(f,p,data);
};

/* add a single directory to the path specified by char *p
 * all the items of this directory will be added depending on wether theyre
 * directories themselves,in which case adddirectory will simply be called
 * recursively,or wether theyre just normal files,which will then be added
 * using addnormalfile() */
int fileman_adddirectory_generic(char *sd,char *p,GList **linkcount,
				 int contentof,
				 fileman_mkdircall mkdircall,
				 fileman_addfilecall addfilecall,
				 gpointer data)
{
   char *dirname;
   char *destdir;

   char *sourcefile;
   DIR  *dir;
   struct dirent *entry;
   int success;

   success=0;
   dirname=helpings_rpathcomponent(sd);

   destdir=(char*)malloc(MAXPATHLENGTH);
   strcpy(destdir,p);

   /* if the directory itself should be added */
   if (!contentof)
     {
	/* create it */
	if (mkdircall(dirname,p,data)==0)
	  perror("Couldn't create directory");

	/* write into it */
	if (destdir[strlen(destdir)-1]!="/"[0])
	  strcat (destdir,"/");
	strcat(destdir,dirname);
     };

   sourcefile=(char*)malloc(MAXPATHLENGTH);
   dir=opendir(sd);
   if (dir!=NULL)
     {
	while ((entry=readdir(dir))!=NULL)
	  {
	     if ( strcmp(entry->d_name,"..") &&
		 strcmp(entry->d_name,"."))
	       {
		  strcpy(sourcefile,sd);
		  if (sd[strlen(sd)-1]!="/"[0])
		    strcat(sourcefile,"/");
		  strcat(sourcefile,entry->d_name);
		  if (dirlow_isdir(sourcefile))
		    {
		       /* check wether filename is
			* a symbolic link and
			* has been added before
			* to avoid recursive loops */
		       if (linkcount_use(linkcount,sourcefile)<1)
			 fileman_adddirectory_generic(sourcefile,destdir,linkcount,0,
						      mkdircall,
						      addfilecall,
						      data
						      );
		    }
		  else
		    fileman_addnormalfile_generic(sourcefile,destdir,
						  mkdircall,
						  addfilecall,
						  data);
	       }
	     ;
	  }
	;
	closedir (dir);
	success=1;
     }
   else
     printf ("fileman_adddirectory: couldnt read directory %s\n",
	     dirname);

   free(sourcefile);
   free(destdir);
   free(dirname);
   return success;
}
;

typedef struct
{
   char *sourcepath;
   char *destpath;
   fileman_additems_continuecb cb;
   fileman_additems_state *cbdata;
   datacopydlg_dlginfo *progress;
   int copy_handle;
}
fileman_addfile_generic_callback_info;

void fileman_addfile_generic_callback(int status,
				      gpointer data)
{
   fileman_addfile_generic_callback_info *info=(fileman_addfile_generic_callback_info*)data;

   info->cbdata->errors+=status;
   free(info->sourcepath);
   free(info->destpath);
   layoutconfig_widget_hide(info->progress->messagebox,
			    "addfilesdialog");
   datacopydlg_destroy(info->progress);
   info->cb(info->cbdata);
   free(info);
};

void fileman_addfile_generic_stophandler(GtkWidget *w,
					 gpointer data)
{
   fileman_addfile_generic_callback_info *info=(fileman_addfile_generic_callback_info*)data;
   vfs_copy_recursively_cancel(info->copy_handle);
};

/* add a single generic file item to the patch specified by char *p
 * this can be either a normal file or a directory */
void fileman_addfile_generic(char *i,
			     gpointer generic_userdata,
			     gpointer user_data,

			     fileman_additems_continuecb cb,
			     fileman_additems_state *cbdata)
{
   char *sourcepath=strdup(i);
   vfs_filesystem *sourcefs=vfs_parseuri(i,sourcepath);

   char *destpath=strdup((char*)generic_userdata);
   char *newname=helpings_rpathcomponent(sourcepath);
   vfs_filesystem *destfs=vfs_parseuri((char*)generic_userdata,destpath);
   char *newpath=helpings_fileinpath(destpath,newname);
   free(destpath);free(newname);

   /* You never know */
   if ((sourcefs)&&(destfs))
     {
	fileman_addfile_generic_callback_info *info=(fileman_addfile_generic_callback_info*)malloc(sizeof(fileman_addfile_generic_callback_info));

	info->sourcepath=sourcepath;
	info->destpath=newpath;
	info->cb=cb;
	info->cbdata=cbdata;
	info->progress=datacopydlg_create(_("Adding files to the filesystem"),
					  fileman_addfile_generic_stophandler,
					  info,
					  2,

					  DATACOPYDLG_SHOWLABEL|
					  DATACOPYDLG_SHOWPROGRESS,
					  "",
					  _("(please wait)"),
					  1024*1024,

					  DATACOPYDLG_SHOWTIME_ELAPSED,
					  "",
					  "",
					  1024*1024);
	layoutconfig_widget_show(info->progress->messagebox,
				 "addfilesdialog");

	info->copy_handle=vfs_copy_recursively(destfs,
					       newpath,
					       sourcefs,
					       sourcepath,

					       info->progress,
					       0,

					       fileman_addfile_generic_callback,
					       info,

					       // can't link when moving files
					       ((((int)user_data==DNDSETUP_LINK)
						 &&(destfs!=sourcefs))
						?1:0),
					       // move if called with source fs == dest fs
					       (destfs==sourcefs)
					       );
     }
   else
     {
	/* Something went wrong. Get the hell out of here */
	free(newpath);
	free(sourcepath);
	cb(cbdata);
     };
}
;

typedef struct
{
   /* global dnd context for streams,
    * we don't have to destroy this.
    * This is done by the instance initiating the dnd event */
   fileman_addstreamglobal *global;
   int byteswappid;
   streamcopy_state *state;
   /* close the track when done */
   tracks_trackinfo *track;
   datacopydlg_dlginfo *dlg;
   /* delete the file on error */
   char *dest_uri;

   fileman_additems_continuecb cb;
   fileman_additems_state *cbdata;
}
fileman_s2finfo;

void fileman_s2fdone(streamcopy_state *state,
		     fileman_s2finfo *info)
{
   if ((state->fatalerror)&&(info->dest_uri))
     {
	char *path=strdup(info->dest_uri);
	vfs_filesystem *fs=vfs_parseuri(info->dest_uri,path);
#ifdef DEBUG
	printf("fileman_s2fdone: deleting incomplete file '%s'\n",info->dest_uri);
#endif
	vfs_deletefile(fs,path);
	free(path);
     }
   else
     {
	/* Seems like encoding succeeded. Let's see if the file requires
	 * any sort of post-processing (like setting ID3 tags) */
	char *path=strdup(info->dest_uri);
	vfs_filesystem *fs=vfs_parseuri(info->dest_uri,path);
	char *realpath = vfs_getrealname(fs,path);
	if (realpath&&strrchr(realpath,'.'))
	  {
	     filetypes_filetypeentry *ftinfo =
	       filetypes_getfiletypehandler(strrchr(realpath,'.'));
	     if (ftinfo&&strlen(ftinfo->settitle))
	       {
		  /* Found tagging command. Make sure to call it */
		  char *artist = helpings_escape(info->track->performer,"\"",'\\');
		  char *title  = helpings_escape(info->track->title,"\"",'\\');
		  char *filename = helpings_escape(realpath,"\"",'\\');
		  char *call = (char*)malloc(strlen(ftinfo->settitle)+
					     strlen(artist)+
					     strlen(title)+
					     strlen(filename)+
					     1);
		  strcpy(call, ftinfo->settitle);
		  varman_replacestring(call, "$artist",	  artist);
		  varman_replacestring(call, "$title", 	  title);
		  varman_replacestring(call, "$filename", filename);
		  if (piping_isvalid_command(call))
		    {
		       system(call);
		    }
		  else
		    {
		       const char *msgtemplate =
			 _("GnomeToaster was unable to set tagging informations\n"			
			   "for the file it just encoded because the program responsible for doing this\n"
			   "could not be found on your system:\n%s.\n");
		       char *message=(char*)malloc(strlen(msgtemplate)+strlen(call)+1);
		       sprintf(message,msgtemplate,call);		       
		       dependencies_showdep(call,
					    message
					    );
		       free(message);
		    };
		  free(artist);free(title);free(filename);
		  free(call);
	       };
	     free(realpath);
	  };
	free(path);
     };
   layoutconfig_widget_hide(info->dlg->messagebox,"datacopydialog");
   datacopydlg_destroy(info->dlg);
   /* we have to kill byteswap explicitly if it is in use.
    * and we even have to do this before closing the track cause this
    * will create a stale-lock otherwise */
   if (info->byteswappid!=-1)
     {
	int status;

	kill(info->byteswappid,
	     SIGTERM);
	waitpid(info->byteswappid,&status,0);
     };
   tracks_closepipe(info->track);
   tracks_unclaim(info->track);
   info->cb(info->cbdata);
   if (info->dest_uri)
     free(info->dest_uri);
   free(info);
};

void fileman_s2fstop(GtkWidget *w,
		     fileman_s2finfo *info)
{
   streamcopy_cancel(info->state);
};

void fileman_addstream_encoderselected(gpointer choice,gpointer data)
{
   int error=0;

   fileman_s2finfo *info=(fileman_s2finfo*)data;
   filetypes_filetypeentry *enc;

   /* only continue if we can get data from the track that is about to
    * be encoded */
   if (tracks_valid(info->track))
     {
   /* get the appropriate encoder */
	if (choice!=NULL)
	  {
	     enc=filetypes_getfiletypehandler((char*)choice);
	/* remember the user's choice for this tracktype */
	     filetypes_addmapping(&info->global->encodermapping,
				  info->track->tracktype,
				  (char*)choice);
	  }
	else
	  enc=filetypes_getdefaultencoder(info->track->tracktype);
	if (enc!=NULL)
	  {
	     char sfx[16];
	     char *ourtrackfile;
	     char *call;
	     char *complete_name;
	     vfs_filesystem *fs=NULL;
	     char *realname=NULL;

	     /* so long, info->dest_uri only contains the path where our
	      * encoded file should be stored. we're now going to build
	      * a complete filename on top of it */

	     ourtrackfile=(char*)malloc(MAXSTRINGSIZE);
	     strcpy(ourtrackfile,info->track->name);
	     strcpy(sfx,enc->suffix);
	     if (strchr(sfx,' '))
	       *strchr(sfx,' ')=0;
	     strcat(ourtrackfile,enc->suffix);
	     helpings_makelegalfilename(ourtrackfile);
	     complete_name=helpings_fileinpath(info->dest_uri,ourtrackfile);
	     fs=vfs_parseuri(complete_name,complete_name);
	     if (fs)
	       realname=vfs_createfile_getrealname(fs,complete_name);
	     free(info->dest_uri);
	     info->dest_uri=vfs_buildvfsuri(fs,complete_name);
	     /* could we get a filename to pass to the encoder ? */
	     if (realname)
	       {
		  char *esc_name=helpings_escape(realname,
						 "\"",
						 '\\');
#ifdef DEBUG
		  printf("fileman_addstream: writing stream to '%s'\n",
			 info->dest_uri);
#endif

	/* open encoder */
		  call=varman_replacevars_copy(global_defs,
					       enc->encoder);
		  varman_replacestring(call,"$file",esc_name);
		  free(esc_name);
#ifdef DEBUG
		  printf ("fileman_addstream: calling encoder (%s) \n",call);
#endif
	/* will the encoder work ? */
		  if (piping_isvalid_commandchain(call,NULL))
		    {
		       int tracksize;
		       int trackfd;
		       int source;
		       int encpid;
		       int encin;

		       trackfd=tracks_openpipe(info->track);
	/* perform bigendian->littleendian conversion if necessary */
		       if (enc->enc_lendian)
			 {
#ifdef DEBUG
			    printf("fileman_addstream: starting byteswap\n");
#endif
			    source=-1;
			    info->byteswappid=piping_create_function(stdfiletrack_byteswap,
								     NULL,
								     &trackfd,
								     &source,
								     NULL);
			 }
		       else
			 {
			    source=trackfd;
			    info->byteswappid=-1;
			 };
		       encin=-1;
		       encpid=piping_create(call,
					    &encin,
					    NULL,NULL);
		       tracksize=tracks_tracksize(info->track);
		       info->dlg=datacopydlg_create(_("Encoding File"),
						    fileman_s2fstop,
						    info,
						    1,
						    DATACOPYDLG_SHOWLABEL|
						    DATACOPYDLG_SHOWTHROUGHPUT|
						    DATACOPYDLG_SHOWTIME_REMAINING|
						    DATACOPYDLG_SHOWTIME_ELAPSED|
						    DATACOPYDLG_SHOWPROGRESS|
						    DATACOPYDLG_SHOWPROGRESSINTITLE,
						    "",
						    ourtrackfile,
						    tracksize
						    );
		       layoutconfig_widget_show(info->dlg->messagebox,"datacopydialog");

		       info->state=streamcopy_create(encin,
						     source,
						     encpid,
						     tracksize,
						     info->dlg,
						     STREAMCOPY_OPT_CLOSEDEST|
						     STREAMCOPY_OPT_WAITEXIT
						     ,
						     (streamcopy_callback)fileman_s2fdone,
						     info);
		    }
		  else
		    {
		       /* the encoder couldn't be found.
			* Show it's dependency database entry */
		       dependencies_showmissingexec(call);
		       error=1;
		    };
		  free(call);
	       };
	     free(ourtrackfile);
	  }
	else
	  {
	/* no encoder could be found for the selected tracktype */
	     char *message=(char*)malloc(1024+strlen(info->track->tracktype));
	     sprintf(message,_("No valid encoder could be found for the\n"
			       "selected tracktype %s.\n"
			       "Please create a corresponding entry in the\n"
			       "encoder section of Gnometoaster's filetype\n"
			       "registry.\n"),
		     info->track->tracktype);
	     dialog_error(message);
	     free(message);
	     error=1;
	  };
     }
   else
     error=1;
   /* Clean up on error */
   if (error)
     {
	/* unclaim the track as we don't have any use for it anymore with
	 * no encoder available */
	tracks_unclaim(info->track);
	free(info);
     };
};

/* used to copy the contents of a trackstream into a file
 * within the specified path with the name of the stream as filename */
void fileman_addstream(char*i,
		       gpointer generic_userdata,
		       gpointer user_data,

		       fileman_additems_continuecb cb,
		       fileman_additems_state *cbdata)
{
   char *s=(char*)(strchr(i,':')+1);
   char *p=(char*)generic_userdata;
   fileman_addstreamglobal *global=(fileman_addstreamglobal*)user_data;
   int dragtype=global->dragtype;
   fileman_s2finfo *info=(fileman_s2finfo*)malloc(sizeof(fileman_s2finfo));

#ifdef DEBUG
   printf("fileman_addstream: processing item '%s'\n",i);
#endif

   info->global=global;
   info->cb=cb;info->cbdata=cbdata;
   /* remember destination */
   info->dest_uri=strdup(p);

   if (s!=NULL)
     info->track=streams_getstreambyid(s);
   else
     info->track=NULL;

   if (info->track!=NULL)
     {
	tracks_claim(info->track);

	if (dragtype==DNDSETUP_COPY)
	  {
	     /* was the encoder selected previously within this dnd
	      * context ? */
	     if (!filetypes_getmapping(global->encodermapping,info->track->tracktype))
	       {
		  int enccount=filetypes_getenccount(info->track->tracktype);
		  GList *encoders=filetypes_getencoders(info->track->tracktype);
		  menusys_dynmenu_entry *menu;
		  int i;
		  GList *current=encoders;

		  /* build menu */
		  menu=menusys_dynmenu_create(enccount);
		  for (i=0;i<enccount;i++)
		    {
		       char buffer[255];

		       sprintf(buffer,_("Encode as %s"),
			       ((filetypes_filetypeentry*)(current->data))->suffix);

		       strcpy(menu[i].label,buffer);
		       menu[i].choice=(gpointer)strdup(((filetypes_filetypeentry*)(current->data))->suffix);
		       current=current->next;
		    };

		  menusys_popupwithsinglecallback(fileman_addstream_encoderselected,
						  info,
						  1,
						  enccount,
						  menu);
		  /* dynamic menu is no longer needed */
		  free(menu);
	       }
	     else
	       /* an encoder was selected previously for this tracktype,
		* just copy this choice
		* for the rest of the dnd event */
	       fileman_addstream_encoderselected(filetypes_getmapping(global->encodermapping,info->track->tracktype),
						 (gpointer)info);
	  }
	else
	  /* no user input requested. Just take the default encoder */
	  fileman_addstream_encoderselected(NULL,(gpointer)info);
     }
   else
     {
	cb(cbdata);
	free(info);
     };
};

typedef struct
{
   void(*finished)(gpointer);
   gpointer data;
   char path[MAXPATHLENGTH];
   vfs_filesystem *fs;
}
fileman_mkdir_info;

void fileman_mkdir_gotname(gchar *name,gpointer data)
{
   fileman_mkdir_info *info;

   info=(fileman_mkdir_info*)data;
   if ((name!=NULL)&&(strlen(name)>0))
     {
	char *newdir=helpings_fileinpath(info->path,name);
	vfs_createdir(info->fs,newdir);
	free(newdir);
	info->finished(info->data);
     }
   ;
	/* free the mkdir_info structure */
   free(data);
}
;

/* display a dialog asking for a directory name,create requested directory
 * then */
void fileman_mkdir_dialog(vfs_filesystem *fs,
			  char *path,
			  void(*finished)(gpointer),
			  gpointer data)
{
   fileman_mkdir_info *info;

   info=(fileman_mkdir_info*)malloc(sizeof(fileman_mkdir_info));
   strcpy(info->path,path);
   info->fs=fs;
   info->finished=finished;
   info->data=data;

   dialog_string(_("Create Directory"),
		 _("New Directory"),
		 MAXPATHLENGTH,
		 (dialog_stringcallback)fileman_mkdir_gotname,
		 info);
}
;

typedef struct
{
   void(*finished)(char *newname,gpointer);
   gpointer data;
   char oldname[MAXPATHLENGTH];
   vfs_filesystem *fs;
}
fileman_rename_info;

void fileman_rename_gotname(gchar *name,gpointer data)
{
   fileman_rename_info *info;

   info=(fileman_rename_info*)data;
   if ((name!=NULL)&&(strlen(name)>0))
     {
	char *pathonly = helpings_pathonly(info->oldname);
	char *newpath  = helpings_fileinpath(pathonly,name);
	
	/* make the actual rename call */
	vfs_renamefile(info->fs,info->oldname,name);

	info->finished(newpath,info->data);
	
	free(pathonly);
	free(newpath);
     }
   ;
	/* free the rename_info structure */
   free(data);
}
;

/* display a dialog asking for a new name,rename file then */
void fileman_rename_dialog(vfs_filesystem *vfs,
			   char *oldfile,
			   void(*finished)(char *newname,gpointer),
			   gpointer data)
{
   fileman_rename_info *info;
   char *filename;

   filename=strrchr(oldfile,'/');
   if (filename!=NULL)
     {
	filename++;

	info=(fileman_rename_info*)malloc(sizeof(fileman_rename_info));
	strcpy(info->oldname,oldfile);
	info->fs=vfs;
	info->finished=finished;
	info->data=data;

	dialog_string(_("Rename File"),
		      filename,
		      MAXPATHLENGTH,
		      (dialog_stringcallback)fileman_rename_gotname,
		      info);
     };
}
;

int fileman_file_exist(char *filename)
{
   int f;
   int result=0;

   f=open(filename,O_RDONLY);
   if (f!=-1)
     {
	close(f);
	result=1;
#ifdef DEBUG
	printf ("fileman_file_exist: %s exists.\n",filename);
#endif
     }
   else
     {
#ifdef DEBUG
	printf ("fileman_file_exist: %s does not exist (",filename);
	perror ("");
	printf (").\n");
#endif
     };
   return result;
};

typedef struct
{
   char *type;
   fileman_itemcallback cb;
   gpointer data;
}
fileman_itemhandler;

void fileman_additemlist_iterate(fileman_additems_state *state)
{
   GList *chandler;
   char *current;

   if (state->items!=NULL)
     current=(char*)state->items->data;
   else
     current=(char*)NULL;
   if (current!=NULL)
     {
	int done=0;
	/* do this first so we can allow recursive calls */
	state->items=g_list_remove(state->items,(gpointer)current);
	for (chandler=state->ihandlers;
	     ((!done)&&(chandler!=NULL));
	     chandler=((!done)?chandler->next:NULL))
	  {
	     fileman_itemhandler *h=(fileman_itemhandler*)(chandler->data);
	     /* matching our item ? Call it then ... */
	     if (!strncasecmp(h->type,
			      current,
			      strlen(h->type)))
	       {
		  h->cb(current,
			state->generic_userdata,
			h->data,
			fileman_additemlist_iterate,
			state);
		  /* as h->cb might call iterate immediately,
		   * our whole state struct might no longer be valid
		   * at this stage.
		   * So we have to terminate this loop immediately if
		   * we don't want to run into trouble. */
		  done=1;
	       };
	  };
	/* this item has been removed from the item list already so
	 * it is definitely ours. We're allowed to destroy it. */
	free(current);
     }
   else
     /* No more items to process ? Good :-) */
     {
	fileman_itemhandler *h;

	/* call done callback if installed */
	if (state->cb)
	  state->cb(state->errors,state->data);
	/* clean up */
	while (state->ihandlers)
	  {
	     h=(fileman_itemhandler*)(state->ihandlers->data);
	     if (h!=NULL)
	       {
		  state->ihandlers=g_list_remove(state->ihandlers,
						 h);
		  free(h->type);
		  free(h);
	       };
	  };
	free(state);
     };
   /* we can return here. the next _iterate process will be called from
    * the item handler currently in control */
};

void fileman_additemlist(GList *items,
			 fileman_additems_donecallback dcb,
			 gpointer data,
			 gpointer generic_userdata,
			 int num_handlers,
			 ...)
{
   int i;
   fileman_additems_state* state=(fileman_additems_state*)malloc(sizeof(fileman_additems_state));
   va_list itemhandlers;

#ifdef DEBUG
   printf("fileman_additemlist: adding the following items:\n");
   helpings_printstringlist(items);
#endif

   state->errors=0;

   state->cb=dcb;
   state->data=data;
   state->items=items;
   state->generic_userdata=generic_userdata;

   state->ihandlers=NULL;
   va_start(itemhandlers,num_handlers);
   for (i=0;i<num_handlers;i++)
     {
	fileman_itemhandler *h=(fileman_itemhandler*)malloc(sizeof(fileman_itemhandler));

	h->type=strdup(va_arg(itemhandlers,char*));
	h->cb=va_arg(itemhandlers,fileman_itemcallback);
	h->data=va_arg(itemhandlers,gpointer);

	state->ihandlers=g_list_prepend(state->ihandlers,
					(gpointer)h);
     };
   va_end(itemhandlers);
   /* setup complete, now start actually doing something */

   fileman_additemlist_iterate(state);
};
