/* contains all default command strings and entries used by gnometoaster */

#ifndef DEFAULTENTRIES_H
#define DEFAULTENTRIES_H

/* initially used in preferences.c and configupdate.c */
#define DEFAULTENTRIES_FSEDIT_VOLID "CDROM"
#define DEFAULTENTRIES_TEMPDIR "/tmp"
#define DEFAULTENTRIES_CDDBSERVER "freedb.freedb.org:888"
#define DEFAULTENTRIES_DND_GNOME "true"
#define DEFAULTENTRIES_REC_CLIENT "cdrecord"
#define DEFAULTENTRIES_REC_SINGLECALLCDRECORD "true"
#define DEFAULTENTRIES_REC_CDRECORDNPIPE "$tempdir/gtoaster"
#define DEFAULTENTRIES_REC_DAOCLIENT "cdrdao"
#define DEFAULTENTRIES_REC_USECDRDAO "true"
#define DEFAULTENTRIES_REC_WRITECD "rec_clientrec_multisessionrec_dummymode$buprotect$daomode dev=$scsiid speed=rec_speed $writelist"
#define DEFAULTENTRIES_REC_TRACKITEM "-$tracktype tsize=$tracksize $filename"
#define DEFAULTENTRIES_REC_DAOWRITE "rec_daoclient writerec_daodummymode --driver generic-mmc:$cdtextflag --device $scsiid --speed rec_speed $tocfile"
#define DEFAULTENTRIES_REC_FIXATE "rec_clientrec_multisessionrec_dummymode dev=$scsiid speed=rec_speed -fix"
#define DEFAULTENTRIES_REC_WRITETRACK "rec_clientrec_multisessionrec_dummymode$buprotect dev=$scsiid speed=rec_speed -nofix -tsize=$tracksize -$tracktype -"
#define DEFAULTENTRIES_REC_CLEARDISC "rec_clientrec_dummymode dev=$scsiid speed=rec_speed -blank=rec_blankingmode"
#define DEFAULTENTRIES_REC_BLANKINGMODE "fast"
#define DEFAULTENTRIES_REC_EJECTDISC "rec_client dev=$scsiid -eject"
#define DEFAULTENTRIES_REC_RELOADDISC_CMD "eject -t $device"
#define DEFAULTENTRIES_REC_GETMSINFO "rec_client dev=$scsiid -msinfo"
#define DEFAULTENTRIES_REC_DOEJECT "true"
#define DEFAULTENTRIES_REC_RELOADDISC "true"
#define DEFAULTENTRIES_REC_DUMMYMODE ""
#define DEFAULTENTRIES_REC_DAODUMMYMODE ""
#define DEFAULTENTRIES_REC_DAO "false"
#define DEFAULTENTRIES_REC_BUPROTECT "false"
#define DEFAULTENTRIES_REC_WRITECDTEXT "true"
#define DEFAULTENTRIES_REC_DOFIXATE "true"
#define DEFAULTENTRIES_REC_MULTISESSION ""
#define DEFAULTENTRIES_REC_SPEED "2"
#define DEFAULTENTRIES_REC_INQDRIVE "rec_client -inq dev=$scsiid"
#define DEFAULTENTRIES_REC_SCANBUS  "cdrecord -scanbus"
#define DEFAULTENTRIES_REC_SBGETID  "regexp(\"[\t ]*([0-9,]*)[\t ]*[0-9]\).*Removable CD-ROM$\")"
#define DEFAULTENTRIES_REC_INQDRIVE_GETVENDOR "regexp(\"Vendor_info *: '(.*)'\")"
#define DEFAULTENTRIES_REC_INQDRIVE_GETMODEL "regexp(\"Identifikation *: '(.*)'\")"
#define DEFAULTENTRIES_REC_INQDRIVE_GETTYPE "regexp(\"Device seems to be *: (.*)\")"
#define DEFAULTENTRIES_REC_INQDRIVE_GETDRIVETYPE "regexp(\"Device type *: (.*)\")"
#define DEFAULTENTRIES_REC_INQDRIVE_GETMOUNTPOINT_FILE "/etc/fstab"
#define DEFAULTENTRIES_REC_INQDRIVE_GETMOUNTPOINT_EXP "regexp(\"$device[\\t ]*([^\\t \\n]*)\")"
#define DEFAULTENTRIES_REC_AUTOSCAN "true"

#define DEFAULTENTRIES_ISOTRACK_CLIENT "mkisofs$eltorito$msession$getts -quiet -V \"fsedit_volid\" -f -J -r \"$symlinktree\""
#define DEFAULTENTRIES_ISOTRACK_MSOPTION " -C cdr_msinfo -M $filesystem"
#define DEFAULTENTRIES_ISOTRACK_DETWITHCREATE "true"
#define DEFAULTENTRIES_ISOTRACK_DETWITHOPTION " -print-size"
#define DEFAULTENTRIES_ISOTRACK_TSCLIENT "du -b -s -l -L \"$symlinktree\""
#define DEFAULTENTRIES_ISOTRACK_TSCALC "strval(regexp(\"[^0-9]*([0-9]*).*$\"))*2048"
#define DEFAULTENTRIES_ISOTRACK_MOUNT "mount $filesystem"
#define DEFAULTENTRIES_ISOTRACK_UMOUNT "umount $filesystem"
#define DEFAULTENTRIES_ISOTRACK_PRECACHE "false"
#define DEFAULTENTRIES_ISOTRACK_TEMPDIR "$tempdir"
#define DEFAULTENTRIES_ISOTRACK_BOOTIMAGE ""
#define DEFAULTENTRIES_ISOTRACK_MAKEBOOTABLE "false"
#define DEFAULTENTRIES_ISOTRACK_ELTORITO " -b isotrack_bootimage -c boot.catalog"
#define DEFAULTENTRIES_AUDIOTRACK_CLIENT "cdda2wav"
#define DEFAULTENTRIES_AUDIOTRACK_READ "audiotrack_client -H -O cdr -D $source -t $tracknum -"
#define DEFAULTENTRIES_AUDIOTRACK_READCDTEXT "cdda2wav -N -H -J -D $scsiid -v 66"
#define DEFAULTENTRIES_AUDIOTRACK_PARSECDTEXT_TITLE "regexp(\"Track.* $tracknum: '(.*)'.*$\")"
#define DEFAULTENTRIES_AUDIOTRACK_PARSECDTEXT_PERFORMER "regexp(\"Track.* $tracknum:.*from (.*)]$\")"
#define DEFAULTENTRIES_AUDIOTRACK_PARSECDTEXT_CDTITLE "regexp(\"Album title: '(.*)'.*$\")"
#define DEFAULTENTRIES_AUDIOTRACK_PARSECDTEXT_CDPERFORMER "regexp(\"Album title:.*from (.*)]$\")"

#define DEFAULTENTRIES_AUDIOTRACK_PRECACHE "true"
#define DEFAULTENTRIES_DATATRACK_PRECACHE "false"
#define DEFAULTENTRIES_AUDIO_DEFAULT_ENLIGHTENMENT "Enlightenment Sound Daemon"
#define DEFAULTENTRIES_AUDIO_DEFAULT_NOSOUND "No Sound"
#define DEFAULTENTRIES_AUDIO_DEFAULT_OSS "Open Sound System"

/* initially used in filetypes.c */
#define DEFAULTENTRIES_EXEC_MPG123      "mpg123 -r 44100 -s --stereo -q -"
#define DEFAULTENTRIES_EXEC_SOXWAV      "sox -t .wav - -t .raw -r 44100 -w -x -c 2 -s -"
#define DEFAULTENTRIES_EXEC_SHORTEN     "shorten -x|sox -t .wav - -t .raw -r 44100 -w -x -c 2 -s -"
#define DEFAULTENTRIES_EXEC_OGG123      "ogg123 -q -d raw -f - -"

#define DEFAULTENTRIES_LITTLEENDIAN     "little Endian"
#define DEFAULTENTRIES_BIGENDIAN        "big Endian"
#define DEFAULTENTRIES_SIZEALG_MP3      "$mp3size"
#define DEFAULTENTRIES_EXEC_MP3INFO     "mp3info -f %S \"$file\""
#define DEFAULTENTRIES_SIZEALG_WAV      "$wavsize"
#define DEFAULTENTRIES_DETSIZE_SHN      "shntool len \"$file\""
#define DEFAULTENTRIES_SIZEALG_SHN      "(((getpos(2,1)*60+getpos(2,2))*75)+getpos(2,3))*2352"
#define DEFAULTENTRIES_DETSIZE_OGG      "oggtst \"$file\""
#define DEFAULTENTRIES_SIZEALG_OGG      "strval(regexp(\"^length=([0-9]*)\"))*44100*4"

#define DEFAULTENTRIES_ENCODER_MP3      "gogo stdin \"$file\" -b 128 -offset 0 -m j"
#define DEFAULTENTRIES_ENCODER_WAV      "sox -t .raw -r 44100 -w -x -c 2 -s - -t .wav \"$file\""
#define DEFAULTENTRIES_ENCODER_OGG      "oggenc --raw - -o \"$file\""

#define DEFAULTENTRIES_ENC_LENDIAN_MP3  1
#define DEFAULTENTRIES_ENC_LENDIAN_WAV  0
#define DEFAULTENTRIES_ENC_LENDIAN_OGG  1

#define DEFAULTENTRIES_ENC_DEFAULT_MP3  1
#define DEFAULTENTRIES_ENC_DEFAULT_WAV  0
#define DEFAULTENTRIES_ENC_DEFAULT_SHN  0
#define DEFAULTENTRIES_ENC_DEFAULT_OGG  0

#define DEFAULTENTRIES_SETTITLE_MP3     "mp3info -t \"$title\" -a \"$artist\" \"$filename\""

/* used in record.c */
#define DEFAULTENTRIES_STATISTICS_LEADOUTSIZE "60231680"
#define DEFAULTENTRIES_STATISTICS_FASTBLANK "40734720"
#define DEFAULTENTRIES_STATISTICS_ALLBLANK "793800000"

/* used in fillstate.c */
#define DEFAULTENTRIES_FILLSTATE_THEMED "0"
#define DEFAULTENTRIES_FILLSTATE_COLORS "65535,0,65535:60000,0,65535"

/* default window sizes, used in layoutconfig.c */
#define DEFAULTENTRIES_LAYOUT_MAINWINDOW "width=867,height=632,xpos=67,ypos=49"
#define DEFAULTENTRIES_LAYOUT_PREFERENCES "width=795,height=487,xpos=139,ypos=157"
#define DEFAULTENTRIES_LAYOUT_BLANKINGPROGRESSDIALOG "width=349,height=166,xpos=299,ypos=299"
#define DEFAULTENTRIES_LAYOUT_ADDFILESDIALOG "width=355,height=144,xpos=309,ypos=296"
#define DEFAULTENTRIES_LAYOUT_RECORDPROGRESSDIALOG "width=348,height=279,xpos=312,ypos=230"
#define DEFAULTENTRIES_LAYOUT_DATACOPYDIALOG "width=357,height=160,xpos=315,ypos=292"

#endif // DEFAULTENTRIES_H
