#include <config.h>

#include "file.h"

#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>

#include <gettext.h>
#include <libgtklp.h>

#include "gtklp.h"
#include "file.h"

GtkWidget *fileTab,*fileRemove,*fileAdd;
GtkWidget *fileFrame,*fileList;
GtkWidget *fileRequ;
int fileSelectedEntry;

void fileTabSetDefaults(void)
{
	if(DEBUG)
		printf("Get fileDefaults\n");
	/* Buttons */
	gtk_widget_set_sensitive(fileRemove,FALSE);
	if(filesToPrintAnz >= MAXPRINTFILES)	
		gtk_widget_set_sensitive(fileAdd,FALSE);   
}

void fileSelected(GtkWidget *widget,gint row,gint column,GdkEventButton *event,gpointer data)
{
	if(DEBUG)
		printf("file-entry selected: %i->%s\n",row,filesToPrint[row]);
	fileSelectedEntry=row;
	gtk_widget_set_sensitive(fileRemove,TRUE);
}

void fileListEmpty(GtkWidget *widget,gpointer data)
{
	if(DEBUG)
		printf("file-list empty again !\n");
}

void fileSelDialogOk(GtkWidget *widget, GtkFileSelection *fs )
{
	unsigned char tmp[MAXPATH+1];
	char *z1,*z2;
        gchar *entry[1][1];
	int i1;

	strncpy(tmp,gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)),(size_t)MAXPATH);
	if(DEBUG)
		printf("File selected: %s\n",tmp);
	z1=tmp;
        z2=strrchr(tmp,'/');

	if(z2-z1+1==strlen(tmp))
	{
		if(DEBUG)
			printf("path detected, no file !\n");
	}
	else
	{
		strncpy(filesToPrint[filesToPrintAnz],tmp,(size_t)MAXPATH);
		filesToPrintAnz++;
	        if(filesToPrintAnz >= MAXPRINTFILES)
        	        gtk_widget_set_sensitive(fileAdd,FALSE);

		entry[0][0]=tmp;
		gtk_clist_append(GTK_CLIST(fileList),entry[0]);
        	if(z2 != (char)NULL)
                	*++z2=(unsigned char)NULL;
	}
        if(DEBUG)
                printf("Path selected: %s\n",tmp);
        strncpy(fileOpenPath,tmp,(size_t)MAXPATH);

        if(DEBUG)
        {
                printf("FilesToPrint: \n");
                for(i1=0;i1<filesToPrintAnz;i1++)
                        printf("  %s\n",filesToPrint[i1]);
        }
	gtk_widget_destroy(fileRequ);
}

void fileSelDialogDestroyed(GtkWidget *widget, gpointer data )
{
	if(DEBUG)
		printf("File-Requester destroyed !\n");
        gtk_window_set_modal(GTK_WINDOW(widget),FALSE);
        gtk_window_set_modal(GTK_WINDOW(mainWindow),TRUE);

}


void fileAddPressed(GtkWidget *widget,gpointer data)
{
        if(DEBUG)
                printf("Add request\n");

	fileRequ=gtk_file_selection_new(_("Print File..."));	
	gtk_file_selection_set_filename (GTK_FILE_SELECTION(fileRequ),fileOpenPath);
	gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(fileRequ));	
        gtk_window_set_modal(GTK_WINDOW(fileRequ),TRUE);
        gtk_window_set_modal(GTK_WINDOW(mainWindow),FALSE);
	gtk_window_set_position(GTK_WINDOW(fileRequ),GTK_WIN_POS_CENTER);

	gtk_signal_connect (GTK_OBJECT (fileRequ), "destroy",(GtkSignalFunc)fileSelDialogDestroyed , &fileRequ);
	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fileRequ)->ok_button),"clicked", (GtkSignalFunc) fileSelDialogOk,fileRequ);
	gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (fileRequ)->cancel_button), "clicked", (GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT (fileRequ));

	gtk_widget_show(fileRequ);

}

void fileRemovePressed(GtkWidget *widget,gpointer data)
{
	int i1;

	if(DEBUG)
		printf("Remove request for entry %i->%s\n",fileSelectedEntry,filesToPrint[fileSelectedEntry]);
	for(i1=fileSelectedEntry;i1<filesToPrintAnz-1;i1++)
		strncpy(filesToPrint[i1],filesToPrint[i1+1],(size_t)MAXPATH);
	filesToPrintAnz--;	
	gtk_clist_remove(GTK_CLIST(fileList),fileSelectedEntry);
        if(fileSelectedEntry < filesToPrintAnz)
	{
                gtk_clist_select_row(GTK_CLIST(fileList),fileSelectedEntry,-1);
	}
	else
	{
		fileSelectedEntry=-1;
		gtk_widget_set_sensitive(fileRemove,FALSE);
	}
        if(filesToPrintAnz < MAXPRINTFILES)
                gtk_widget_set_sensitive(fileAdd,TRUE);


	if(DEBUG)
	{
		printf("FilesToPrint: \n");
		for(i1=0;i1<filesToPrintAnz;i1++)
			printf("  %s\n",filesToPrint[i1]);
	}
}

void FileFrame(GtkWidget *container)
{
        GtkWidget *mainHBox,*hbox,*vbox,*buttonBox,*scrolled;
	gchar *entry[1][1],name[MAXPATH+1];

        int i1;

	entry[0][0]=name;

        mainHBox=gtk_hbox_new(FALSE,0);
        gtk_box_pack_start(GTK_BOX(container),mainHBox,FALSE,FALSE, 0);
        gtk_widget_show(mainHBox);
        fileFrame=gtk_frame_new(_("Files to print"));
        gtk_box_pack_start(GTK_BOX(mainHBox), fileFrame, TRUE, TRUE,FRAME_SPACING_V);

        hbox=gtk_hbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(fileFrame), hbox);
        gtk_widget_show(hbox);

        vbox=gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),vbox,TRUE,TRUE,INFRAME_SPACING_H);
        gtk_widget_show(vbox);

        scrolled=gtk_scrolled_window_new(NULL, NULL);
        gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled),GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(vbox),scrolled,TRUE,TRUE,0);
	gtk_widget_show(scrolled);


	fileList=gtk_clist_new(1);
	gtk_widget_set_usize(fileList,-1,FILE_DIALOG_HEIGHT);
	gtk_container_add(GTK_CONTAINER(scrolled),fileList);
	gtk_clist_set_shadow_type (GTK_CLIST(fileList), GTK_SHADOW_OUT);

	for(i1=0;i1<filesToPrintAnz;i1++)
	{
		strncpy(name,filesToPrint[i1],(size_t)MAXPATH);	
		gtk_clist_append(GTK_CLIST(fileList),entry[0]);
	}
	fileSelectedEntry=-1;

	buttonBox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),buttonBox,FALSE,FALSE,INFRAME_SPACING_V);
	gtk_widget_show(buttonBox);

	fileAdd=gtk_button_new_with_label(_("Add"));
	gtk_box_pack_start(GTK_BOX(buttonBox),fileAdd,FALSE,FALSE,0);
	gtk_widget_show(fileAdd);

        fileRemove=gtk_button_new_with_label(_("Remove"));
        gtk_box_pack_start(GTK_BOX(buttonBox),fileRemove,FALSE,FALSE,BUTTON_SPACING_H);
        gtk_widget_show(fileRemove);

	gtk_signal_connect(GTK_OBJECT(fileAdd),"pressed",GTK_SIGNAL_FUNC(fileAddPressed),NULL);
	gtk_signal_connect(GTK_OBJECT(fileRemove),"released",GTK_SIGNAL_FUNC(fileRemovePressed),NULL);
	gtk_signal_connect(GTK_OBJECT(fileList),"select_row", GTK_SIGNAL_FUNC(fileSelected), "NULL");

	gtk_widget_show(fileList);

}

void FileTab(void)
{
        fileTab=gtk_vbox_new(FALSE,0);
        gtk_notebook_append_page(GTK_NOTEBOOK(tabs), fileTab, gtk_label_new(_("File")));

	FileFrame(fileTab);

}
