#
#   Makefile.PL for gtkgrepmail
#    - version 0.1
#
require 5.000;
use ExtUtils::MakeMaker;
use strict;

#--- Configuration section ---

my @programs_to_install = qw(gtkgrepmail);

my @need_perl_modules = (
    # Check for Gtk::Types rather than the Gtk supermodule
    #   this avoids dumping MakeMaker
    {'name'     => 'Gtk',
    'test'      => 'Gtk::Types',
    'version'   => '0.7000',
    'reason'    => "implements the perl bindings to Gtk+.\n".
                    "The module is called Gtk-Perl on CPAN or ".
                    "module gnome-perl in the Gnome CVS"},

    # Check for Gnome::Types rather than the Gnome supermodule
    #   this avoids dumping MakeMaker
    {'name'     => 'Gnome',
    'test'      => 'Gnome::Types',
    'version'   => '0.7000',
    'reason'    => "implements the perl bindings to Gnome.\n".
                   "It is a submodule of the Gtk-Perl package and needs to be built separately.\n".
                   "Read the Gtk-Perl INSTALL file for details of how to do this."},

    {'name'     => 'Date',
    'test'      => 'Date::Manip',
    'version'   => '5.21',
    'reason'    => "provides date manipulation routines."},

    {'name'     => 'URI',
    'test'      => 'URI::Escape',
    'version'   => '3.13',
    'reason'    => "escapes and unescapes unsafe characters."},
    );
#--- End Configuration - You should not have to change anything below this line

# Check for non-standard modules that are used by this library.
$| = 1; # autoflush on
my $missing_modules = 0;

foreach my $mod (@need_perl_modules) {
    print "Checking for $mod->{'name'}..";
    eval "require $mod->{'test'}";
    if ($@) {
        $missing_modules++;
        print " failed\n";
        print   "-------------------------------------------------------".
                "\n$@\n",
                "$mod->{'name'} is needed, it $mod->{'reason'}\n",
                "We need at least version $mod->{'version'}\n".
                "-------------------------------------------------------\n";
        sleep(2);  # Don't hurry too much
    } else {
        print " ok\n";
    }
}

#--------------------------------------
print "-------------------------------------------------------
The missing modules can be obtained from CPAN. Visit
<URL:http://www.perl.com/CPAN/> to find a CPAN site near you.
-------------------------------------------------------\n\n"
     if $missing_modules;

#--------------------------------------
# Last of all generate the Makefile
WriteMakefile(
    'DISTNAME'     => 'gtkgrepmail',
    'NAME'         => 'gtkgrepmail',
    'EXE_FILES'    => [ @programs_to_install ],
    'dist'         => { COMPRESS => 'gzip', SUFFIX => 'gz' }
);

package MY;

# Pass version number to pod2man
sub manifypods
{
    my $self = shift;
    my $ver = $self->{'VERSION'} || "";
    local($_) = $self->SUPER::manifypods(@_);
    s/pod2mans*$/pod2man --release gtkgrepmail-$ver/m;
    $_;
}

exit(0);

# End of Makefile.PL
