// -*- C++ -*-

/* sheet_numeric.cc
 * 
 * Copyright (C) 2000 GtkExtra-- Development Team  
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "sheet_numeric.h"

Sheet_Numeric::Sheet_Numeric(gint rows, gint columns, const nstring& title)
 : GtkExtra::Sheet(rows, columns, title)
{
  set_cell.connect(slot(this, &Sheet_Numeric::on_set_cell));
}

Sheet_Numeric::~Sheet_Numeric()
{


}


void Sheet_Numeric::on_set_cell(gint row, gint col)
{
  //Parse numbers:

  //Use dynamic_cast, because it might not be an ItemEntry.
	GtkExtra::ItemEntry* pItemEntry = dynamic_cast<GtkExtra::ItemEntry*>(get_entry());
	if(pItemEntry)
	{
	  GtkSheetCellAttr attr;
	  get_attributes(get_active_cell().row, get_active_cell().col, attr);
	  
		GtkJustification justification = attr.justification; //= itemEntry->get_justification();

	  std::string strInput = pItemEntry->get_text();
	  std::string strFormatted;
	  bool bTest = format_text(justification, strInput, strFormatted);
	  if(bTest) cause_set_cell(get_active_cell().row, get_active_cell().col, justification, strFormatted);
  }
}

bool Sheet_Numeric::format_text(GtkJustification& refJustification, const std::string& strInput, std::string& refstrFormatted)
{
  refJustification = GTK_JUSTIFY_LEFT;
  refstrFormatted = "";

  gint iDefault_Precision = 3;
  gint iDefault_Space = 8;
  enum enumFormat {EMPTY, TEXT, NUMERIC};

  GtkSheetColumn sheetColumn;
  bool bTest = get_column(get_active_cell().col, sheetColumn);
  if(bTest)
  {
	  gint cell_width = sheetColumn.width;
	  gint char_width = gdk_char_width( get_style()->get_font(), (gchar)'X' );
	  gdouble space = (gdouble)cell_width/(gdouble)char_width;

	  guint intspace = (gint)(MIN(space, iDefault_Space));

	  enumFormat format = EMPTY;
	  bool nonzero = false;
	  gdouble val = 0.0;
	  if(strInput.size() != 0)
	  { 
	    for(guint ipos=0; ipos < strInput.size(); ipos++)
	    {
	      gchar nchar = strInput[ipos];
	      switch(nchar)
	      {
	        case '.':
	        case ' ': case ',':
	        case '-': case '+':
	        case 'd': case 'D':
	        case 'E': case 'e':
	        case '1': case '2': case '3': case '4': case '5': case '6':
	        case '7': case '8': case '9':
	          nonzero = true;
	          break;
	        case '0':
	          break;
	        default:
	          format = TEXT;
	      }
	          
	      if(format != EMPTY) break;
	    }
	        
	    val = atof(strInput.c_str());
	        
	    if(format != EMPTY || (val==0. && nonzero))
	    {
	      format = TEXT;
	    }
	    else
	    {
	      format = NUMERIC;
	    }
	  }
	  
	  switch(format)
	  {
	    case TEXT:
	    case EMPTY:
	      refstrFormatted = strInput;
	      return true; //success
	      break;
	    case NUMERIC:
	      val = atof(strInput.c_str());
	      refJustification = GTK_JUSTIFY_RIGHT;
	      break;
	  }
	  
	  gdouble auxval = val < 0 ? -val : val;

	  guint digspace=0;
	  while(auxval <1 && auxval != 0.)
	  {
	    auxval=auxval*10.;
	    digspace+=1;
	  }

	  gchar pchFormatted[256] = {0};
	  
	  if( ((digspace + (guint)iDefault_Precision + 1) > intspace) || (digspace > (guint)iDefault_Precision))
	  {
	    sprintf(pchFormatted, "%*.*E", intspace, iDefault_Precision, val);
	  }
	  else
	  {
	    intspace = MIN(intspace, strInput.size() - digspace - 1);
	    sprintf(pchFormatted, "%*.*f", intspace, iDefault_Precision, val);

	    if(strlen(pchFormatted) > (guint)space)
	    {
	      sprintf(pchFormatted, "%*.*E", intspace, iDefault_Precision, val);
	    }
	  }

	  refstrFormatted = std::string(pchFormatted);
	  return true; //success.
	}

	return false; //failed.
}
