// -*- C++ -*-

/* window_test_checkitem.cc
 * 
 * Copyright (C) 2000 GtkExtra-- Development Team  
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "window_test_checkitem.h"

#include <iostream>
#include <gtk--/window.h>
#include <gtk--/box.h>
#include <string>

Window_Test_CheckItem::Window_Test_CheckItem()
: m_VBox(true, 0),
  m_CheckItem1("CheckItem 1"),
  m_CheckItem2("CheckItem 2"),
  m_CheckItem3("CheckItem 3"),
  m_Button_Quit("Quit")
{ 
  set_title("GtkExtra::CheckItem Demo");
  set_default_size(200, 200);

  add(m_VBox);
  m_VBox.pack_start(m_CheckItem1, true, false);
  m_VBox.pack_start(m_CheckItem2, true, false);
  m_VBox.pack_start(m_CheckItem3, true, false);

  //Connect 'toggled' signals:
  //Use bind<> to give extra information to the signal handler.
  m_CheckItem1.toggled.connect(bind<std::string>(slot(this, &Window_Test_CheckItem::On_CheckItem_toggled), std::string("CheckItem 1")));
  m_CheckItem2.toggled.connect(bind<std::string>(slot(this, &Window_Test_CheckItem::On_CheckItem_toggled), std::string("CheckItem 2")));
  m_CheckItem3.toggled.connect(bind<std::string>(slot(this, &Window_Test_CheckItem::On_CheckItem_toggled), std::string("CheckItem 3")));

  //m_CheckItem1.toggled.connect(bind<std::string, Gtk::CheckItem*>(slot(this, &Window_Test_CheckItem::On_CheckItem_toggled), std::string("CheckItem 1"), &m_CheckItem1));


  m_VBox.pack_start(m_Button_Quit, false, false);
  m_Button_Quit.clicked.connect(slot(this, &Window_Test_CheckItem::On_Button_Quit_Clicked));
  
  show_all();
}

Window_Test_CheckItem::~Window_Test_CheckItem()
{
}

gint Window_Test_CheckItem::delete_event_impl(GdkEventAny*)
{ 
  Gtk::Main::quit();
  return 0; 
}

//Tried using 'const std::string&' instead of 'std::string', but bind<> doesn't like it.
void Window_Test_CheckItem::On_CheckItem_toggled(std::string strName)//, Gtk::CheckItem* pCheckItem)
{
  std::cout << strName << " was toggled. " << endl;
  //std::cout << " State is " << pCheckItem->
  
  //g_message ("state is %d\n",
  //GTK_CHECK_ITEM(widget)->toggle_button.active);
}

void Window_Test_CheckItem::On_Button_Quit_Clicked()
{
  Gtk::Main::quit();
}

