/*Written with Emacs.*/
/*
  GtkDiskFree shows free space on your mounted partitions.  Copyright
  (C) 2001-2002 Dj-Death (Landwerlin Lionel)
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA */

typedef struct
{
	/* Window pos/size */
	gint window_position[2];
	gint window_size[2];
	/* Blocks config */
	gint blocks[4];
	/* GUI config */
	gint sort[2];
	gint gui_style[4]; /* menubar, toolbar, statusbar, auto window
                              resize*/
	gint clist_style[4]; /* auto resize columns, Allow columns to
                                be resized, hide/show list titles,
                                rules hint */
	gint show_columns_all;
	gint show_columns[CAPACITY_COLUMN + 1];
	gint capacity_style[4]; /* gradients, percents, scaled, fixed
                                   size (if not scaled) */
	gint color_levels[2];
	gdouble color1[3];
	gdouble color2[3];
	gdouble color_text[3];
	/* Update */
	gfloat update_interval;
	/* Mount commands */
	gchar *mount_cmds[2];
	gchar *smbmount_cmds[2];
} prefs_t;

prefs_t *options;

void print_help(const gchar *);
void print_error(const gchar *);
void print_version(void);
void cfgdir_create (void);
void cfgfil_write_head (FILE *);
void cfgfil_rwd_val_str (const gchar *, gchar **, const gchar *);
void cfgfil_rwd_val_double (const gchar *, gdouble *, const gchar *);
void cfgfil_rwd_val_int (const gchar *, gint *, const gchar *);
void cfgfil_rwd_val_bint (const gchar *, gint *, const gchar *, gint,
			  const gchar *);
void cfgfil_rwd_val_bdouble (const gchar *, gdouble *, const gchar *,
			     gint, const gchar *);
void cfgfil_rwd_values (prefs_t *);
void cfgfil_read (prefs_t *);
void cfgfil_write (prefs_t *);
void cfg_init (gint, gchar **);
void cfg_load_default (void);
prefs_t *cfg_new (void);
void cfg_free (prefs_t *);
void cfg_cpy (prefs_t *, const prefs_t *);
