/*
 * GUI front-end preference header
 *
 * Preference(also referred to as property) policy:
 * There is one global prefernece variable, g_pref.
 * At startup, g_pref is load from ~/.gnome/gtkdiff file.
 * Each instance, such as window and view, has a copy of its own preference,
 * and g_pref is used as the default value of its copy.
 * When a user modifies any preference, the preference-copy of
 * the current view is modified, and g_pref is also modified simultaneously.
 * At quiting, g_pref is saved into ~/.gnome/gtkdiff file.
 *
 * I'm providing two UIs, menubar and property-box.
 * Color setting is through property-box, and the others are through menus.
 * The reason is that I believe menu is a better UI than property-box.
 * 
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_PREF_H__
#define __GDIFF_PREF_H__

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */

	
/* Constant string */
#define DEFAULT_DIFF_ARGS	"-r"
#define DEFAULT_DIFF3_ARGS	""

/* gnome-config section (~/.gnome/gtkdiff) */
#define DIFF_SECTION		"Diff"
#define WINDOW_SECTION		"Window"
#define DIR_VIEW_SECTION	"DirectoryView"
#define FILE_VIEW_SECTION	"FileView"

/* DIFF_SECTION Keys */
#define DIFF_ARGS_KEY			"DiffArgs"
#define DIFF3_ARGS_KEY			"Diff3Args"

/* WINDOW_SECTION Keys */
#define SHOW_TOOLBAR_KEY		"ShowToolbar"
#define SHOW_SEARCHBAR_KEY		"ShowSearchbar"
#define SHOW_STATUSBAR_KEY		"ShowStatusbar"
#define SHOW_TABS_KEY			"ShowTabs"

/* DIR_VIEW_SECTION Keys */
#define SHOW_PATH_KEY				"ShowPath"
#define ROW_HIDE_FUNCMASK_KEY		"RowHideFunc"
#define ROW_HIDE_STATMASK_KEY		"RowHideStat"

/* FILE_VIEW_SECTION Keys */
#define VIEW_TYPE_KEY			"ViewType"
#define SHOW_LINENUM_KEY		"ShowLineNum"
#define LINE_WRAP_KEY			"LineWrap"
#define HIGHLIGHT_KEY			"HighLight"	/* HighLight */
#define SHOW_FILL_KEY			"ShowFill"	/* Synchronize lines */
#define FILE1_FGCOLOR_KEY		"File1FGColor"
#define FILE1_BGCOLOR_KEY		"File1BGColor"
#define FILE1_HLCOLOR_KEY		"File1HLColor"	/* HighLight */
#define FILE2_FGCOLOR_KEY		"File2FGColor"
#define FILE2_BGCOLOR_KEY		"File2BGColor"
#define FILE2_HLCOLOR_KEY		"File2HLColor"	/* HighLight */
#define FILE3_FGCOLOR_KEY		"File3FGColor"
#define FILE3_BGCOLOR_KEY		"File3BGColor"
#define FILE3_HLCOLOR_KEY		"File3HLColor"	/* HighLight */

#define FILE_FILLCOLOR_KEY		"FileFILLColor"


/* Constant number */
typedef enum {
	SHOW_PATH_FILE = 0,	/* only file name */
	SHOW_PATH_ORIG = 1,	/* original path */
	SHOW_PATH_REL = 2	/* relative path */
} ShowPathDView;


/*
 * Data structure definitions
 */
/* Preference for window. Kept in GDiffWindow(gui.h) */
struct _WinPref {
	gboolean show_toolbar;
	gboolean show_searchbar;
	gboolean show_statusbar;
	gboolean show_tabs;
};
	
/* Preference for directory view. Kept in GDiffDirView(gui.h) */
struct _DViewPref {
	ShowPathDView show_path;
	int row_hide_func_mask; /* or'd of RowHideMask */
	int row_hide_stat_mask;/* or'd of FilesStatus */
};

/* Preference for file view. Kept in GDiffFileView(gui.h) */
struct _FViewPref {
	ViewType view_type;
	gboolean show_line_num;
	gboolean line_wrap;
	gboolean highlight;
	gboolean show_fill;
	/* Colors for differences on both text widget and overview widget.
	   Note: On overview widget, diff_bg is used for foreground of ranges. */
	GdkColor diff_fg[MAX_NUM_COMPARE_FILES];
	GdkColor diff_bg[MAX_NUM_COMPARE_FILES];
	GdkColor diff_hl[MAX_NUM_COMPARE_FILES];/* HighLight */
	GdkColor diff_fill;/* synchronize lines  */
};

/* Global preference structure */	
struct _Preference {
	WinPref winpref;
	DViewPref dvpref;
	FViewPref fvpref;

	/* common preferences */
	char *diff_args;
	char *diff3_args;
};

	
/* Global variable declarations */
Preference g_pref;

/* Global function declarations */
/* properties.c */
extern void properties_init(void);
extern void properties_exit(void);
extern void properties_show(void);

	
#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_PREF_H__ */
