/*
 * GUI show(hide) line numbers module
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#if defined(HAVE_STRING_H)
#include <string.h>
#elif defined(HAVE_STRINGS_H)
#include <strings.h>
#endif
#include <gtk/gtk.h>
#include "diff.h"
#include "gui.h"
#include "mbuffer.h"	/* for MBuffer */
#include "gtktext-support.h"/* for FontProp */
#include "linenum.h"
#include "misc.h"
#include "basepane-widget.h" /* for MARK_LENGTH */


/**
 * insert_remove_line_numbers:
 * Insert or remove line numbers at the head of each line on text widget.
 * Input:
 * GtkWidget *text;
 * int pos; Position in text widget to insert numbers.
 * gboolean b_ins; if TRUE insert numbers. if FALSE remove numbers. 
 * const FontProp *fprop;
 * const MBuffer *mbuf; mainly used to calculate how many characters to skip
 *                      to reach the next line.
 * int begin; Line number to start.
 * int end; Line number to end.
 * const LineFormat *lformat;
 * Output:
 * MBuffer *mbuf; internal stat is advanced.
 * Return value; Position in text widget.
 **/
int
insert_remove_line_numbers(GtkWidget *text, gboolean b_ins, int pos, const FontProp *fprop, MBuffer *mbuf, int begin, int end, const LineFormat *lformat)
{
	int ln;
	gboolean b_sbcs = !GTK_TEXT(text)->use_wchar;/* Single byte character set. */
	char str[32];
	int str_lenb;
	
	str_lenb = lformat->n_col + MARK_LENGTH;
	g_assert(str_lenb < sizeof(str)-1);
	if (lformat->format == NULL) {/* implies this line has no line number */
		memset(str, ' ', str_lenb);
	}
	for (ln = begin; ln < end; ln++) {
		const char *buf_pt;

		gtext_set_point(text, pos);
		if (b_ins == TRUE) {
			if (lformat->format)
				g_snprintf(str, sizeof(str), lformat->format, ln);
			pos = gtext_insert_buf(text, fprop, str, str_lenb);
		} else {
			gtext_forward_delete_b(text, NULL, str_lenb);
		}

		buf_pt = mbuf->cur_pt;
		mbuf_next_line(mbuf, 1);
		pos += get_num_chars(buf_pt, mbuf->cur_pt - buf_pt, b_sbcs);
	}

	return pos;
}
