/*
 * Filter function to hide a row(files) on directory view
 *
 * Every function is a following type,
 * typedef gboolean (*RowHideFunc)(const char *fname);
 * If the file specified by fname should be hidden, the function returns TRUE.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */

#ifndef __GDIFF_HIDE_H__
#define __GDIFF_HIDE_H__

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */


/* To decide whether the row is hidden on directory view. */
typedef gboolean (*RowHideFunc)(const char *fname);

/* Global function declarations */
extern gboolean hide_emacs_backup(const char *fname);
extern gboolean hide_obj_file(const char *fname);

#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_HIDE_H__ */
