/*
 * GdiffOverview widget header
 * Overview consists of GdiffRange widgets and GtkDrawingArea widgets.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_OVERVIEW_H__
#define __GDIFF_OVERVIEW_H__

#include <gtk/gtkadjustment.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtkdrawingarea.h>
#include "gdiffrange.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define WIDTH_OVERVIEW		10/*XXX: hard-code is not good? */

#define GDIFF_TYPE_OVERVIEW				(gdiff_overview_get_type())
#define GDIFF_OVERVIEW(obj)				GTK_CHECK_CAST(obj, gdiff_overview_get_type(), GdiffOverview)
#define GDIFF_OVERVIEW_CLASS(klass)		GTK_CHECK_CLASS_CAST(klass, gdiff_overview_get_type(), GdiffOverviewClass)
#define GDIFF_IS_OVERVIEW(obj)			GTK_CHECK_TYPE(obj, gdiff_overview_get_type())
#define GDIFF_IS_OVERVIEW_CLASS(klass)	(GTK_CHECK_CLASS_TYPE((klass), GDIFF_TYPE_OVERVIEW))
	
	
typedef struct _GdiffOverview       GdiffOverview;
typedef struct _GdiffOverviewClass  GdiffOverviewClass;

struct _GdiffOverview {
	GtkHBox hbox;

	int num_ranges;
	GdiffRange **ranges;	/* array of GdiffRange* */
	GtkDrawingArea **dareas;/* array of GtkDrawingArea* */
};

struct _GdiffOverviewClass {
	GtkHBoxClass parent_class;
};


GtkType gdiff_overview_get_type(void);
GtkWidget* gdiff_overview_new(int num_ranges, GtkAdjustment **adj_array);
void gdiff_overview_set_size(GdiffOverview *overview, gint width, gint height);
void gdiff_overview_set_adjustment(GdiffOverview *overview, GtkAdjustment **adj_array);

/* Insert a paint range, (0.0 - 1.0) */
void gdiff_overview_insert_paintrange(GdiffOverview *overview, const gdouble *begin_array, const gdouble *end_array);

/* sets the color, the color must already be allocated */
void gdiff_overview_set_color(GdiffOverview *overview, GdkColor **fg_array, GdkColor **bg_array);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GDIFF_OVERVIEW_H__ */
