/* aewm - a minimalistic X11 window manager. ------- vim:sw=4:et
 * Copyright (c) 1998-2001 Decklin Foster <decklin@red-bean.com>
 * Free software! Please see README for details and license.  */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include "menu-misc.h"

#define BUF_SIZE 1024

static void build_menu_recursively(FILE *rc, void *menu,
				   void (*add_menu_item)(void *, char *, char *, char *),
				   void * (*add_submenu)(void *, char *));

void build_menu(char *filename, void * menu,
		void (*add_menu_item)(void *, char *, char *, char *),
		void * (*add_submenu)(void *, char *))
{
    FILE *rc;

    if (!(rc = fopen(filename, "r"))) {
        printf("can't open file %s; exiting...\n", filename);
        exit(1);
    }

    build_menu_recursively(rc, menu, add_menu_item, add_submenu);

    fclose(rc);
}

static void build_menu_recursively(FILE *rc, void * menu,
				   void (*add_menu_item)(void *, char *, char *, char *),
				   void * (*add_submenu)(void *, char *))
{
    char buf[BUF_SIZE], *label, *cmd, *tmp;
    char xpmfn[512];

    while (fgets(buf, sizeof buf, rc)) {
        if (strncmp(buf, "@endsub", 7) == 0) return;
        if (buf[0] == '#' || buf[0] == '\n') continue;
        if (strncmp(buf, "@submenu", 8) == 0) {
	    void *newmenu;
            label = strtok(buf, " ");
            cmd = strtok(NULL, "\n");
            newmenu = add_submenu(menu, cmd);
            build_menu_recursively(rc, newmenu, add_menu_item, add_submenu);
        } else {
	    if (buf[0] == '[')
	      {
		tmp = strtok(buf, "]");
		strcpy(xpmfn, &tmp[1]);
		label = strtok(NULL, "=");
		cmd = strtok(NULL, "\n");
		if (cmd) add_menu_item(menu, label, cmd , xpmfn);
	      } else {
		label = strtok(buf, "=");
		cmd = strtok(NULL, "\n");
		if (cmd) add_menu_item(menu, label, cmd , NULL);
	      }
        }
    }
}



