# Note that this is NOT a relocatable package

%define name  gtkextra2
%define major 2
%define minor 1
%define micro 1
%define ver   %major.%minor.%micro
%define rel      1
%define prefix   /usr

Summary: A library of gtk+ widgets
Name: %name 
Version: %ver
Release: %rel
Copyright: LGPL
Group: System Environment/Libraries
Source: http://gtkextra.sourceforge.net/src/gtk+extra-%version.tar.gz
BuildRoot: /var/tmp/glib-%{PACKAGE_VERSION}-root
URL: http://gtkextra.sourceforge.net
Docdir: %{prefix}/doc

%description

A library of dynamically linked gtk+ widgets including:
GtkSheet, GtkPlot, and GtkIconList

%package devel
Summary: A library of gtk+ widgets
Group: Development/Libraries
Requires: %name = %{version}

%description devel
The gtk+extra-devel package includes the static libraries, header files,
and documentation for compiling programs that use gtk+extra widgets.

%changelog
* Fri Jan 21 2005 Adrian E. Feiguin <afeiguin@uci.edu>
- First version for gtkextra-2

* Fri Dec 20 2002 Toby D. Reeves <toby@solidstatescientific.com>
- Make the rpm name a variable.
- Set rpm name to gtk+extra allowing both 0.99.x and 1.1.x to be installed.

* Mon Jul 22 2002 Toby D. Reeves <toby@solidstatescientific.com>
- Corrected for use of pkg-config

* Wed Jul 17 2002 Toby D. Reeves <toby@solidstatescientific.com>
- Corrected -install to use DESTDIR
- Make gtk+extra-devel package require gtk+extra
- Added *.so to devel files

* Wed Mar 15  2000 Conrad Steenberg <conrad@srl.caltech.edu>
- First spec file

%prep
%setup -q -n gtk+extra-%{version}

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix
make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)

%doc INSTALL README docs/*.ChangeLog
%{prefix}/lib/libgtkextra*.so.*

%files devel
%defattr(-, root, root)
%{prefix}/lib/*so
%{prefix}/lib/*a
%{prefix}/lib/pkgconfig/*
%{prefix}/include/*
%{prefix}/include/gtkextra-2.0/*

