/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  GThumb
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef GTHUMB_APP_H
#define GTHUMB_APP_H

#include <gtk/gtk.h>
#include <libgnomeui/gnome-app.h>

#define TYPE_GTHUMB_APP            (gthumb_app_get_type ())
#define GTHUMB_APP(obj)            (GTK_CHECK_CAST ((obj), TYPE_GTHUMB_APP, GThumbApp))
#define GTHUMB_APP_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_GTHUMB_APP, GThumbAppClass))
#define IS_GTHUMB_APP(obj)         (GTK_CHECK_TYPE ((obj), TYPE_GTHUMB_APP))
#define IS_GTHUMB_APP_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_GTHUMB_APP))

typedef struct _GThumbApp       GThumbApp;
typedef struct _GThumbAppClass  GThumbAppClass;

struct _GThumbApp {
	GnomeApp __parent;
};

struct _GThumbAppClass {
        GnomeAppClass __parent_class;

	/* -- Signals -- */

	void (* focus_changed) (GThumbApp *app,
				gboolean forward);
};

GtkType     gthumb_app_get_type (void);

GtkWidget * gthumb_app_new (const gchar *appname, const gchar *title);


#endif /* GTHUMB_APP_H */
