#     G-Tablix, graphical user interface for Tablix
#     Copyright (C) 2004,2005 Bostjan Spetic
# 
#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
# 
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
# 
#     You should have received a copy of the GNU General Public License
#     along with this program; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# author: Bostjan Spetic, igzebedze@cyberpipe.org
# module with tt editor gui handlers...
# 19.12.2004, 30.1.2005, 5.3.2005

#package gtablix::gui;

use strict;

my %all_tt;		# all who were spotted in the tt definition
my %siblings;	# all of the same type as was last selected
my %linked;		# all who are connected to the last selected
my %tuples;		# pairs teacher-subject of last selected
my %fixed;		# fixed day_period pairs of the last selected
my $tt_select;	# the last selected fixed pair

# -------- full definitions editing -------------
sub on_treeview_tt_cursor_changed { &select_row("tt"); }
sub on_button_tt_rests_clicked {	&load_rests("tt"); }
sub on_treeview_tt_button_release_event { 
	my ($where, $now) = @_;
	if (($_[1]->button == 3)) { 
		&draw_context_menu ($where, $now,'tt'); 
#	} elsif (($_[1]->button == 1)) { 
#		&select_row('tt');
	}
}
sub on_button_tt_del_clicked { &del_row("tt"); } 
sub on_treeview_tt_key_press_event { 
	my ($where, $now) = @_;
	if ($now->keyval == $Gtk2::Gdk::Keysyms{Delete}) {
		my @paths = $where->get_selection->get_selected_rows;
		if ($paths[0]) { &on_button_tt_del_clicked; }
	}
}
sub on_button_tt_use_clicked {
	my $form = &get_form;	
	my $teacher = clarify($form->get_widget('combo_entry_tt_teacher')->get_text());
	my $subject = clarify($form->get_widget('combo_entry_tt_subject')->get_text());
	my $classroom = clarify($form->get_widget('combo_entry_tt_classroom')->get_text());
	my $class = clarify($form->get_widget('combo_entry_tt_class')->get_text());
	my $perweek = clarify($form->get_widget('entry_tt_perweek')->get_text());
	my $period = clarify($form->get_widget('entry_tt_period')->get_text());
	my $day = clarify($form->get_widget('entry_tt_day')->get_text());
	my $rests = clarify($form->get_widget('entry_tt_rests')->get_text());
	
	if (($subject eq "") or ($teacher eq "") or ($class eq "")) {
			my $message = gettext("You must specify at least \"Class\", \"Teacher\" AND \"Subject\"
AND either \"Perweek\" OR \"Period, Day, Classroom\"!");
 			&check($message,'error',1);
	} else {
		my $tablix = &get_tablix;
			
# ne dovolimo vnesti hkrati $perweek in $period,$day,$room
		if ($perweek ne "") { 
		
		# tablix2 knows hinting, but 1 doesn't	
			if (&get_tablix eq 'tablix') {
				$day = "";
				$period = "";
				$classroom = ""; 
			
# if user wants double period, make one... :)
	 		if ($form->get_widget('checkbutton_double_period')->get_active) {
	 		 # add new tuple
	 			my $s = $subject.'2';
	 			my $row = &add_to_tree($form,'tt',$class,$s);
	 			my $tv_t = $form->get_widget('treeview_tt');
	 			$tv_t->get_model->set($row,0,$class,1,$s,2,$teacher,3,$perweek,7,"double-period=$subject");			
	 	 	 # add new subject	
	 			$form->get_widget('entry_teacher_name')->set_text($teacher);
	 	 		$form->get_widget('entry_teacher_subjects')->set_text($s);
	 	 		&add_row("teacher");
	 		 # activate module
	 	 			$row = &find_clist_row("modules","double_period.so");
	 	 		# check that the module exists
	 				if ($row ne "new") {
	 	 				my $tvm = $form->get_widget('treeview_modules')->get_model;
	 					my $iter = $tvm->get_iter_from_string($row);
	 	            $tvm->set($iter, 3, '1');	
	 			# set weigth to at least 1
	 					my $val = $tvm->get($iter,1);
	  	 				if (!$val) { 
	 						$tvm->set($iter,1,'1'); 
	 					}
	 		 		}
	 			}
			} else {
				if ($form->get_widget('checkbutton_double_period')->get_active) {
# todo: enable consecutive module automaticaly				
					$rests .= ";consecutive";
				# activate module
	 	 			my $row = &find_clist_row("modules","consecutive.so");
	 	 		# check that the module exists
	 				if ($row ne "new") {
	 	 				my $tvm = $form->get_widget('treeview_modules')->get_model;
	 					my $iter = $tvm->get_iter_from_string($row);
	 	            $tvm->set($iter, 3, '1');	
	 			# set weigth to at least 1
	 					my $val = $tvm->get($iter,1);
	  	 				if (!$val) { 
	 						$tvm->set($iter,1,'1'); 
	 					}
	 		 		}				
				}
			}
		} elsif ((defined $day) and (defined $period) and ($form->get_widget('checkbutton_double_period')->get_active)) {
	 		 # add new tuple
	 			my $row = &add_to_tree($form,'tt',$class,$subject);
	 			my $tv_t = $form->get_widget('treeview_tt');
	 			$tv_t->get_model->set($row,0,$class,1,$subject,2,$teacher,4,$classroom,5,($period + 1),6,($day + 1));			
		}
# write in
		my $row = &add_to_tree($form,'tt',$class,$subject);
		my $tv_t = $form->get_widget('treeview_tt');
		$tv_t->get_model->set($row,0,$class,1,$subject,2,$teacher,3,$perweek,4,$classroom,5,$period,6,$day,7,$rests);
		$tv_t->expand_to_path($tv_t->get_model->get_path($row));
		$tv_t->set_cursor($tv_t->get_model->get_path($row),undef,0);

# and add the room, teacher and subject if they don't exist
# but only if the user wants the 'additive mode'
	 	if ($form->get_widget('checkbutton_additive')->get_active) {
	 	 	$form->get_widget('entry_teacher_name')->set_text($teacher);
	 		$form->get_widget('entry_teacher_subjects')->set_text($subject);
	 		&add_row("teacher");
	 		$form->get_widget('entry_class_name')->set_text($class);
	 		&add_row("class");	
	 		if ($classroom) {
	 			$form->get_widget('entry_classroom_name')->set_text($classroom);		
	 			&add_row("classroom");	
	 		}
	 	}
# return from combo_change
		$form->get_widget('combo_entry_tt_teacher')->set_text($teacher);
		$form->get_widget('combo_entry_tt_class')->set_text($class);
		$form->get_widget('combo_entry_tt_classroom')->set_text($classroom);
		$form->get_widget('combo_entry_tt_subject')->set_text($subject);
# set the changed title
		my @title = split/ - /,$form->get_widget('window_main')->get_title;
		if ($#{title} != 2) { $form->get_widget('window_main')->set_title($title[0]." - ".$title[1]." - Unsaved"); }
		&write_to_statusbar(gettext("Added new row to timetable definition."));
	}
} 
# -------- settings ---------------------
sub on_checkbutton_additive_toggled {
	my ($me) = @_;
	my $what;
	my $form = &get_form;
	if ($me->get_active) { $what = 'yes'; } else { $what = 'no'; }
	$form->get_widget('combo_entry_tt_teacher')->set('editable' => $what);
	$form->get_widget('combo_entry_tt_subject')->set('editable' => $what);
	$form->get_widget('combo_entry_tt_classroom')->set('editable' => $what);
	$form->get_widget('combo_entry_tt_class')->set('editable' => $what);	
	$form->get_widget('entry_tt_day')->set('editable' => $what);
	$form->get_widget('entry_tt_period')->set('editable' => $what);	
	&write_to_statusbar(gettext("Shall I add new entities you type in the timetable editor?")." ".gettext($what));
}

sub on_treeview_tt_unselect_all {
	my $form = &get_form;
	$form->get_widget('combo_entry_tt_teacher')->set_text("");
	$form->get_widget('combo_entry_tt_subject')->set_text("");
	$form->get_widget('combo_entry_tt_classroom')->set_text("");
	$form->get_widget('combo_entry_tt_class')->set_text("");
	$form->get_widget('entry_tt_day')->set_text("");
	$form->get_widget('entry_tt_period')->set_text("");
}

sub on_radiobutton_tt_both_toggled { &switch_tt_lists($_[0],'both'); }
sub on_radiobutton_tt_text_toggled { &switch_tt_lists($_[0],'editor_text'); }
sub on_radiobutton_tt_graphic_toggled { &switch_tt_lists($_[0],'tt_lists'); }

sub switch_tt_lists {
	my ($who,$what) = @_;
	my @frames = ('tt_lists','editor_text');
	my $form = &get_form;
	if ($what eq 'both' and $who->get_active) {
		foreach my $frame (@frames) { $form->get_widget("frame_$frame")->show; }
	} else {
	  foreach my $frame (@frames) {
		if ($frame eq $what) {
			if ($who->get_active) { 
				$form->get_widget("frame_$what")->show;
		 	} else { 
				$form->get_widget("frame_$what")->hide;
	 		}	
		} else {
			$form->get_widget("frame_$frame")->hide;
		}
	  }
	}  
} 

sub init_legend {
	my $form = &get_form;
	my $red = new Gtk2::Gdk::Color(65535,0,0);	
	my $white = new Gtk2::Gdk::Color(65535,65535,65535);	
	my $orange = new Gtk2::Gdk::Color(65535,32000,0);	
	my $brown = new Gtk2::Gdk::Color(32000,0,0);	

	$form->get_widget('eventbox_legend_active')->modify_bg('normal',$red);
	$form->get_widget('eventbox_legend_inactive')->modify_bg('normal',$white);
	$form->get_widget('eventbox_legend_tuple')->modify_bg('normal',$orange);
	$form->get_widget('eventbox_legend_unused')->modify_bg('normal',$brown);
}
# ---------

sub on_entry_tt_perweek_changed {
	my $text = $_[0]->get_text;
	my $form = &get_form;
	$form->get_widget('hbox_combinations_setup_perweek')->set('visible' => 1);
	$form->get_widget('hbox_combinations_setup_fixed')->set('visible' => 0);
	$form->get_widget("label_combinations_setup_perweek")->set_markup("<b>$text</b>"); 
}

sub on_entry_tt_day_changed {
	my $day = $_[0]->get_text;
	my $form = &get_form;
	if (!defined $day) { $day = ""; }
	$form->get_widget('hbox_combinations_setup_perweek')->set('visible' => 0);
	$form->get_widget('hbox_combinations_setup_fixed')->set('visible' => 1);
	$form->get_widget("label_combinations_setup_day")->set_markup("<b>$day</b>"); 
	&select_mini_tt;
}

sub on_entry_tt_period_changed {
	my $period = $_[0]->get_text;
	my $form = &get_form;
	if (!defined $period) { $period = ""; }
	$form->get_widget('hbox_combinations_setup_perweek')->set('visible' => 0);
	$form->get_widget('hbox_combinations_setup_fixed')->set('visible' => 1);
	$form->get_widget("label_combinations_setup_period")->set_markup("<b>$period</b>"); 
	&select_mini_tt;	
}

# ----- related lists ------------------------
# these are populated with every combo_change call

sub select_in_combo {
	my ($where) = @_;
	my $form = &get_form;
	my $what;

# get the name
	 	$what = $where->get('name');
	 	$what =~ s/treeview_combinations_//;
	 	chop($what);

# get the entry
	(my $path, my $col) = $where->get_cursor(); 
	if (defined $path) {
	 	my $iter = $where->get_model->get_iter($path);
	 	my $selected = $where->get_model->get($iter,0);	
	 # set the combo
	 	if ($form->get_widget("combo_entry_tt_$what")->get_text eq $selected) {
			$form->get_widget("combo_entry_tt_$what")->set_text(""); 
		 	$form->get_widget("label_combinations_setup_$what")->set_markup(""); 
		} else {
			$form->get_widget("combo_entry_tt_$what")->set_text($selected); 
		 	$form->get_widget("label_combinations_setup_$what")->set_markup("<b>$selected</b>"); 
		}
	}
	&set_related($what);
}
# ------ combo select -----------------------
# these reorder the related lists

sub on_combo_entry_tt_subject_changed { 
	my $form = &get_form;
 	$form->get_widget("label_combinations_setup_subject")->set_markup("<b>".$_[0]->get_text."</b>"); 
}
sub on_combo_entry_tt_teacher_changed { 
	my $form = &get_form;
 	$form->get_widget("label_combinations_setup_teacher")->set_markup("<b>".$_[0]->get_text."</b>"); 
}
sub on_combo_entry_tt_class_changed { 
	my $form = &get_form;
	$form->get_widget("label_combinations_setup_class")->set_markup("<b>".$_[0]->get_text."</b>"); 
}
sub on_combo_entry_tt_classroom_changed { 
 	my $form = &get_form;
	$form->get_widget("label_combinations_setup_classroom")->set_markup("<b>".$_[0]->get_text."</b>"); 
}

sub set_related {
	my ($combo) = @_;
	my ($form,undef,$defined_tt_entries,$uid_tt_entries) = &get_vars;
	$combo = $form->get_widget("combo_entry_tt_$combo");
# types of lists...
	my @lists = ('teacher','subject','class','classroom');
# what: field data
	my $what = $combo->get_text;		
# name: type of list which is selected
	my $name = $combo->get('name');
		$name =~ s/combo_entry_tt_//;

# only if there actually is a value
	if ($what eq "") {
	 	foreach my $l (@lists) {
	 		$form->get_widget("treeview_combinations_$l".'s')->get_selection->unselect_all;			
	 	}	
	} else {
	 	$form->get_widget("label_combinations_setup_$name")->set_markup("<b>".gettext($what)."</b>"); 
	 # unselect the other three treeviews
	 	foreach my $l (@lists) {
	 		if ($l ne $name) {
	 			$form->get_widget("treeview_combinations_$l".'s')->get_selection->unselect_all;
	 		}
	 	}	
	 # global list of linked items to the currently selected	
	 	%linked = ();
	 	%siblings = ();
	 	%all_tt = ();
	 	%tuples = ();
	 	%fixed = ();
	 
	 # setup fixed if results file
	 	while ((my $value, my $key) = each %{$defined_tt_entries}) {
	 		my %temp;	
	 		$temp{'teacher'} = (split/\|\|/,$key)[2];
	 		$temp{'class'} = (split/\|\|/,$key)[0];
	 		$temp{'subject'} = (split/\|\|/,$key)[1];
	 		$temp{'classroom'} = (split/\|\|/,$value)[0];
	 		my $period = (split/\|\|/,$value)[1];
	 		my $day = (split/\|\|/,$value)[2];
	 		if ((defined $temp{$name}) and ($temp{$name} eq $what)) {
	 			$fixed{$day.'_'.$period} = 1;
	 		}
	 	}	
	 
	 # for teachers, mangle the subjects and vice-versa
	 	if (($name eq 'teacher') or ($name eq 'subject')) {
	 	 	my $tw = $form->get_widget("treeview_teachers");	 	
	 	 	$tw->get_model->foreach(sub {	
	 	  	 	my (undef,undef,$child_iter) = @_; 	 	 		
	 	 		my %temp;
	 			($temp{'teacher'},$temp{'subject'},$temp{'rests'}) = $tw->get_model->get($child_iter,0,1,2);
	 		# check for tuple	
				if ((defined $temp{'teacher'}) and (defined $temp{'subject'}) and ($temp{$name} eq $what)) {
	 		   	foreach my $l ('teacher','subject') {
	 					if ($l ne $name) {	# set it as a linked item, so that it will get orange
	 						$tuples{$temp{$l}} = 1;
	 					}
	 				}
	 			}
			# check for capability-places
				if ((defined $temp{'rests'}) and 
						(defined $temp{$name}) and 
						($what eq $temp{$name})) {
	 	 	 		foreach my $type (split/\;/,$temp{'rests'}) {
	 	 	 			my @rests = split/\:/,$type;
	 	 	 			my $rest_type = $rests[0];
	 	 	 			if ((defined $rest_type) and ($rest_type eq 'capability-place')) { 
	 	 	 				foreach my $rest_val (split/\,/,$rests[1]) {
	 	 	 					my @rooms = &get_classroom($rest_val,$rest_type);
	 	 	 					foreach my $room (@rooms) {
	 	 	 						$tuples{$room} = 1;
	 	 	 					}
	 	 	 				}
	 	 	 			}
	 	 	 		}
				}
				return 0;
	 		});
	 	}
	 
	 # iterate over complete tt definitions tree	
	 	my $tw = $form->get_widget("treeview_tt");	 	
	 	$tw->get_model->foreach(sub {	
	  	 	my (undef,undef,$child_iter) = @_; 	 	 		
	  	 	my %temp;
	 		($temp{'class'},$temp{'subject'},
	 			$temp{'teacher'},$temp{'perweek'},
	 				$temp{'classroom'},$temp{'period'},
	 					$temp{'day'}) = $tw->get_model->get($child_iter,0,1,2,3,4,5,6,7);
	 		
	 # recognize every set up entity		
	 		foreach my $l (@lists) {
	 			if (defined $temp{$l}) {
	 				$all_tt{$temp{$l}} = 1;
	 			}
	 		}
	 
	 # if the entry coresponds to the one we are setting (type and value)
	 		if ((defined $temp{$name}) and ($what eq $temp{$name})) {
	 	# check if fixed
	 			if ((defined $temp{'day'}) and (defined $temp{'period'}) and ($temp{'day'} ne "") and ($temp{'period'} ne "")) {
	 				$form->get_widget('entry_tt_day')->set_text($temp{'day'});
	 				$form->get_widget('entry_tt_period')->set_text($temp{'period'});
	 				$fixed{$temp{'day'}.'_'.$temp{'period'}} = 1;
	 			}
	 		   foreach my $l (@lists) {
	 	# reorder the other three lists...
	 				if ($l ne $name) {	
	 		# if this field is set in the tt definition
	 		# set it as a linked item, so that it will get red, and set the perweek
	 					if (defined $temp{$l}) { &count_core(\%temp,$l); }
	 		# add its perweek to the linked also
	 				} else { &count_core(\%temp,$l); }
	 			}
	 	# siblings
	 		# add every entities of the same kind perweek to the linked also
	 		} elsif ((defined $temp{$name}) and ($what ne $temp{$name})) {
	 			&count_core(\%temp,$name,1);			
	 		}
	 		return 0; 
	 	} );	
	  	foreach my $l (@lists) { $form->get_widget("treeview_combinations_$l".'s')->queue_draw; }
	}
	&mini_tt($what,$name);
}

sub count_core {
	my ($temp,$l,$s) = @_;
	my $meny;
	if ($s) { $meny = $siblings{${$temp}{$l}};
	} else { $meny = $linked{${$temp}{$l}}; }
	if (!defined $meny) { $meny = 0; }
		if ((!defined ${$temp}{'perweek'}) or (${$temp}{'perweek'} eq "")) { 
	# if it doesn't exist, check for fixed period	
	 		if ((defined ${$temp}{'day'}) and (defined ${$temp}{'period'}) and (defined ${$temp}{'classroom'})) {
				${$temp}{'perweek'} = 1; 
	 		} else {
	 			${$temp}{'perweek'} = 0; 
	 		}
		}
	if (defined $s) { $siblings{${$temp}{$l}} = ${$temp}{'perweek'} + $meny;
	} else { $linked{${$temp}{$l}} = ${$temp}{'perweek'} + $meny; }
}

sub sort_by_color {
	 my ($liststore, $itera, $iterb) = @_;
	 my $a = $liststore->get($itera, 0);
	 my $b = $liststore->get($iterb, 0);
# stupid, but effective:
# if only a is linked, (thus colored), move it ahead
# if only b is linked, move it ahead
# otherwise return string comparison	 
 	 if ((defined $linked{$a}) and (defined $linked{$b})) { 
		return $a cmp $b;
	 } elsif (defined $linked{$a}) { return -1;
	 }	elsif (defined $linked{$b}) { return 1;
	 } elsif (defined $tuples{$a}) { return -1;
	 }	elsif (defined $tuples{$b}) { return 1;
	 } elsif (defined $all_tt{$a}) { return -1;
	 }	elsif (defined $all_tt{$b}) { return 1;
	 } else { 
	 	return $a cmp $b;
	 }
}
sub sort_by_number {
	my ($liststore, $itera, $iterb) = @_;
	my $a = $liststore->get($itera, 0);
	my $b = $liststore->get($iterb, 0);
	if ((defined $linked{$a}) and (defined $linked{$b})) {
		return $linked{$a} <=> $linked{$b};
	} elsif (defined $linked{$a}) {
		return -1;
	} elsif (defined $linked{$b}) {
		return 1;
	} elsif ((defined $siblings{$a}) and (defined $siblings{$b})) {
		return $siblings{$a} <=> $siblings{$b};
	} elsif (defined $siblings{$a}) {
		return -1;
	} elsif (defined $siblings{$b}) {
		return 1;
	} else {
		return 0;
	}
}
sub do_something_cool {
	my ($model, $iter) = @_;
	my $text = $model->get($iter,0);
# default color is brown, for all unused entries
# if this is a setup subject, it shall be orange
# if it is alredy in the tt, then it is not completely forgoten
# if it is linked to the selected one, than it is red
# if it is a sibling (same type) of the selected one, do nothing...
	my $color = 'brown';
	my $fg = 'white';
	if ($all_tt{$text}) { $color = 'white'; }
	if ($tuples{$text}) { $color = 'orange'; }
	if ($linked{$text}) { $color = 'red'; }
	if ($siblings{$text}) { }
	if ($color ne 'brown') { $fg = 'black'; }
	return ($text, $color,$fg);
}

sub do_something_cool_perweek {
	my ($model, $iter) = @_;
	my $tex = $model->get($iter,0);
	my $color = 'brown';
	my $fg = 'white';
	my $text = "";
	if ($all_tt{$tex}) { $color = 'white'; }	
	if ($tuples{$tex}) { $color = 'orange'; }	
	if (defined $linked{$tex}) {
		$color = 'red';
		$text = $linked{$tex};
	}
	if (defined $siblings{$tex}) {
		$text = $siblings{$tex};
	}
	# $model->set($iter,1,$text);
	if ($color ne 'brown') { $fg = 'black'; }
	return ($text, $color,$fg);
}
# ---------- hadlers for all 4 treeview_selections...............
sub on_treeview_combinations_cursor_changed { &on_button_toolbar_cancel_clicked;}
sub on_treeview_combinations_button_release_event { 
	my ($where, $now) = @_;
	&select_in_combo($where); 
	if (($_[1]->button == 3)) { 
			my $what = $where->get_name;
				$what =~ s/treeview_//;
				chop($what);
		&draw_context_menu ($where,$now,$what); 
	} 
}
sub on_treeview_combinations_key_press_event { 
	my ($where, $now) = @_;
	if ($now->keyval == $Gtk2::Gdk::Keysyms{Delete}) {
		my @paths = $where->get_selection->get_selected_rows;
		if ($paths[0]) { 
			my $what = $where->get_name;
				$what =~ s/treeview_//;
				chop($what);
			&del_row($what); 
		}
	}
}
# ----------------------------
sub select_mini_tt {
	my $form = &get_form;
	my $day = $form->get_widget('entry_tt_day')->get_text; 
	my $period = $form->get_widget('entry_tt_period')->get_text; 
	my $select = $day.'_'.$period; 
	my $red = new Gtk2::Gdk::Color(65535,0,0);				# fixed 
	my $white = new Gtk2::Gdk::Color(65535,65535,65535);
	my $yellow = new Gtk2::Gdk::Color(65535,65535,0);		# cursor
	my $oldtable = $form->get_widget('alignment_mini_timetable')->get_child;	

	if ((defined $tt_select) and ($tt_select->get_name eq $select)) {
		$tt_select->modify_bg('normal',$white);
		$form->get_widget('entry_tt_day')->set_text("");
		$form->get_widget('entry_tt_period')->set_text("");
		$tt_select = undef;
	} elsif (defined $oldtable) {
		foreach my $cell ($oldtable->get_children) {
			my $name = $cell->get_name;
			if ($name eq $select) {
				$cell->modify_bg('normal',$yellow);
				$tt_select = $cell;
			} elsif ($fixed{$name}) {
				$cell->modify_bg('normal',$red);
			} else {
				$cell->modify_bg('normal',$white);
			}
		}
	}
}

sub mini_tt {
	my ($who,$what) = @_;
	my $form = &get_form;

	my $label = $form->get_widget('label_mini_tt_who');
	if ((defined $who) and (defined $what) and ($who ne "") and ($what ne "")) { 
		$label->set_markup(gettext($what).": <b>".gettext($who)."</b>");
		$label->set('visible' => 1);
	} else { 
		$label->set_markup(""); 
		$label->set('visible' => 0);
	}

	my $days = $form->get_widget('entry_days')->get_text;
	my $periods = $form->get_widget('entry_periods')->get_text;

# re-initialize the timeTable if needed
	my $oldtable = $form->get_widget('alignment_mini_timetable')->get_child;
	if (defined $oldtable) { 
		if (($oldtable->get('n-columns') ne ($days + 1)) or ($oldtable->get('n-rows') ne ($periods + 1))) {
			$oldtable->destroy;
			$tt_select = undef;
			&build_mini_table;	
		} 
	} else { &build_mini_table; }

# re paint it anyway
	&select_mini_tt;
}

sub build_mini_table {
	my $form = &get_form;
	my $day = $form->get_widget('entry_tt_day')->get_text; 
	my $period = $form->get_widget('entry_tt_period')->get_text; 
	my $select = $day.'_'.$period; 
	my $days = $form->get_widget('entry_days')->get_text;
	my $periods = $form->get_widget('entry_periods')->get_text;
	my $red = new Gtk2::Gdk::Color(65535,0,0);	
	my $white = new Gtk2::Gdk::Color(65535,65535,65535);
	my $yellow = new Gtk2::Gdk::Color(65535,65535,0);	

		my $ttable = new Gtk2::Table(($periods + 1),$days,0);
	 	$form->get_widget('alignment_mini_timetable')->add($ttable);
	 	$ttable->set_row_spacings(1);
	 	$ttable->set_col_spacings(1);
	 	$ttable->set_name("minittable");
	 	$ttable->show; 

	 	my %cells;
	 # title row
	 	for (my $i = 1; $i <= $days; $i++) {
	 		my $cell = new Gtk2::Label();
	 		$ttable->attach_defaults($cell,$i,($i + 1),0,1);
	 		$cell->set_use_markup(1);
			$cell->set_markup("<b>".gettext("Day").$i."</b>");	
	 		$cell->show;
	 	}
	 # periods column
	 	for (my $i = 1; $i <= $periods; $i++) {
	 		my $cel = new Gtk2::Label();
	 		$ttable->attach_defaults($cel,0,1,$i,($i + 1));
	 		$cel->set_use_markup(1);
	 		$cel->set_markup("<b>$i.</b>");	
	 		$cel->show;
	 	# all other cells 
	 		for (my $k = 1; $k <= $days; $k++) {
	 			my $box = new Gtk2::EventBox();
	 			my $cell = new Gtk2::Label();					
	 				$box->add($cell);	
	 			my $name = ($k - 1).'_'.($i - 1);		# celice vsebine tabele imajo imena od 0 dalje...
	  			$box->set_name($name);
	 			$ttable->attach_defaults($box,$k,($k + 1),$i,($i + 1));			
	 			$box->show;
	 			$cell->show;
				$box->signal_connect('button_release_event' => sub { 
 	 										my ($me) = @_;
											my $name = $me->get_name;
 	 										my ($day,$period) = split/_/,$name;
											
											my $oldday = $form->get_widget('entry_tt_day')->get_text;
	 										my $oldper = $form->get_widget('entry_tt_period')->get_text;
											
											if (($oldday eq $day) and ($oldper eq $period)) {
												$form->get_widget('entry_tt_day')->set_text("");
		 										$form->get_widget('entry_tt_period')->set_text("");												
											} else {
												$form->get_widget('entry_tt_day')->set_text($day);
		 										$form->get_widget('entry_tt_period')->set_text($period);
											}
	 									});
	 		}
	 	}
	
}

sub on_togglebutton_tt_mini_toggled {
	my ($me) = @_;
	my $form = &get_form;
	if ($me->get_active) { 
		$form->get_widget('window_mini_tt')->show;
		$form->get_widget('window_mini_tt')->set_keep_above(1);
	} else { $form->get_widget('window_mini_tt')->hide;
	}
}
sub on_window_mini_tt_delete_event {
	my $form = &get_form;
	$form->get_widget('togglebutton_tt_mini')->set_active(0);
	return 1;
}

# ------------------------------------------

return 1;
