#     G-Tablix, graphical user interface for Tablix
#     Copyright (C) 2004,2005 Bostjan Spetic
# 
#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
# 
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
# 
#     You should have received a copy of the GNU General Public License
#     along with this program; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# author: Bostjan Spetic, igzebedze@cyberpipe.org
# module for handling settings
# 26.3.2005

use strict;

# allow user day and period names...
my %settings;
my %days;
my %periods;
my %day_names = ( 0 => gettext('Monday'),
		1 => gettext('Tuesday'),
		2 => gettext('Wednesday'),
		3 => gettext('Thursday'),
		4 => gettext('Friday'),
		5 => gettext('Saturday'),
		6 => gettext('Sunday')
		);
my %recent;

sub get_settings { return \%settings; }

sub push_recent {
	my ($file) = @_;
	if (-f $file) {	
	 if (!$recent{$file}) {
		$recent{$file} = 1;
		my $form = &get_form;
		my $item = new Gtk2::MenuItem($file);
		$form->get_widget('recent1_menu')->append($item);
		$item->signal_connect('activate' => \&open_recent);
		$item->show;
	 }
	}
}

sub get_external {
	my ($what) = @_;
	my $form = &get_form;
	my $table = $form->get_widget('table_set_external');
	foreach my $widget ($table->get_children) {
		if ($widget->get_name eq "entry_$what") {
			return $widget->get_text;
		}
	}
}
sub get_day_name { 
	my ($what) = @_;
	my $form = &get_form;
	my $set = $form->get_widget('comboentry_set_days')->get_text;
	return $days{$set}{$what};
}
sub get_period_name { 	
	my ($what) = @_;
	my $form = &get_form;
	my $set = $form->get_widget('comboentry_set_periods')->get_text;
	return $periods{$set}{$what};
}

# load settings file
sub load_settings {
	my $settingsfile = '~/.gtablixrc';
	if (-R $settingsfile) { return ''; }	# for first runs...
	my @sections = split/--- /,readpipe("more $settingsfile");
	foreach my $sec (@sections) {
		my @lines = split/\n/,$sec;
		my $sec = shift(@lines);						# extract section name
		foreach my $line (@lines) {
	 		if ($line eq "") { next; }						# emtpy lines
	 		if (substr($line,0,1) eq "#") { next; }		# comments
	 		my @elm = split/\=/,$line;
	 		$settings{$sec}{$elm[0]} = $elm[1];
		}
	}
#	&debug_tree(\%settings,'settings');
}
# ---------------------------------------------------
# settings window

sub prep_settings {
	my $form = &get_form;
	my $checks = &get_checks;
# external progs table
	my $table = $form->get_widget('table_set_external');
	my $row = 0;
	foreach my $prog (@{$checks}) {
		my $label = new Gtk2::Label($prog.':');
			$table->attach_defaults($label,0,1,$row,($row + 1));
			$label->set_justify('right');
			
		my $entry = new Gtk2::Entry();
			$table->attach_defaults($entry,1,2,$row,($row + 1));
			$entry->set_name("entry_$prog");

# load user setting if exists
		if (defined $settings{'externals'}{$prog}) {
			$entry->set_text($settings{'externals'}{$prog});
		}

		$row++;
	}	
	$table->show_all;

# day and period names....
	my %day_sets;
	while (my ($key, $value) = each (%{$settings{'days'}})) {
		if (!defined $value) { $value = ""; }
		my @name = split/\_/,$key;
		if ($key eq 'custom_names') { 
			$form->get_widget('checkbutton_set_days')->set_active($value); 
		} elsif ($key eq 'number') {
#			$form->get_widget('entry_days')->set_value($value);
		} elsif ($key =~ /length/) {
		} else { 
			$days{$name[0]}{$name[1]} = $value; 
			if ((!defined $day_sets{$name[0]}) or ($day_sets{$name[0]} < $name[1])) {
				$day_sets{$name[0]} = $name[1];
			}
		}
	}
 # add default preset
	for (my $i = 0; $i < $form->get_widget('entry_days')->get_text; $i++) {
			$days{'default'}{$i} = $i; 
			$day_sets{'default'} = $i;		
	}
 # add locale preset
	for (my $i = 0; $i < 8; $i++) {
			$days{'locale'}{$i} = $day_names{$i}; 
			$day_sets{'locale'} = $i;		
	}
 # update combos	
	foreach my $text (keys(%day_sets)) {
		$form->get_widget('combobox_preset_day')->append_text($text);
		$days{$text}{'length'} = $day_sets{$text};
	}
	$form->get_widget('combo_set_days')->set_popdown_strings(keys(%day_sets));

# ---
	
	my %period_sets;
	while (my ($key, $value) = each (%{$settings{'periods'}})) {
		if (!defined $value) { $value = ""; }
		my @name = split/\_/,$key;
		if ($key eq 'custom_names') { 
			$form->get_widget('checkbutton_set_periods')->set_active($value); 
		} elsif ($key eq 'number') {
#			$form->get_widget('entry_periods')->set_value($value);
		} elsif ($key =~ /length/) {
		} else {	
			$periods{$name[0]}{$name[1]} = $value; 
			if ((!defined $period_sets{$name[0]}) or ($period_sets{$name[0]} < $name[1])) {
				$period_sets{$name[0]} = $name[1];
			}
		}
	}	
 # add default preset
	for (my $i = 0; $i < $form->get_widget('entry_periods')->get_text; $i++) {
			$periods{'default'}{$i} = $i; 
			$period_sets{'default'} = $i;		
	}
 # add locale preset
	for (my $i = 0; $i < 14; $i++) {
			$periods{'locale'}{$i} = $i.'.'; 
			$period_sets{'locale'} = $i;		
	}
 # update combos	
	foreach my $text (keys(%period_sets)) {
		$form->get_widget('combobox_preset_period')->append_text($text);
		$periods{$text}{'length'} = $period_sets{$text};
	}
	$form->get_widget('combo_set_periods')->set_popdown_strings(keys(%period_sets));
	
# gtablix behaviour....
	while (my ($key, $value) = each (%{$settings{'gtablix'}})) {
		if (!defined $value) { $value = ""; }
		if ($key eq 'remember_positions') { $form->get_widget('checkbutton_set_positions')->set_active($value);}
		elsif ($key eq 'wizard_mode') { $form->get_widget('togglebutton_wizard')->set_active($value); }
		elsif ($key eq 'active_tab') { 
			if ($form->get_widget('togglebutton_wizard')->get_active) {
				$form->get_widget('togglebutton_wizard')->set_active(0);
				$form->get_widget('notebook1')->set_current_page($value); 
				$form->get_widget('togglebutton_wizard')->set_active(1);
			} else {
				$form->get_widget('notebook1')->set_current_page($value); 
			}
		}
		elsif ($key =~ /recent_/) {
			&push_recent ($value);
		}
		elsif ($key eq 'hide_missing') { $form->get_widget('checkbutton_hide_missing')->set_active($value); }
		elsif ($key eq 'temp_dir') { $form->get_widget('entry_temp')->set_text($value); }
		elsif ($key eq 'fontscale') { $form->get_widget('spinbutton_set_fontscale')->set_value($value / 100); }
		elsif ($key eq 'recent') { $form->get_widget('spinbutton_set_recent')->set_value($value); }
		elsif ($key eq 'lang') { $form->get_widget('comboentry_set_lang')->set_text($value); }
		elsif ($key eq 'mod_dir') { $form->get_widget('entry_modpath')->set_text($value); }
		elsif ($key eq 'impossible') { $form->get_widget('entry_impossible')->set_text($value); }
		elsif ($key eq 'additive') { $form->get_widget('checkbutton_additive')->set_active($value); }
		elsif ($key eq 'double_period') { $form->get_widget('checkbutton_double_period')->set_active($value); }
		elsif ($key eq 'tt_related') { $form->get_widget('radiobutton_tt_graphic')->set_active($value); }
		elsif ($key eq 'tt_list') { $form->get_widget('radiobutton_tt_text')->set_active($value); }
		elsif ($key eq 'tt_both') { $form->get_widget('radiobutton_tt_both')->set_active($value); }
		elsif ($key eq 'tablix_n') { $form->get_widget('spinbutton_tablix_n')->set_value($value); }
		elsif ($key eq 'tablix_l') { $form->get_widget('spinbutton_tablix_l')->set_value($value); }
		elsif ($key eq 'tablix_t') { $form->get_widget('spinbutton_tablix_t')->set_value($value); }
		elsif ($key eq 'tablix_r') { $form->get_widget('checkbutton_tablix_resume')->set_active($value); }
		elsif ($key eq 'plot_scale') { $form->get_widget('spinbutton_plot_scale')->set_value($value); }
		elsif ($key eq 'plot_res') { $form->get_widget('spinbutton_plot_res')->set_value($value); }
		elsif ($key eq 'plot_style') { $form->get_widget('entry_plot_style')->set_text($value); }
		elsif ($key eq 'ouput_type') { $form->get_widget('combo_entry_tt_result')->set_text($value); }
		elsif ($key eq 'rename_ask') { $form->get_widget('radiobutton_set_rename_ask')->set_active($value); }
		elsif ($key eq 'rename_single') { $form->get_widget('radiobutton_set_rename_single')->set_active($value); }
		elsif ($key eq 'rename_complete') { $form->get_widget('radiobutton_set_rename_complete')->set_active($value); }
		elsif ($key eq 'delete_ask') { $form->get_widget('radiobutton_set_delete_ask')->set_active($value); }
		elsif ($key eq 'delete_single') { $form->get_widget('radiobutton_set_delete_single')->set_active($value); }
		elsif ($key eq 'delete_complete') { $form->get_widget('radiobutton_set_delete_complete')->set_active($value); }
		elsif ($key eq 'name') { 
			$form->get_widget('entry_set_name')->set_text($value); 
			$form->get_widget('entry_author')->set_text($value); 
		}
		elsif ($key eq 'school') { 
			$form->get_widget('entry_set_school')->set_text($value); 
			$form->get_widget('entry_title')->set_text($value); 
		}
		elsif (($key =~ /window_/) and ($settings{'gtablix'}{'remember_positions'})) {
			my @what = split/\_/,$key;
		# ugly...
			if ($what[1] eq 'mini') {
				$what[1] = "mini_tt";
				$what[2] = $what[3];
			}
			if ($what[2] eq 'position') {
				$form->get_widget('window_'.$what[1])->move(split/\_/,$value);
			} elsif ($what[2] eq 'size') {
				$form->get_widget('window_'.$what[1])->resize(split/\_/,$value);
			} elsif ($what[2] eq 'visible') {
				$form->get_widget('window_'.$what[1])->set('visible' => $value);
				if ($what[1] ne 'main') { 
					$form->get_widget('window_'.$what[1])->set_keep_above(1);
				}
			}
		}
	}
}
sub on_window_settings_delete_event {
	&on_button_set_ok_clicked;
	return 1;
}
sub on_button_set_ok_clicked { &save_settings; }
sub on_button_set_cancel_clicked {
	my $form = &get_form;
	$form->get_widget('window_settings')->set('visible' => 0);	
}

# -------------------------  for saving...... -----------------------------

sub save_settings {
	my $form = &get_form;
	$form->get_widget('window_settings')->set('visible' => 0);
	&gather_settings;
# save settings
	my $file = readpipe('echo $HOME');
		chop $file;
	if (-e "$file/.gtablixrc") { system ("mv -f $file/.gtablixrc $file/.gtablixrc.bak"); }
	open (RC,">$file/.gtablixrc");
	foreach my $sec (keys(%settings)) {
		print RC "--- $sec\n";
		while (my ($key, $value) = each (%{$settings{$sec}})) {
			if (!defined $value) { $value = ""; }
			print RC "$key\=$value\n";
		}
	}
	close RC;	
}

sub gather_settings {
	my $form = &get_form;
	%settings = ();
# gtablix tab
	$settings{'gtablix'}{'remember_positions'} = $form->get_widget('checkbutton_set_positions')->get_active;
	if ($form->get_widget('checkbutton_set_positions')->get_active) {
		my @windows = ('main', 'mini_tt', 'rests', 'settings');
		foreach my $window (@windows) {
			$settings{'gtablix'}{'window_'.$window.'_visible'} = $form->get_widget('window_'.$window)->get('visible');
			my @pos = $form->get_widget('window_'.$window)->get_position;
			$settings{'gtablix'}{'window_'.$window.'_position'} = join('_',@pos);	
			my @size = $form->get_widget('window_'.$window)->get_size;
			$settings{'gtablix'}{'window_'.$window.'_size'} = join('_',@size);	
		}
		$settings{'gtablix'}{'wizard_mode'} = $form->get_widget('togglebutton_wizard')->get_active;
		$settings{'gtablix'}{'active_tab'} = $form->get_widget('notebook1')->get_current_page;
	}
	$settings{'gtablix'}{'hide_missing'} = $form->get_widget('checkbutton_hide_missing')->get_active;
	$settings{'gtablix'}{'temp_dir'} = $form->get_widget('entry_temp')->get_text;
	$settings{'gtablix'}{'fontscale'} = int($form->get_widget('spinbutton_set_fontscale')->get_value * 100);
	$settings{'gtablix'}{'recent'} = $form->get_widget('spinbutton_set_recent')->get_value;
	$settings{'gtablix'}{'lang'} = $form->get_widget('comboentry_set_lang')->get_text;
	$settings{'gtablix'}{'name'} = $form->get_widget('entry_set_name')->get_text;
	$settings{'gtablix'}{'school'} = $form->get_widget('entry_set_school')->get_text;
	$settings{'gtablix'}{'mod_dir'} = $form->get_widget('entry_modpath')->get_text;
	$settings{'gtablix'}{'impossible'} = $form->get_widget('entry_impossible')->get_text;
	$settings{'gtablix'}{'additive'} = $form->get_widget('checkbutton_additive')->get_active;
	$settings{'gtablix'}{'double_period'} = $form->get_widget('checkbutton_double_period')->get_active;
	$settings{'gtablix'}{'tt_related'} = $form->get_widget('radiobutton_tt_graphic')->get_active;
	$settings{'gtablix'}{'tt_list'} = $form->get_widget('radiobutton_tt_text')->get_active;
	$settings{'gtablix'}{'tt_both'} = $form->get_widget('radiobutton_tt_both')->get_active;
	$settings{'gtablix'}{'tablix_l'} = $form->get_widget('spinbutton_tablix_l')->get_value;
	$settings{'gtablix'}{'tablix_n'} = $form->get_widget('spinbutton_tablix_n')->get_value;
	$settings{'gtablix'}{'tablix_t'} = $form->get_widget('spinbutton_tablix_t')->get_value;
	$settings{'gtablix'}{'tablix_r'} = $form->get_widget('checkbutton_tablix_resume')->get_active;
	$settings{'gtablix'}{'plot_res'} = $form->get_widget('spinbutton_plot_res')->get_value;
	$settings{'gtablix'}{'plot_scale'} = $form->get_widget('spinbutton_plot_scale')->get_value;
	$settings{'gtablix'}{'plot_style'} = $form->get_widget('entry_plot_style')->get_text;
	$settings{'gtablix'}{'output_type'} = $form->get_widget('combo_entry_tt_exports')->get_text;
	$settings{'gtablix'}{'rename_ask'} = $form->get_widget('radiobutton_set_rename_ask')->get_active;
	$settings{'gtablix'}{'rename_single'} = $form->get_widget('radiobutton_set_rename_single')->get_active;
	$settings{'gtablix'}{'rename_complete'} = $form->get_widget('radiobutton_set_rename_complete')->get_active;
	$settings{'gtablix'}{'delete_ask'} = $form->get_widget('radiobutton_set_delete_ask')->get_active;
	$settings{'gtablix'}{'delete_single'} = $form->get_widget('radiobutton_set_delete_single')->get_active;
	$settings{'gtablix'}{'delete_complete'} = $form->get_widget('radiobutton_set_delete_complete')->get_active;

# recent menu
	my $filename = (split/ - /,($form->get_widget('window_main')->get_title))[1];

# add currently open one...
#	$settings{'gtablix'}{'recent_0'} = $filename;

# and the alredy in the list ones...
	for (my $i = 0; $i < $form->get_widget('spinbutton_set_recent')->get_value; $i++) {
		my $file = (keys(%recent))[$i];
		$settings{'gtablix'}{'recent_'.$i} = $file; 
	}

# days and period names
	$settings{'days'}{'custom_names'} = $form->get_widget('checkbutton_set_days')->get_active;
	$settings{'days'}{'number'} = $form->get_widget('entry_days')->get_text;	
	my $table = $form->get_widget('table_set_days');
	my @presets = $form->get_widget('combo_set_days')->list->get_children;
	foreach my $set (@presets) {
		$set = $set->get_child->get_text;
		while ((my $key, my $value) = each (%{$days{$set}})) {
			$settings{'days'}{$set.'_'.$key} = $value;
		}
	}

	$settings{'periods'}{'custom_names'} = $form->get_widget('checkbutton_set_periods')->get_active;
	$settings{'periods'}{'number'} = $form->get_widget('entry_periods')->get_text;	
	$table = $form->get_widget('table_set_periods');
	@presets = $form->get_widget('combo_set_periods')->list->get_children;

	foreach my $set (@presets) {
		$set = $set->get_child->get_text;
		while ((my $key, my $value) = each (%{$periods{$set}})) {
			$settings{'periods'}{$set.'_'.$key} = $value;
		}
	}

# external programs
	$table = $form->get_widget('table_set_external');
	foreach my $cell ($table->get_children) {
		if ($cell->get_name =~ /entry_(.*)/) {
			if (defined $1) {
				my $app = $1;
				$settings{'externals'}{$app} = $cell->get_text;
			}
		}
	}
}
# -----------------------------------------------------------------------
sub on_button_set_default_clicked {
	my $form = &get_form;
	my $table = $form->get_widget('table_set_external');
	foreach my $cell ($table->get_children) {
		if ($cell->get_name =~ /entry_/) {
			$cell->set_text("");
		}
	}
	$settings{'externals'} = ();
	&check_deps(1);
}
sub write_setting {
	my ($app, $path) = @_;
	if (!defined $path) { $path = ""; }
	my $form = &get_form;
	my $table = $form->get_widget('table_set_external');

# if user has preference then use it
	my $default = $settings{'externals'}{$app};
	if ((defined $default) and ($default ne $path)) {
		return 0;
	} else {
	 	foreach my $cell ($table->get_children) {
	 		if ($cell->get_name eq "entry_$app") {
				if ($cell->get_text eq "") {
	 				$cell->set_text($path);
	 			}
				$settings{'externals'}{$app} = $cell->get_text;		
	 		}
	 	}
	}
}
sub on_checkbutton_set_periods_toggled {
	my $me = shift;
	&get_form->get_widget('frame_set_periods')->set('sensitive'  => $me->get_active);
	if ($me->get_active) {

	} else {
	
	}
}
sub on_checkbutton_set_days_toggled {
	my $me = shift;
	&get_form->get_widget('frame_set_days')->set('sensitive'  => $me->get_active);
	if ($me->get_active) {
	
	} else {
	
	}
}
sub on_comboentry_set_days_activate {
	my $form = &get_form;
	my $set = $form->get_widget('comboentry_set_days')->get_text;
	my $table = $form->get_widget('table_set_days');
	foreach my $cell ($table->get_children) {
		if ($cell->get_name =~ /entry_/) {
			my $row = $table->child_get($cell,'top_attach');
 			my $text = $cell->get_text;
			if ($text ne "") {
				$days{$set}{$row} = $text;
			}
		}
	}
	my %day;
	foreach my $key (keys(%days)) { $day{$key} = 1; }
	$form->get_widget('combo_set_days')->set_popdown_strings(keys(%day));
}
sub on_comboentry_set_periods_activate {
	my $form = &get_form;
	my $set = $form->get_widget('comboentry_set_periods')->get_text;
	my $table = $form->get_widget('table_set_periods');
	foreach my $cell ($table->get_children) {
		if ($cell->get_name =~ /entry_/) {
			my $row = $table->child_get($cell,'top_attach');
 			my $text = $cell->get_text;
			if ($text ne "") {
				$periods{$set}{$row} = $text;
			}
		}
	}
	my %day;
	foreach my $key (keys(%periods)) { $day{$key} = 1; }
	$form->get_widget('combo_set_periods')->set_popdown_strings(keys(%day));
}
sub on_comboentry_set_days_changed {
	my $form = &get_form;
	my $set = $form->get_widget('comboentry_set_days')->get_text;
 if (defined $days{$set}) {
	my $table = $form->get_widget('table_set_days');	
		foreach my $cell ($table->get_children) {
			if ($cell->get_name =~ /entry_/) {
				my $row = $table->child_get($cell,'top_attach');
 				if (defined $days{$set}{$row}) {
					$cell->set_text($days{$set}{$row});
				} else {
					$cell->set_text("");
				}
			}
		}
	$form->get_widget('entry_days')->set_text($days{$set}{'length'});
 }
}
sub on_comboentry_set_periods_changed {
	my $form = &get_form;
	my $set = $form->get_widget('comboentry_set_periods')->get_text;
 if (defined $periods{$set}) {
	my $table = $form->get_widget('table_set_periods');
		foreach my $cell ($table->get_children) {
			if ($cell->get_name =~ /entry_/) {
				my $row = $table->child_get($cell,'top_attach');
 				if (defined $periods{$set}{$row}) {
 					$cell->set_text($periods{$set}{$row});
				} else {
					$cell->set_text("");
				}
			}
		}
	$form->get_widget('entry_periods')->set_text($periods{$set}{'length'});
 }
}
sub on_button_set_days_clicked { &on_comboentry_set_days_activate; }
sub on_button_set_periods_clicked { &on_comboentry_set_periods_activate; }
sub on_combobox_preset_day_changed {
	my $me = shift;
	my $form = &get_form;
	$form->get_widget('comboentry_set_days')->set_text($me->get_active_text);
}
sub on_combobox_preset_period_changed {
	my $me = shift;
	my $form = &get_form;
	$form->get_widget('comboentry_set_periods')->set_text($me->get_active_text);
}

return 1;
