#     G-Tablix, graphical user interface for Tablix
#     Copyright (C) 2004,2005 Bostjan Spetic
# 
#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
# 
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
# 
#     You should have received a copy of the GNU General Public License
#     along with this program; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# module for importing everything from tablix 2 format
# author: Bostjan Spetic, igzebedze@cyberpipe.org
# 5.5.2005

use strict;

my %t_rests;

sub ad_row {
	my ($what,$resource,$restrictions,$comment,$subject) = @_;
	my $form = &get_form;
	if ($what eq 'room') { $what = "classroom"; }
	my $tv = $form->get_widget('treeview_'.$what.'s')->get_model;

	if ($what eq 'teacher') { 
		if ($restrictions eq "") { $restrictions = $t_rests{$resource}; }
		my $row = &add_to_tree($form,"teachers",$resource,$subject);
		$tv->set($row,0,$resource,1,$subject,2,$restrictions,3,$comment);
		$t_rests{$resource} = $restrictions;
	} else {	 
		my $row = &find_clist_row($what.'s',$resource);
		if (($row eq "new")) {
			if ((defined $resource) and ($resource ne "")) {
				$tv->set($tv->append,0,$resource,1,$restrictions,2,$comment);
			}
 		} else {
			$row = $tv->get_iter_from_string($row);
 			my $s_notes = $tv->get($row,2); 
			$s_notes = "$s_notes,$comment";
 			$s_notes =~ s/^\,//g;
 			$s_notes =~ s/\,$//g; 				
 			$tv->set($row,2,$s_notes);
 		}
	}
}
sub ad_event {
	my ($data) = @_;
	my $form = &get_form;
	my $tv = $form->get_widget('treeview_tt')->get_model;
	my $row = &add_to_tree($form,"tt",${$data}{'class'},${$data}{'name'}); #$class,$title);
	$tv->set($row,
				0,${$data}{'class'},
				1,${$data}{'name'},
				2,${$data}{'teacher'},
				3,${$data}{'repeat'},
				4,${$data}{'room'},
				5,${$data}{'period'},
				6,${$data}{'day'},
				7,${$data}{'restrictions'},
				8,${$data}{'comment'});
}
sub read_rests {	# parses <restriction type="">data</restricion>
	my ($resources) = @_;
	my %restrictions;
	foreach my $restrictions ($resources->getChildNodes) {
		if ($restrictions->nodeName eq "restriction") {
			my $type = &getNamedItem($restrictions,"type");
			my $value;
			if ($restrictions->firstChild) {
				$value = $restrictions->firstChild->data;
			} else {
				$value = 1;
			}
			push (@{$restrictions{$type}},$value);
		}
	}
	return \%restrictions;	
}
sub rest_to_string {	# converts a hash of arays to a string delimited by ; and ,
	my ($rests) = @_;
	my $string = "";
	foreach my $type (keys(%{$rests})) {
		$string = $string."$type:".join(',',@{${$rests}{$type}}).";";
	}
	chop($string);
	return $string;
}
sub read_comment {
	my ($seg) = @_;
	my $comment = "";
	if ($seg->nodeType == 8) { #eq 'COMMENT_NODE') {
		$comment = $seg->data;
		$comment =~ s/\t*//g; 
		$comment =~ s/(  )*//g; 
	}
	return $comment;
}
# ------------------------------------

sub t2resource {	# read in the <resourcetype> tags
	my ($res,$form) = @_; 
	my $what = &getNamedItem($res,"type");
	my $comment;
	foreach my $resources ($res->getChildNodes) {
# notes
		$comment = $comment.read_comment($resources);

# name of resourcetype [teacher,class,room,...]
		my $rname = $resources->nodeName;

# restrictions
		my $restrictions = &read_rests($resources);
			$restrictions = &rest_to_string($restrictions);

# data
		if ($rname eq 'resource') {
			my $resource = &getNamedItem($resources,"name");
			if ($resource ne "") {
 	# write in the teacher's name	 		
				&ad_row ($what,$resource,$restrictions,$comment);
				$comment = "";
			}

		} elsif ($rname eq 'matrix') {
			my $width = &getNamedItem($resources,"width");
			my $height = &getNamedItem($resources,"height");
 	# or write in the time's matrix
			if ($what eq 'time') {
				$form->get_widget('entry_days')->set_value($width);
				$form->get_widget('entry_periods')->set_value($height);
			}			
		} elsif ($rname eq 'linear') {
			my $prefix = &getNamedItem($resources,"name");
			my $from = &getNamedItem($resources,"from");
			my $to = &getNamedItem($resources,"to");
			if ($prefix ne "") {
# 	# write in the classroom's linears
				for (my $i = $from; $i <= $to; $i++){
					$prefix =~ s/\#/$i/;
					&ad_row ($what,$prefix.$i,$restrictions,$comment);
					$comment = "";
				}
			}
		}		
	}
}

sub t2constants {	# read in the <constants>
	my ($consts,$form) = @_; 
	foreach my $type ($consts->getChildNodes) {
		if ($type->getFirstChild) {
			my $name = $type->nodeName;
			if ($name eq 'resourcetype') {
				&t2resource($type,$form);
			}
		}
		$form->get_widget('progressbar_main')->pulse;
		Gtk2->main_iteration;
	}
}

sub t2variables {	# read in the <variables>
	my ($vars,$form) = @_; 
	foreach my $type ($vars->getChildNodes) {
		if ($type->getFirstChild) {
			my $name = $type->nodeName;
			if ($name eq 'resourcetype') {
				&t2resource($type,$form);
			}
		}
		$form->get_widget('progressbar_main')->pulse;
		Gtk2->main_iteration;
	}
}


sub t2events {	# read in the <events>
	my ($events,$form,$results,$defined_entries,$uid_entries) = @_; 
	my $comment;
	foreach my $event ($events->getChildNodes) {
		if ($event->getFirstChild) {
		
# restrictions				
			my $restrictions = &read_rests($event);
				$restrictions = &rest_to_string($restrictions);
# data
			if ($event->nodeName eq 'event') {
				my %data; 
				$data{'restrictions'} = $restrictions;
# TODO: add fixed-day and fixed-period handling		
				$data{'comment'} = $comment;
				$data{'name'} = &getNamedItem($event,"name");
				$data{'repeat'} = &getNamedItem($event,"repeats");
				my $id = &getNamedItem($event,"tupleid");
				if ($id ne "") {
					$data{'name'} = $data{'name'}."_$id";
				}
				foreach my $resources ($event->getChildNodes) {
					my $type = $resources->nodeName;
					if ($type eq 'resource') {
						my $which = &getNamedItem($resources,"name");
						my $types = &getNamedItem($resources,"type");
						$data{$types} = $which;
						if ($types eq 'time') {
							my @time = split/ /,$which;
							$data{'period'} = $time[1];
							$data{'day'} = $time[0];
						} elsif (!$results) {
							&ad_row($types,$which,"","",$data{'name'});	# name is needed for teachers
						}
					}
				}
	# write in the event data
				if ($results) {
					my $fix = $data{'class'}.'||'.$data{'name'}.'||'.$data{'teacher'};
					my $loc = $data{'room'}.'||'.$data{'period'}.'||'.$data{'day'};
					${$uid_entries}{$id} = $fix;
					${$defined_entries}{$loc} = $fix;	
				} else {
					&ad_row('subject',$data{'name'},'','');
					&ad_event(\%data);
					$comment = "";
				}
			}
		} else {
# notes
			$comment = $comment.read_comment($event);
		}
		$form->get_widget('progressbar_main')->pulse;
		Gtk2->main_iteration;
	}
}

# ----------------------------

sub t2days {
	my ($consts,$form,$results) = @_; 
	foreach my $type ($consts->getChildNodes) {
		if ($type->getFirstChild) {
			my $name = $type->nodeName;
			if ($name eq 'resourcetype') {
				foreach my $resources ($type->getChildNodes) {
					my $what = &getNamedItem($type,"type");
					if ($what eq 'time') {
						my $width = &getNamedItem($resources,"width");
						my $height = &getNamedItem($resources,"height");
						return ($width,$height);
					}
				}
			}
		}
	}
}

return 1;
