//*****************************************************************************
//                                 PnlValue.hpp                               *
//                                --------------                              *
//  Description : This class derives from the wxPanel base class. It provides *
//                the functionality for displaying and setting the value of   *
//                floating point variables and can optionally allow the       *
//                setting and processing of units.                            *
//  Started     : 14/09/2004                                                  *
//  Last Update : 20/08/2009                                                  *
//  Copyright   : (C) 2004 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PNLVALUE_HPP
#define PNLVALUE_HPP

// System Includes

#include <iostream>

// wxWindows Library Includes

#include <wx/wx.h>
#include <wx/spinbutt.h>

// Application Includes

#include "TypeDefs.hpp"
#include "utility/SpinCtrl.hpp"
#include "utility/ChoUnits.hpp"
#include "utility/ConvertType.hpp"

// Local Constant Declarations

typedef  wxStaticText  wxLabel;

#define  PNLVALUE_HT  24

//*****************************************************************************

class PnlValue : public wxPanel
{
  private :

    // Flag indicating if units should accommodated
    bool      m_bUseUnits;

    // Display objects
    wxLabel   m_oLblName;   // The static value name
    SpinCtrl  m_oSpnValue;  // Displays the numeric value
    ChoUnits  m_oChoUnits;  // Displayed if the units can change
    wxLabel   m_oLblUnits;  // Displayed if the units do not change

    bool  bTempToDegC( float * pfValue );
    bool  bPhaseToDeg( float * pfValue );

    void  DoLayout( void );

  public :

    PnlValue( void );
   ~PnlValue( );

    bool  bCreate( wxWindow * poWin, wxWindowID oWinID, int iWidth=-1,
                   const wxPoint & roPosn=wxDefaultPosition, bool bUnits=TRUE );
    bool  bIsCreated( void ) { return( GetParent( )!=NULL ? TRUE : FALSE ); }

    bool  bClear( void );

    bool  bSetName     ( const wxString & rosName );
    bool  bSetVarType  ( SpinCtrl::eVarType eVType );
    bool  bSetRange    ( float fMinValue, float fMaxValue );
    bool  bSetIncSz    ( float fMinIncSz, float fMaxIncSz=-1.0 );
    bool  bSetParms    ( float fDefValue, float fMinValue, float fMaxValue,
                         float fMinIncSz=-1.0, float fMaxIncSz=-1.0 );
    bool  bSetValue    ( long   liValue, bool bNoUnits=FALSE );
    bool  bSetValue    ( int     iValue, bool bNoUnits=FALSE )
                          { return( bSetValue( (long)   iValue, bNoUnits ) ); }
    bool  bSetValue    ( double dfValue, bool bNoUnits=FALSE );
    bool  bSetValue    ( float   fValue, bool bNoUnits=FALSE )
                          { return( bSetValue( (double) fValue, bNoUnits ) ); }
    bool  bSetValue    ( const wxString & rosValue, bool bNoUnits=FALSE );
    bool  bSetUnitsType( eUnitsType eUType );
    bool  bSetUnits    ( const wxString & rosUnits );
    bool  bSetDefValue ( float fValue )
                              { return( m_oSpnValue.bSetDefValue( fValue ) ); }
    bool  bSetDefUnits ( const wxString & rosUnits )
                            { return( m_oChoUnits.bSetDefUnits( rosUnits ) ); }

    bool  bShowUnits( bool bEnable );

    const wxString &  rosGetName ( void );
          long         liGetValue( void );
          double       dfGetValue( void );
          int           iGetValue( void ) { return( (int)   liGetValue( ) ); }
          float         fGetValue( void ) { return( (float) dfGetValue( ) ); }
    const wxString &  rosGetValue( void );
    const wxString &  rosGetUnits( void );

    // Event handlers
    void  OnSpnScroll( wxSpinEvent    & roEvtSpn );
    void  OnChoUnits ( wxCommandEvent & roEvtCmd );

    // In order to be able to react to a menu command, it must be given a
    // unique identifier such as a const or an enum.
    enum ePnlItemID
    {
      ID_SPN_VALUE = 0,
      ID_CHO_UNITS,
      ID_LBL_UNITS,

      ID_UNUSED,

      ID_FST = ID_SPN_VALUE,
      ID_LST = ID_LBL_UNITS
    };

    // Leave this as the last line as private access is envoked by macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // PNLVALUE_HPP
