//*****************************************************************************
//                                Component.hpp                               *
//                               ---------------                              *
// Description : This class processes a component definition line from a      *
//               netlist. The line is parsed into it's constituant parts.     *
// Started     : 14/05/2004                                                   *
// Last Update : 06/06/2009                                                   *
// Copyright   : (C) 2004 by M.S.Waters                                       *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef COMPONENT_HPP
#define COMPONENT_HPP

// System Includes

using  namespace  std;

#include <iostream>

// wxWindows Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "TypeDefs.hpp"
#include "utility/ConvertType.hpp"
#include "utility/iStrCmp.h"

// Local Constant Declarations


//*****************************************************************************

struct Component : public wxString
{
  protected :

    wxString  m_osErrMsg;

    virtual  bool  bParseValue ( void ) { return( TRUE ); }
    virtual  bool  bFormatValue( void ) { return( TRUE ); }
    virtual  bool  bValidate   ( void );

    void  GetPorts( void );

  public :

    // The following attributes are the minumum required to define a component
    wxString       m_osName;
    wxArrayString  m_osaNodes;
    wxString       m_osValue;

    // The following attributes are derived from the above attributes
    eCpntType      m_eType;
    wxArrayString  m_osaPorts;   // ??? Not yet implemented

    // Function which provides the Component sorting criterion
    static  int  iCompare( Component ** ppo1, Component ** ppo2 );

              Component( void );
    virtual  ~Component( );

    virtual  bool  bClear  ( void );
             bool  bIsValid( void ) const { return( m_osErrMsg.IsEmpty( ) ); }

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

             bool  bSetString( const wxString & rosCmd    );
             bool  bSetName  ( const wxString & rosName   );
             bool  bSetNodes ( const wxString & rosNodes  );
             bool  bSetValue ( const wxString & rosValue  );
             bool  bSetErrMsg( const wxString & rosErrMsg );

    const wxString & rosGetString   ( void );
    eCpntType          eGetCpntType ( void ) { return( eGetCpntType ( m_osName ) ); }
    const wxString & rosGetNodes    ( void );
    eUnitsType         eGetUnitsType( void ) { return( eGetUnitsType( m_osName ) ); }
    const wxString & rosGetNumValue ( void );
    const wxString & rosGetErrMsg   ( void ) const { return( m_osErrMsg ); }

    // Static helper functions (may be called without instantiating the class)
    static         eCpntType   eGetCpntType ( const wxString & rosName );
    static         eUnitsType  eGetUnitsType( const wxString & rosName );
    static  const  wxString &  rosTrim      ( const wxString & rosDefn );

    wxString  & operator = ( const wxString  & rosCmd );
    Component & operator = ( const Component & roCpnt );

    void  Print( const wxString & rosPrefix=wxT("  ") );
};

//*****************************************************************************
// Define new array type ArrayComponent

WX_DECLARE_OBJARRAY( Component, ArrayComponent );

//*****************************************************************************

#endif // COMPONENT_HPP
