//*****************************************************************************
//                                DlgPrefs.cpp                                *
//                               --------------                               *
//  Started     : 17/10/2006                                                  *
//  Last Update : 18/09/2009                                                  *
//  Copyright   : (C) 2006 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "main/DlgPrefs.hpp"

//*****************************************************************************
// Implement an event table.

BEGIN_EVENT_TABLE( DlgPrefs, wxDialog )

  EVT_BUTTON( ID_BTN_OK,     DlgPrefs::OnBtnOk     )
  EVT_BUTTON( ID_BTN_CANCEL, DlgPrefs::OnBtnCancel )

END_EVENT_TABLE( )

//*****************************************************************************
// Constructor.
//
// Argument List:
//   poWin - A pointer to the dialog parent window

DlgPrefs::DlgPrefs( wxWindow * poWin ) :
                wxDialog( poWin, -1, wxT(""), wxDefaultPosition, wxDefaultSize,
                          wxDEFAULT_DIALOG_STYLE, wxDialogNameStr )
{
  // Get the global configuration object
  m_poCfg = (wxConfig *) wxConfig::Get( );

  // Construct the display objects
  Initialize( );

  // Clear object attributes
  bClear( );
}

//*****************************************************************************
// Destructor.

DlgPrefs::~DlgPrefs( )
{
}

//*****************************************************************************
// Initialize object attributes.

void  DlgPrefs::Initialize( void )
{
  SetTitle( wxT(" Preferences") );

  // Call all the initialization functions
  Create( );
  ToolTips( );

  // Layout the of the display objects
  DoLayout( );
}

//*****************************************************************************
// Create the display objects.

void  DlgPrefs::Create( void )
{
  wxPanel * poPnlPrefs, * poPnl1;

  // Create the preferences panel
  poPnlPrefs = new wxPanel( this );

  // Create the waveform viewer panel and controls
  poPnl1 = new wxPanel( poPnlPrefs );
  m_oLblViewer.Create( poPnl1, ID_UNUSED, wxT("Waveform viewer"),
                       wxDefaultPosition, wxSize( 135, -1 ),
                       wxST_NO_AUTORESIZE );
  m_oChoViewer.Create( poPnl1, ID_CHO_VIEWER, wxDefaultPosition,
                       wxSize( 95, -1 ) );
  m_oChoViewer.Append( wxT("gWave") );
  m_oChoViewer.Append( wxT("Gaw") );
  m_oChoViewer.SetSelection( 0 );
  m_oChoViewer.SetBackgroundColour( poPnl1->GetBackgroundColour( ) );

  // Create the temporary file management strategy panel and controls
  poPnl1 = new wxPanel( poPnlPrefs );
  m_oLblTmpFileMgt.Create( poPnl1, ID_UNUSED, wxT("Temporary files"),
                           wxDefaultPosition, wxSize( 135, -1 ),
                           wxST_NO_AUTORESIZE );
  m_oChoTmpFileMgt.Create( poPnl1, ID_CHO_TMPFILEMGT, wxDefaultPosition,
                           wxSize( 95, -1 ) );
  m_oChoTmpFileMgt.Append( wxT("Delete") );
  m_oChoTmpFileMgt.Append( wxT("Prompt") );
  m_oChoTmpFileMgt.Append( wxT("Keep") );
  m_oChoTmpFileMgt.SetSelection( 0 );

  // Create the PnlValue controls
  m_oPnlMaxLines.bCreate( poPnlPrefs, ID_PNL_MAXLINES, 130, wxDefaultPosition,
                          FALSE );
  m_oPnlMaxLines.bSetName( wxT("Max text ctrl lines") );
  m_oPnlMaxLines.bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlMaxLines.bShowUnits( FALSE );
  m_oPnlMaxLines.bSetParms( TXTCTL_LINESDEF, TXTCTL_LINESMIN, TXTCTL_LINESMAX );

  // Create the tool tips check box
  poPnl1 = new wxPanel( poPnlPrefs );
  m_oCbxToolTips.Create( poPnl1, ID_CBX_TOOLTIPS, wxT("Show tool tips \t\t\t"),
                         wxDefaultPosition, wxSize( -1, PNLVALUE_HT ),
                         wxALIGN_RIGHT );

  // Create the results precision controls
  poPnl1 = new wxPanel( poPnlPrefs );
  m_oLblPrecision.Create( poPnl1, ID_UNUSED, wxT("Result Precision"),
                          wxDefaultPosition, wxSize( 135, -1 ),
                          wxST_NO_AUTORESIZE );
  m_oChoPrecision.Create( poPnl1, ID_CHO_PRECISION, wxDefaultPosition,
                          wxSize( 95, -1 ) );
  m_oChoPrecision.Append( wxT("#.#")     );
  m_oChoPrecision.Append( wxT("#.##")    );
  m_oChoPrecision.Append( wxT("#.###")   );
  m_oChoPrecision.Append( wxT("#.####")  );
  m_oChoPrecision.Append( wxT("#.#####") );
  m_oChoPrecision.SetSelection( 0 );

  // Create the buttons
  poPnl1 = new wxPanel( this );
  m_oBtnOk    .Create( poPnl1, ID_BTN_OK,     wxT("OK") );
  m_oBtnCancel.Create( poPnl1, ID_BTN_CANCEL, wxT("Cancel") );

// (15/10/2008) I suspect that the following just fixes a bug in wxWidgets, the
// back-ground of the parent window isn't inherited by it's children
m_oChoViewer    .GetParent()->SetBackgroundColour( this->GetBackgroundColour() ); // ???
m_oChoTmpFileMgt.GetParent()->SetBackgroundColour( this->GetBackgroundColour() ); // ???
m_oCbxToolTips  .GetParent()->SetBackgroundColour( this->GetBackgroundColour() ); // ???
}

//*****************************************************************************
// Initialize the tool tips.

void  DlgPrefs::ToolTips( void )
{
  wxString  os1;

  os1 = wxT("Select the waveform viewing utility");
  m_oChoViewer    .GetParent( )->SetToolTip( os1 );
  os1 = wxT("The temporary file management strategy to be used");
  m_oChoTmpFileMgt.GetParent( )->SetToolTip( os1 );
  os1 = wxT("Select the precision of the result");
  m_oChoPrecision .GetParent( )->SetToolTip( os1 );
  os1 = wxT("The maximum number of lines which may be displayed in a text control");
  m_oPnlMaxLines                .SetToolTip( os1 );
  os1 = wxT("Enable or disable tool tips");
  m_oCbxToolTips                .SetToolTip( os1 );
}

//*****************************************************************************
// Layout the display objects within the dialog.

void  DlgPrefs::DoLayout( void )
{
  wxBoxSizer  * poSzrDlg;
  wxPanel     * poPnlPrefs, * poPnlBtns;
  wxPanel     * poPnlViewer, * poPnlTmpFileMgt, * poPnlPrecision, * poPnlToolTips;
  wxBoxSizer  * poSzrPrefs, * poSzrBtns;
  wxBoxSizer  * poSzrViewer, * poSzrTmpFileMgt, * poSzrPrecision, * poSzrToolTips;
  wxSizerFlags  oFlags;

  // Get pointers to the various panels
  poPnlPrefs      = (wxPanel *) m_oPnlMaxLines  .GetParent( );
  poPnlBtns       = (wxPanel *) m_oBtnOk        .GetParent( );
  poPnlViewer     = (wxPanel *) m_oChoViewer    .GetParent( );
  poPnlTmpFileMgt = (wxPanel *) m_oChoTmpFileMgt.GetParent( );
  poPnlPrecision  = (wxPanel *) m_oChoPrecision .GetParent( );
  poPnlToolTips   = (wxPanel *) m_oCbxToolTips  .GetParent( );

  // Create sizers to associate with the panels
  poSzrDlg        = new wxBoxSizer      ( wxVERTICAL   );
  poSzrPrefs      = new wxStaticBoxSizer( wxVERTICAL, poPnlPrefs );
  poSzrBtns       = new wxBoxSizer      ( wxHORIZONTAL );
  poSzrViewer     = new wxBoxSizer      ( wxHORIZONTAL );
  poSzrTmpFileMgt = new wxBoxSizer      ( wxHORIZONTAL );
  poSzrPrecision  = new wxBoxSizer      ( wxHORIZONTAL );
  poSzrToolTips   = new wxBoxSizer      ( wxVERTICAL   );

  // Set the sizers to the panels
                   SetSizer( poSzrDlg        );
  poPnlPrefs     ->SetSizer( poSzrPrefs      );
  poPnlBtns      ->SetSizer( poSzrBtns       );
  poPnlViewer    ->SetSizer( poSzrViewer     );
  poPnlTmpFileMgt->SetSizer( poSzrTmpFileMgt );
  poPnlPrecision ->SetSizer( poSzrPrecision  );
  poPnlToolTips  ->SetSizer( poSzrToolTips   );

  // Layout the choice control panel
  oFlags.Align( wxALIGN_CENTER );
  oFlags.Border( wxTOP | wxBOTTOM, 1 );
  poSzrViewer    ->Add( &m_oLblViewer    , oFlags );
  poSzrViewer    ->Add( &m_oChoViewer    , oFlags );
  poSzrViewer    ->SetSizeHints( poPnlViewer );
  poSzrTmpFileMgt->Add( &m_oLblTmpFileMgt, oFlags );
  poSzrTmpFileMgt->Add( &m_oChoTmpFileMgt, oFlags );
  poSzrTmpFileMgt->SetSizeHints( poPnlTmpFileMgt );
  poSzrPrecision ->Add( &m_oLblPrecision , oFlags );
  poSzrPrecision ->Add( &m_oChoPrecision , oFlags );
  poSzrPrecision ->SetSizeHints( poPnlPrecision );

  // Layout the check box panel
  oFlags.Align( wxALIGN_LEFT );
  oFlags.Border( wxTOP, 3 );
  poSzrToolTips->Add( &m_oCbxToolTips, oFlags );
  poSzrToolTips->SetSizeHints( poPnlToolTips );

  // Layout the preferences controls
  oFlags.Align( wxALIGN_LEFT );
  oFlags.Border( wxLEFT | wxRIGHT | wxTOP, 10 );
  poSzrPrefs->Add( poPnlViewer    , oFlags );
  oFlags.Border( wxLEFT,                   10 );
  poSzrPrefs->Add( poPnlTmpFileMgt, oFlags );
  poSzrPrefs->Add( poPnlPrecision , oFlags );
  poSzrPrefs->Add( &m_oPnlMaxLines, oFlags );
  oFlags.Border( wxLEFT | wxBOTTOM,         8 );
  poSzrPrefs->Add( poPnlToolTips,   oFlags );
  poSzrPrefs->SetSizeHints( poPnlPrefs );

  // Layout the buttons
  oFlags.Border( wxTOP | wxBOTTOM, 10 );
  oFlags.Align( wxALIGN_RIGHT );
  poSzrBtns->Add( &m_oBtnOk    , oFlags );
  poSzrBtns->AddSpacer( 10 );
  oFlags.Align( wxALIGN_LEFT );
  poSzrBtns->Add( &m_oBtnCancel, oFlags );
  poSzrBtns->SetSizeHints( poPnlBtns );

  // Layout the underlying dialog
  oFlags.Align( wxALIGN_TOP | wxALIGN_CENTER_HORIZONTAL );
  oFlags.Border( wxALL,    15 );
  GetSizer( )->Add( poPnlPrefs, oFlags );
  oFlags.Border( wxBOTTOM, 10 );
  GetSizer( )->Add( poPnlBtns , oFlags );
  GetSizer( )->SetSizeHints( this );
}

//*****************************************************************************
// Load the values into the display controls from the configuration file.

void  DlgPrefs::Load( void )
{
  wxString  os1;
  long      li1;

  SetEvtHandlerEnabled( FALSE );

  m_poCfg->SetPath( wxT("/Viewer") );
  m_poCfg->Read( wxT("Name"),        &os1, CLP_GWAVE );
  for( li1=0; (uint)li1<m_oChoViewer.GetCount( ); li1++ )
  {
    if( m_oChoViewer.GetString( (uint) li1 ).Upper( ) == os1 )
    {
      m_oChoViewer.SetSelection( (uint) li1 );
      break;
    }
  }

  m_poCfg->SetPath( wxT("/Main") );

  m_poCfg->Read( wxT("TmpFileMgt"),  &li1, eTFMS_DELETE );
  m_oChoTmpFileMgt.SetSelection( li1 );

  m_poCfg->Read( wxT("Precision"),   &li1, CNVTYPE_DFLT_FLTRES );
  m_oChoPrecision.SetSelection( li1-1 );

  m_poCfg->Read( wxT("NbkMaxLines"), &li1, TXTCTL_LINESDEF );
  m_oPnlMaxLines.bSetValue( li1 );

  m_poCfg->Read( wxT("ToolTips"),    &li1, 0 );
  m_oCbxToolTips.SetValue( li1 != 0 ? TRUE : FALSE );

  SetEvtHandlerEnabled( TRUE );
}

//*****************************************************************************
// Save the values in the display controls in the configuration file.

void  DlgPrefs::Save( void )
{
  wxString  os1;
  long      li1;

  SetEvtHandlerEnabled( FALSE );

  m_poCfg->SetPath( wxT("/Viewer") );
  os1 = m_oChoViewer.GetStringSelection( ).Upper( );
  m_poCfg->Write( wxT("Name"),        os1 );

  m_poCfg->SetPath( wxT("/Main") );

  li1 = m_oChoTmpFileMgt.GetSelection( );
  m_poCfg->Write( wxT("TmpFileMgt"),  li1 );

  li1 = m_oChoPrecision.GetSelection( ) + 1;
  m_poCfg->Write( wxT("Precision"),   li1 );
  ConvertType::bSetFltRes( (int) li1 );

  li1 = m_oPnlMaxLines.liGetValue( );
  m_poCfg->Write( wxT("NbkMaxLines"), li1 );

  li1 = ( m_oCbxToolTips.GetValue( ) ? 1 : 0 );
  m_poCfg->Write( wxT("ToolTips"),    li1 );
  wxToolTip::Enable( li1 != 0 ? TRUE : FALSE );

  m_poCfg->Flush( );

  SetEvtHandlerEnabled( TRUE );
}

//*****************************************************************************
// Reset all dialog settings to defaults.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  DlgPrefs::bClear( void )
{
  Load( );

  return( TRUE );
}

//*****************************************************************************
//
//                             Event Handlers
//
//*****************************************************************************
// Ok button event handler.
//
// Argument List:
//   roEvtCmd - An object holding information about the event (not used)

void  DlgPrefs::OnBtnOk( wxCommandEvent & roEvtCmd )
{
  Save( );

  EndModal( wxID_OK );
}

//*****************************************************************************
// Cancel button event handler.
//
// Argument List:
//   roEvtCmd - An object holding information about the event (not used)

void  DlgPrefs::OnBtnCancel( wxCommandEvent & roEvtCmd )
{
  Load( );

  EndModal( wxID_CANCEL );
}

//*****************************************************************************
